/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.workstumps.block;

import com.codetaylor.mc.artisanworkstumps.modules.tanks.block.BlockTankBase;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.TileWorkstump;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.workstump.EnumDamagedSide;
import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWorkstump
extends BlockPartialBase
implements IBlockInteractable {
    public static final String NAME_TAILOR = "workstump_tailor";
    public static final String NAME_CARPENTER = "workstump_carpenter";
    public static final String NAME_MASON = "workstump_mason";
    public static final String NAME_BLACKSMITH = "workstump_blacksmith";
    public static final String NAME_JEWELER = "workstump_jeweler";
    public static final String NAME_BASIC = "workstump_basic";
    public static final String NAME_ENGINEER = "workstump_engineer";
    public static final String NAME_MAGE = "workstump_mage";
    public static final String NAME_SCRIBE = "workstump_scribe";
    public static final String NAME_CHEMIST = "workstump_chemist";
    public static final String NAME_FARMER = "workstump_farmer";
    public static final String NAME_CHEF = "workstump_chef";
    public static final String NAME_DESIGNER = "workstump_designer";
    public static final String NAME_TANNER = "workstump_tanner";
    public static final String NAME_POTTER = "workstump_potter";
    public static final PropertyInteger CONDITION = PropertyInteger.func_177719_a((String)"condition", (int)0, (int)4);
    public static final PropertyBool DAMAGED_EAST = PropertyBool.func_177716_a((String)"damaged_east");
    public static final PropertyBool DAMAGED_WEST = PropertyBool.func_177716_a((String)"damaged_west");
    public static final PropertyBool DAMAGED_SOUTH = PropertyBool.func_177716_a((String)"damaged_south");
    private final String tableName;

    public BlockWorkstump(String tableName) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.tableName = tableName;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DAMAGED_EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DAMAGED_WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DAMAGED_SOUTH, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public String getHarvestTool(@Nonnull IBlockState state) {
        return "axe";
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return this.interactionRayTrace(super.func_180636_a(blockState, world, pos, start, end), blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing != EnumFacing.UP && this.isFluidTank(player, hand)) {
            return false;
        }
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    private boolean isFluidTank(EntityPlayer player, EnumHand hand) {
        return Block.func_149634_a((Item)player.func_184586_b(hand).func_77973_b()) instanceof BlockTankBase;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_175625_s(pos)) instanceof TileWorkstump) {
            ((TileWorkstump)tileEntity).dropContents();
        }
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this, (int)1, (int)0, (TileEntity)world.func_175625_s(pos)));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileWorkstump(this.tableName);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL, CONDITION, DAMAGED_EAST, DAMAGED_WEST, DAMAGED_SOUTH});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176745_a() - 2;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileWorkstump) {
            TileWorkstump tileWorkstump = (TileWorkstump)tileEntity;
            int durability = tileWorkstump.getDurability();
            int remainingDurability = tileWorkstump.getRemainingDurability();
            float durabilityPercentage = (float)remainingDurability / (float)durability;
            state = (double)durabilityPercentage < 0.05 ? state.func_177226_a((IProperty)CONDITION, (Comparable)Integer.valueOf(4)) : ((double)durabilityPercentage < 0.25 ? state.func_177226_a((IProperty)CONDITION, (Comparable)Integer.valueOf(3)) : ((double)durabilityPercentage < 0.5 ? state.func_177226_a((IProperty)CONDITION, (Comparable)Integer.valueOf(2)) : ((double)durabilityPercentage < 0.75 ? state.func_177226_a((IProperty)CONDITION, (Comparable)Integer.valueOf(1)) : state.func_177226_a((IProperty)CONDITION, (Comparable)Integer.valueOf(0)))));
            state = state.func_177226_a((IProperty)DAMAGED_EAST, (Comparable)Boolean.valueOf(tileWorkstump.isSideDamaged(EnumDamagedSide.East)));
            state = state.func_177226_a((IProperty)DAMAGED_WEST, (Comparable)Boolean.valueOf(tileWorkstump.isSideDamaged(EnumDamagedSide.West)));
            state = state.func_177226_a((IProperty)DAMAGED_SOUTH, (Comparable)Boolean.valueOf(tileWorkstump.isSideDamaged(EnumDamagedSide.South)));
        }
        return state;
    }
}

