/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.tanks.block;

import com.codetaylor.mc.artisanworkstumps.modules.tanks.tile.TileTankBase;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.block.BlockWorkstump;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.tile.TileWorkstump;
import com.codetaylor.mc.athenaeum.interaction.spi.IBlockInteractable;
import com.codetaylor.mc.athenaeum.interaction.spi.IInteraction;
import com.codetaylor.mc.athenaeum.spi.BlockPartialBase;
import com.codetaylor.mc.athenaeum.util.AABBHelper;
import com.codetaylor.mc.athenaeum.util.Properties;
import com.codetaylor.mc.athenaeum.util.StackHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class BlockTankBase
extends BlockPartialBase
implements IBlockInteractable {
    protected static final AxisAlignedBB AABB_NORTH = AABBHelper.create((double)4.0, (double)8.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    protected static final AxisAlignedBB AABB_EAST = AABBHelper.create((double)2.0, (double)8.0, (double)4.0, (double)14.0, (double)16.0, (double)16.0);
    protected static final AxisAlignedBB AABB_SOUTH = AABBHelper.create((double)0.0, (double)8.0, (double)2.0, (double)12.0, (double)16.0, (double)14.0);
    protected static final AxisAlignedBB AABB_WEST = AABBHelper.create((double)2.0, (double)8.0, (double)0.0, (double)14.0, (double)16.0, (double)12.0);

    public BlockTankBase(Material material) {
        super(material);
    }

    protected abstract int getCapacity();

    protected abstract boolean holdsHotFluids();

    protected abstract boolean holdsContentsWhenBroken();

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileTankBase) {
            TileTankBase tile = (TileTankBase)tileEntity;
            FluidTank fluidTank = tile.getFluidTank();
            FluidStack fluid = fluidTank.getFluid();
            int fluidAmount = fluidTank.getFluidAmount();
            if (fluid != null && fluidAmount > 0) {
                int luminosity = fluid.getFluid().getLuminosity(fluid);
                return MathHelper.func_76125_a((int)luminosity, (int)0, (int)15);
            }
        }
        return super.getLightValue(state, world, pos);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult result = super.func_180636_a(blockState, world, pos, start, end);
        return this.interactionRayTrace(result, blockState, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.interact(IInteraction.EnumType.MouseClick, world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        EnumFacing facing;
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() instanceof BlockTankBase && world.func_175623_d(pos.func_177972_a(facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL))) && world instanceof WorldServer) {
            ((WorldServer)world).func_175655_b(pos, true);
        }
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.holdsContentsWhenBroken()) {
            drops.add((Object)StackHelper.createItemStackFromTileEntity((Block)this, (int)1, (int)0, (TileEntity)world.func_175625_s(pos)));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_176198_a(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        BlockPos offset = pos.func_177972_a(side.func_176734_d());
        TileEntity tileEntity = world.func_175625_s(offset);
        if (!(tileEntity instanceof TileWorkstump)) {
            return false;
        }
        if (((TileWorkstump)tileEntity).hasFluidStump()) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(offset);
        if (!(blockState.func_177230_c() instanceof BlockWorkstump)) {
            return false;
        }
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        if (facing == side) {
            return false;
        }
        if (((TileWorkstump)tileEntity).isSideDamaged(side)) {
            return false;
        }
        return super.func_176198_a(world, pos, side);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing opposite = facing.func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)opposite);
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isSideSolid(IBlockState base_state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL);
        switch (facing) {
            case NORTH: {
                return AABB_WEST;
            }
            case EAST: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_EAST;
            }
            case WEST: {
                return AABB_SOUTH;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flag) {
        NBTTagCompound tileTag;
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            this.addInformationCapacity(tooltip);
        } else if (stackTag.func_74764_b("BlockEntityTag") && (tileTag = stackTag.func_74775_l("BlockEntityTag")).func_74764_b("tank")) {
            NBTTagCompound tankTag = tileTag.func_74775_l("tank");
            if (tankTag.func_74764_b("Empty") && (!tankTag.func_74764_b("Amount") || tankTag.func_74762_e("Amount") <= 0)) {
                this.addInformationCapacity(tooltip);
            } else {
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankTag);
                if (fluidStack != null) {
                    String localizedName = fluidStack.getLocalizedName();
                    int amount = fluidStack.amount;
                    int capacity = this.getCapacity();
                    tooltip.add(I18n.func_74837_a((String)"gui.artisanworkstumps.tooltip.fluid", (Object[])new Object[]{localizedName, amount, capacity}));
                }
            }
        }
        boolean hotFluids = this.holdsHotFluids();
        tooltip.add((hotFluids ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.artisanworkstumps.tooltip.hot.fluids." + hotFluids), (Object[])new Object[0]));
        boolean holdsContents = this.holdsContentsWhenBroken();
        tooltip.add((holdsContents ? TextFormatting.GREEN : TextFormatting.RED) + I18n.func_74837_a((String)("gui.artisanworkstumps.tooltip.contents.retain." + holdsContents), (Object[])new Object[0]));
    }

    private void addInformationCapacity(@Nonnull List<String> tooltip) {
        int capacity = this.getCapacity();
        tooltip.add(I18n.func_74837_a((String)"gui.artisanworkstumps.tooltip.fluid.capacity", (Object[])new Object[]{capacity}));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING_HORIZONTAL});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)Properties.FACING_HORIZONTAL, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Properties.FACING_HORIZONTAL)).func_176745_a() - 2;
    }
}

