/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.core.plugin.top;

import com.codetaylor.mc.artisanworkstumps.ModArtisanWorkstumps;
import com.codetaylor.mc.artisanworkstumps.modules.core.plugin.top.PluginTOP;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.util.I18nHelper;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class ElementTextLocalized
implements IElement {
    private static final byte DATA_TYPE_STRING = 0;
    private static final byte DATA_TYPE_FLOAT = 1;
    private static final byte DATA_TYPE_DOUBLE = 2;
    private static final byte DATA_TYPE_INT = 3;
    private static final byte DATA_TYPE_LONG = 4;
    private static final byte DATA_TYPE_ITEM_STACK = 5;
    private static final byte DATA_TYPE_FLUID_STACK = 6;
    private String textFormatting;
    private String langKey;
    private Object[] args;
    private String renderText;

    public ElementTextLocalized(String langKey, Object ... args) {
        this(null, langKey, args);
    }

    public ElementTextLocalized(@Nullable TextFormatting textFormatting, String langKey, Object ... args) {
        this.textFormatting = textFormatting != null ? textFormatting.toString() : null;
        this.langKey = langKey;
        this.args = args;
    }

    ElementTextLocalized(ByteBuf buf) {
        this.fromBytes(buf);
        this.renderText = this.textFormatting != null ? this.textFormatting + I18nHelper.translateFormatted(this.langKey, this.args) : I18nHelper.translateFormatted(this.langKey, this.args);
    }

    public void render(int x, int y) {
        ElementTextRender.render((String)this.renderText, (int)x, (int)y);
    }

    public int getWidth() {
        return ElementTextRender.getWidth((String)this.renderText);
    }

    public int getHeight() {
        return 10;
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer b = new PacketBuffer(buf);
        b.writeInt(this.langKey.length());
        b.func_180714_a(this.langKey);
        if (this.textFormatting == null) {
            b.writeInt(0);
        } else {
            b.writeInt(this.textFormatting.length());
            b.func_180714_a(this.textFormatting);
        }
        if (this.args == null || this.args.length == 0) {
            b.writeInt(0);
        } else {
            b.writeInt(this.args.length);
            for (Object arg : this.args) {
                if (arg instanceof String) {
                    b.writeByte(0);
                    b.writeInt(((String)arg).length());
                    b.func_180714_a((String)arg);
                    continue;
                }
                if (arg instanceof Float) {
                    b.writeByte(1);
                    b.writeFloat(((Float)arg).floatValue());
                    continue;
                }
                if (arg instanceof Double) {
                    b.writeByte(2);
                    b.writeDouble(((Double)arg).doubleValue());
                    continue;
                }
                if (arg instanceof Integer) {
                    b.writeByte(3);
                    b.writeInt(((Integer)arg).intValue());
                    continue;
                }
                if (arg instanceof Long) {
                    b.writeByte(4);
                    b.writeLong(((Long)arg).longValue());
                    continue;
                }
                if (arg instanceof ItemStack) {
                    b.writeByte(5);
                    b.func_150788_a((ItemStack)arg);
                    continue;
                }
                if (arg instanceof FluidStack) {
                    b.writeByte(6);
                    b.func_150786_a(((FluidStack)arg).writeToNBT(new NBTTagCompound()));
                    continue;
                }
                throw new RuntimeException("Unknown data type: " + arg.getClass());
            }
        }
    }

    private void fromBytes(ByteBuf buf) {
        PacketBuffer b = new PacketBuffer(buf);
        this.langKey = b.func_150789_c(b.readInt());
        int textFormattingStringLength = b.readInt();
        if (textFormattingStringLength > 0) {
            this.textFormatting = b.func_150789_c(textFormattingStringLength);
        }
        int argCount = b.readInt();
        this.args = new Object[argCount];
        block13: for (int i = 0; i < argCount; ++i) {
            byte dataType = b.readByte();
            switch (dataType) {
                case 0: {
                    int length = b.readInt();
                    String key = b.func_150789_c(length);
                    this.args[i] = I18nHelper.translateFormatted(key, new Object[0]);
                    continue block13;
                }
                case 1: {
                    this.args[i] = Float.valueOf(b.readFloat());
                    continue block13;
                }
                case 2: {
                    this.args[i] = b.readDouble();
                    continue block13;
                }
                case 3: {
                    this.args[i] = b.readInt();
                    continue block13;
                }
                case 4: {
                    this.args[i] = b.readLong();
                    continue block13;
                }
                case 5: {
                    try {
                        this.args[i] = b.func_150791_c().func_82833_r();
                    }
                    catch (IOException e) {
                        ModArtisanWorkstumps.LOGGER.error("", (Throwable)e);
                        this.args[i] = "ERROR";
                    }
                    continue block13;
                }
                case 6: {
                    try {
                        NBTTagCompound compound = b.func_150793_b();
                        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
                        if (fluidStack == null) {
                            this.args[i] = "ERROR";
                            continue block13;
                        }
                        this.args[i] = fluidStack.getLocalizedName();
                    }
                    catch (Exception e) {
                        ModArtisanWorkstumps.LOGGER.error("", (Throwable)e);
                        this.args[i] = "ERROR";
                    }
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unknown data type: " + dataType);
                }
            }
        }
    }

    public int getID() {
        return PluginTOP.ELEMENT_TEXT_LOCALIZED;
    }
}

