/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.artisanworkstumps.modules.core.plugin.top;

import com.codetaylor.mc.artisanworkstumps.modules.core.plugin.top.PluginTOP;
import com.codetaylor.mc.artisanworkstumps.modules.workstumps.util.I18nHelper;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;

public class ElementTankLabel
implements IElement {
    private final String textFormatting;
    private final FluidStack fluidStack;
    private final int capacity;
    private String renderText;
    public static final String LANG_KEY = "gui.artisanworkstumps.waila.tank.fluid";

    public ElementTankLabel(@Nullable TextFormatting textFormatting, FluidStack fluidStack, int capacity) {
        this.textFormatting = textFormatting == null ? null : textFormatting.toString();
        this.fluidStack = (FluidStack)Preconditions.checkNotNull((Object)fluidStack);
        this.capacity = capacity;
    }

    public ElementTankLabel(ByteBuf buf) {
        NBTTagCompound compound;
        int length = buf.readInt();
        this.textFormatting = length > 0 ? new PacketBuffer(buf).func_150789_c(length) : null;
        try {
            compound = new PacketBuffer(buf).func_150793_b();
        }
        catch (IOException e) {
            this.fluidStack = null;
            throw new RuntimeException("", e);
        }
        this.capacity = buf.readInt();
        this.fluidStack = compound != null ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound) : null;
        if (this.fluidStack != null) {
            StringBuilder builder = new StringBuilder();
            if (this.textFormatting != null) {
                String localizedName = this.fluidStack.getLocalizedName();
                this.renderText = this.textFormatting + I18nHelper.translateFormatted(LANG_KEY, localizedName, this.fluidStack.amount, this.capacity);
            } else {
                String localizedName = this.fluidStack.getLocalizedName();
                this.renderText = I18nHelper.translateFormatted(LANG_KEY, localizedName, this.fluidStack.amount, this.capacity);
            }
        }
    }

    public void render(int x, int y) {
        if (this.renderText != null) {
            ElementTextRender.render((String)this.renderText, (int)x, (int)y);
        }
    }

    public int getWidth() {
        if (this.renderText != null) {
            return ElementTextRender.getWidth((String)this.renderText);
        }
        return 10;
    }

    public int getHeight() {
        return 10;
    }

    public void toBytes(ByteBuf buf) {
        if (this.textFormatting == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.textFormatting.length());
            new PacketBuffer(buf).func_180714_a(this.textFormatting);
        }
        NBTTagCompound compound = this.fluidStack.writeToNBT(new NBTTagCompound());
        new PacketBuffer(buf).func_150786_a(compound);
        buf.writeInt(this.capacity);
    }

    public int getID() {
        return PluginTOP.ELEMENT_TANK_LABEL;
    }
}

