/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.jvm.util;

import io.github.toolfactory.jvm.Info;
import io.github.toolfactory.jvm.InfoImpl;
import io.github.toolfactory.jvm.function.template.Consumer;
import io.github.toolfactory.jvm.util.Strings;
import java.io.File;
import java.util.Locale;
import org.burningwave.jvm.NativeExecutor;
import org.burningwave.jvm.util.Files;

public class Libraries {
    String conventionedSuffix;
    String extension;
    String prefix;

    private Libraries() {
        InfoImpl jVMInfo = (InfoImpl)Info.Provider.getInfoInstance();
        if (jVMInfo.is32Bit()) {
            this.conventionedSuffix = "x32";
        } else if (jVMInfo.is64Bit()) {
            this.conventionedSuffix = "x64";
        }
        String osArch = jVMInfo.osArch != null ? jVMInfo.osArch : "generic";
        String operatingSystemName = jVMInfo.operatingSystemName != null ? jVMInfo.operatingSystemName.toLowerCase(Locale.ENGLISH) : "generic";
        this.prefix = "lib";
        if (osArch.equals("aarch64")) {
            this.conventionedSuffix = osArch;
            this.extension = "so";
        } else if (operatingSystemName.indexOf("mac") >= 0 || operatingSystemName.indexOf("darwin") >= 0) {
            this.extension = "dylib";
        } else if (operatingSystemName.indexOf("win") >= 0) {
            this.prefix = null;
            this.extension = "dll";
        } else if (operatingSystemName.indexOf("nux") >= 0) {
            this.extension = "so";
        } else {
            throw new InitializeException(Strings.compile("Unable to initialize {}: unsupported operating system ('{}-{}')", this, operatingSystemName, osArch));
        }
    }

    public static Libraries getInstance() {
        return Holder.getWithinInstance();
    }

    static Libraries create() {
        return new Libraries();
    }

    public String loadFor(Class<?> clazz) {
        String libName = clazz.getPackage().getName();
        libName = libName != null ? libName.replace(".", "/") + "/" : "";
        if (this.prefix != null) {
            libName = libName + this.prefix;
        }
        libName = libName + clazz.getSimpleName() + "-" + this.conventionedSuffix + "." + this.extension;
        Files.extractAndExecute(NativeExecutor.class, libName, new Consumer<File>(){

            @Override
            public void accept(File libraryFile) {
                System.load(libraryFile.getAbsolutePath());
            }
        });
        return clazz.getSimpleName() + "-" + this.conventionedSuffix;
    }

    public static class InitializeException
    extends RuntimeException {
        private static final long serialVersionUID = 424757273075028708L;

        public InitializeException(String message, Throwable cause) {
            super(message, cause);
        }

        public InitializeException(String message) {
            super(message);
        }
    }

    private static class Holder {
        private static final Libraries INSTANCE = Libraries.create();

        private Holder() {
        }

        private static Libraries getWithinInstance() {
            return INSTANCE;
        }
    }
}

