/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.jvm.util;

import io.github.toolfactory.jvm.function.template.Consumer;
import io.github.toolfactory.jvm.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.burningwave.jvm.util.TempFileHolder;

public class Files {
    public static void extractAndExecute(Class<?> callerClass, String resourcePath, Consumer<File> extractedFileConsumer) {
        try (InputStream inputStream = callerClass.getResourceAsStream(resourcePath.startsWith("/") ? resourcePath : "/" + resourcePath);){
            if (inputStream == null) {
                throw new FileNotFoundException("Could not find file: " + resourcePath);
            }
            String filename = resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
            try (TempFileHolder tempFileHandler = new TempFileHolder(filename);){
                byte[] buffer = new byte[1024];
                try (FileOutputStream os = new FileOutputStream(tempFileHandler.getFile());){
                    int readBytes;
                    while ((readBytes = inputStream.read(buffer)) != -1) {
                        ((OutputStream)os).write(buffer, 0, readBytes);
                    }
                }
                extractedFileConsumer.accept(tempFileHandler.getFile());
            }
        }
        catch (Throwable exc) {
            throw new NotLoadedException(Strings.compile("Unable to load file {}", resourcePath), exc);
        }
    }

    public static class NotLoadedException
    extends RuntimeException {
        private static final long serialVersionUID = -461698261422622020L;

        public NotLoadedException(String message, Throwable cause) {
            super(message, cause);
        }

        public NotLoadedException(String message) {
            super(message);
        }
    }
}

