/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Member;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.CriteriaWithClassElementsSupplyingSupport;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.function.PentaPredicate;

public class ClassCriteria
extends CriteriaWithClassElementsSupplyingSupport<Class<?>, ClassCriteria, TestContext> {
    Map<String, MemberCriteria<?, ?, ?>> memberCriterias = new HashMap();
    PentaPredicate<ClassCriteria, TestContext, MemberCriteria<?, ?, ?>, String, Class<?>> membersPredicate;
    private boolean collectMembers;

    private ClassCriteria() {
    }

    void init(ClassLoader classSupplier) {
        this.classSupplier = cls -> {
            try {
                return StaticComponentContainer.ClassLoaders.loadOrDefine(cls, classSupplier);
            }
            catch (ClassNotFoundException exc) {
                return (Class)StaticComponentContainer.Driver.throwException(exc);
            }
        };
        this.byteCodeSupplier = StaticComponentContainer.Classes::getByteCode;
        Collection<Class<?>> usedClasses = this.getClassesToBeUploaded() != null ? this.getClassesToBeUploaded() : new HashSet();
        for (MemberCriteria<?, ?, ?> memberCriteria : this.memberCriterias.values()) {
            memberCriteria.init(this.classSupplier, this.byteCodeSupplier);
            if (memberCriteria.getClassesToBeUploaded() == null) continue;
            usedClasses.addAll(memberCriteria.getClassesToBeUploaded());
        }
        if (!usedClasses.isEmpty()) {
            for (MemberCriteria<?, ?, ?> memberCriteria : this.memberCriterias.values()) {
                memberCriteria.useClasses(usedClasses);
            }
            this.useClasses(usedClasses);
        }
        this.membersPredicate = this.collectMembers ? this::testAndCollectMembers : this::testMembers;
    }

    public ClassCriteria allThoseThatHaveAMatchInHierarchy(BiPredicate<TestContext, Class<?>> predicate) {
        return (ClassCriteria)super.allThoseThatMatch((T testContext, E cls) -> {
            while (cls != null) {
                if (predicate.test((TestContext)testContext, (Class<?>)cls)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
            return false;
        });
    }

    public ClassCriteria allThoseThatHaveAMatchInHierarchy(Predicate<Class<?>> predicate) {
        return (ClassCriteria)super.allThoseThatMatch((E cls) -> {
            while (cls != null) {
                if (predicate.test((Class<?>)cls)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
            return false;
        });
    }

    public ClassCriteria byClassesThatHaveAMatchInHierarchy(BiPredicate<Map<Class<?>, Class<?>>, Class<?>> predicate) {
        return this.byClassesThatMatch((uploadedClasses, cls) -> {
            while (cls != null) {
                if (predicate.test((Map<Class<?>, Class<?>>)uploadedClasses, (Class<?>)cls)) {
                    return true;
                }
                cls = cls.getSuperclass();
            }
            return false;
        });
    }

    public ClassCriteria byClassesThatMatch(BiPredicate<Map<Class<?>, Class<?>>, Class<?>> predicate) {
        this.predicate = this.concat(this.predicate, (context, cls) -> predicate.test(((ClassCriteria)context.getCriteria()).getUploadedClasses(), (Class<?>)cls));
        return this;
    }

    public static ClassCriteria create() {
        return new ClassCriteria();
    }

    @Override
    protected ClassCriteria logicOperation(ClassCriteria leftCriteria, ClassCriteria rightCriteria, Function<BiPredicate<TestContext, Class<?>>, Function<BiPredicate<? super TestContext, ? super Class<?>>, BiPredicate<TestContext, Class<?>>>> binaryOperator, ClassCriteria targetCriteria) {
        leftCriteria.memberCriterias.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MemberCriteria)entry.getValue()).createCopy(), (o1, o2) -> o1, () -> targetCriteria.memberCriterias));
        rightCriteria.memberCriterias.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MemberCriteria)entry.getValue()).createCopy(), (o1, o2) -> o1, () -> targetCriteria.memberCriterias));
        targetCriteria.collectMembers = leftCriteria.collectMembers || rightCriteria.collectMembers;
        return super.logicOperation(leftCriteria, rightCriteria, binaryOperator, targetCriteria);
    }

    public ClassCriteria packageName(Predicate<String> predicate) {
        this.predicate = this.concat(this.predicate, (testContext, cls) -> {
            Package pckg = cls.getPackage();
            return pckg != null ? predicate.test(pckg.getName()) : predicate.test(null);
        });
        return this;
    }

    public ClassCriteria className(Predicate<String> predicate) {
        this.predicate = this.concat(this.predicate, (testContext, cls) -> predicate.test(cls.getName()));
        return this;
    }

    public ClassCriteria byBytecode(Predicate<byte[]> predicate) {
        this.predicate = this.concat(this.predicate, (context, cls) -> {
            ClassCriteria criteria = (ClassCriteria)context.getCriteria();
            return predicate.test(StaticComponentContainer.BufferHandler.toByteArray((ByteBuffer)criteria.byteCodeSupplier.apply(cls)));
        });
        return this;
    }

    public ClassCriteria byBytecode(BiPredicate<Map<Class<?>, byte[]>, byte[]> predicate) {
        this.predicate = this.concat(this.predicate, (context, cls) -> {
            ClassCriteria criteria = (ClassCriteria)context.getCriteria();
            return predicate.test(criteria.getLoadedBytecode(), StaticComponentContainer.BufferHandler.toByteArray((ByteBuffer)criteria.byteCodeSupplier.apply(cls)));
        });
        return this;
    }

    public <M extends Member> ClassCriteria byMembers(MemberCriteria<?, ?, ?> memberCriteria) {
        String key = UUID.randomUUID().toString();
        this.memberCriterias.put(key, memberCriteria);
        this.predicate = this.concat(this.predicate, (context, cls) -> {
            ClassCriteria criteria = (ClassCriteria)context.getCriteria();
            return criteria.membersPredicate.test(criteria, (TestContext)context, memberCriteria, key, (Class<?>)cls);
        });
        this.collectMembers = true;
        return this;
    }

    private boolean testMembers(ClassCriteria criteria, TestContext context, MemberCriteria<?, ?, ?> memberCriteria, String key, Class<?> cls) {
        return StaticComponentContainer.Members.match(criteria.memberCriterias.get(key), cls);
    }

    private boolean testAndCollectMembers(ClassCriteria criteria, TestContext context, MemberCriteria<?, ?, ?> memberCriteria, String key, Class<?> cls) {
        Collection<Member> members = StaticComponentContainer.Members.findAll(criteria.memberCriterias.get(key), cls);
        context.addMembersFound(memberCriteria, members);
        return !members.isEmpty();
    }

    @Override
    public ClassCriteria createCopy() {
        ClassCriteria copy = (ClassCriteria)super.createCopy();
        this.memberCriterias.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((MemberCriteria)entry.getValue()).createCopy(), (o1, o2) -> o1, () -> copy.memberCriterias));
        copy.collectMembers = this.collectMembers;
        return copy;
    }

    @Override
    protected TestContext createTestContext() {
        return TestContext.create(this);
    }

    @Override
    public void close() {
        this.memberCriterias.clear();
        this.memberCriterias = null;
        this.membersPredicate = null;
        super.close();
    }

    public static class TestContext
    extends Criteria.TestContext<Class<?>, ClassCriteria> {
        protected TestContext(ClassCriteria criteria) {
            super(criteria);
            if (criteria.collectMembers) {
                this.put(Elements.MEMBERS_FOUND, new ConcurrentHashMap());
            }
        }

        public static TestContext create(ClassCriteria criteria) {
            return new TestContext(criteria);
        }

        public Map<MemberCriteria<?, ?, ?>, Collection<Member>> getMembersFound() {
            return (Map)this.get(Elements.MEMBERS_FOUND);
        }

        void addMembersFound(MemberCriteria<?, ?, ?> criteria, Collection<Member> members) {
            this.getMembersFound().put(criteria, members);
        }

        private static enum Elements {
            MEMBERS_FOUND;

        }
    }
}

