/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v21.common.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import mods.thecomputerizer.theimpossiblelibrary.api.common.effect.EffectInstanceAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.shared.v21.tag.CompoundTag1_21;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Entity1_21
extends EntityAPI<Entity, EntityType<?>> {
    public Entity1_21(Object entity) {
        this((Entity)entity);
    }

    Entity1_21(Entity entity) {
        super(entity, entity.getType());
    }

    @Override
    public boolean canTarget() {
        return this.entity instanceof Mob;
    }

    @Override
    public Collection<EffectInstanceAPI<?>> getActiveEffects() {
        return this.isLiving() ? (Collection)((LivingEntity)this.entity).getActiveEffects().stream().map(WrapperHelper::wrapEffectInstance).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public EntityAPI<?, ?> getAttackTarget() {
        if (!this.canTarget()) {
            return null;
        }
        Mob mob = (Mob)this.entity;
        if (mob.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return WrapperHelper.wrapEntity(mob.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null));
        }
        return WrapperHelper.wrapEntity(mob.getTarget());
    }

    @Override
    public Box getBoundingBox() {
        return Objects.nonNull(this.entity) ? this.getBoundingBox(((Entity)this.entity).getBoundingBox()) : null;
    }

    protected Box getBoundingBox(AABB box) {
        return new Box(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    @Override
    public CompoundTagAPI<?> getData() {
        CompoundTag tag = new CompoundTag();
        if (Objects.nonNull(this.entity)) {
            tag = new EntityDataAccessor((Entity)this.entity).getData();
        }
        return new CompoundTag1_21(tag);
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this.getWorld(), ((Entity)this.entity).level().dimensionType());
    }

    @Override
    public String getName() {
        return ((Entity)this.entity).getName().getString();
    }

    @Override
    public BlockPosAPI<?> getPos() {
        return WrapperHelper.wrapPosition(((Entity)this.entity).blockPosition());
    }

    @Override
    public EntityAPI<?, ?> getRootVehicle() {
        return WrapperHelper.wrapEntity(((Entity)this.entity).getRootVehicle());
    }

    @Override
    @Nullable
    public EntityAPI<?, ?> getVehicle() {
        Entity entity = ((Entity)this.entity).getVehicle();
        return Objects.nonNull(entity) ? WrapperHelper.wrapEntity(entity) : null;
    }

    @Override
    public WorldAPI<?> getWorld() {
        return WrapperHelper.wrapWorld(((Entity)this.entity).level());
    }

    @Override
    public boolean isAlive() {
        return ((Entity)this.entity).isAlive();
    }

    @Override
    public boolean isAnimal() {
        return this.entity instanceof Animal;
    }

    @Override
    public boolean isHostile() {
        return this.entity instanceof Enemy;
    }

    @Override
    public boolean isLiving() {
        return this.entity instanceof LivingEntity;
    }

    @Override
    public boolean isPlayer() {
        return this.entity instanceof Player;
    }

    @Override
    public boolean isOwnedBy(EntityAPI<?, ?> owner) {
        return this.entity instanceof TamableAnimal && ((TamableAnimal)this.entity).getOwner() == this.entity;
    }

    @Override
    public void setRegistryName(ResourceLocationAPI<?> registryName) {
        this.setLocalRegistryName(registryName);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        ((Entity)this.entity).setPos(x, y, z);
    }

    @Override
    public double x() {
        return ((Entity)this.entity).position().x;
    }

    @Override
    public double y() {
        return ((Entity)this.entity).position().y;
    }

    @Override
    public double z() {
        return ((Entity)this.entity).position().z;
    }
}

