/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v21.client.sound;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.ClientHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.client.sound.SoundHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.sound.SoundEventAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public class SoundHelper1_21
implements SoundHelperAPI {
    @Override
    public float getCategoryVolume(String name) {
        String categoryName = (name.equals("record") ? "records" : name).toUpperCase();
        SoundSource category = SoundSource.valueOf((String)categoryName);
        if (Objects.nonNull(category)) {
            Options options = Minecraft.getInstance().options;
            if (Objects.nonNull(options)) {
                return options.getSoundSourceVolume(category);
            }
            TILRef.logInfo("Getting sound level from cached options for {} ", categoryName);
            return ClientHelper.getCachedOptionSoundCategory(name);
        }
        TILRef.logError("Failed to get source volume for {} (nonexistent category)", categoryName);
        return 0.0f;
    }

    @Override
    public void play(SoundEventAPI<?> event) {
        SoundEvent sound = (SoundEvent)event.unwrap();
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f));
    }

    @Override
    public void setCategoryVolume(String name, float volume) {
        String categoryName = (name.equals("record") ? "records" : name).toUpperCase();
        SoundSource category = SoundSource.valueOf((String)categoryName);
        if (Objects.nonNull(category)) {
            Options options = Minecraft.getInstance().options;
            if (Objects.nonNull(options)) {
                options.getSoundSourceOptionInstance(category).set((Object)volume);
            } else {
                TILRef.logError("Failed to set source volume for {} to {} (null options)", categoryName, Float.valueOf(volume));
            }
        } else {
            TILRef.logError("Failed to set source volume for {} to {} (nonexistent category)", categoryName, Float.valueOf(volume));
        }
    }
}

