/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v20.server.event;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.Facing;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ActionResult;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.Hand;
import mods.thecomputerizer.theimpossiblelibrary.api.server.event.ServerEventsAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ServerEvents1_20
implements ServerEventsAPI {
    private boolean defined = false;

    protected ServerEvents1_20() {
    }

    @Override
    public void defineEvents() {
        this.defined = true;
    }

    @Override
    public <A> Box getAABB(A aabb) {
        AABB box = (AABB)aabb;
        return ShapeHelper.box(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    @Override
    public <A> ActionResult getActionResult(A result) {
        return switch ((InteractionResult)result) {
            default -> throw new IncompatibleClassChangeError();
            case InteractionResult.CONSUME, InteractionResult.CONSUME_PARTIAL -> ActionResult.CONSUME;
            case InteractionResult.PASS -> ActionResult.PASS;
            case InteractionResult.SUCCESS -> ActionResult.SUCCESS;
            case InteractionResult.FAIL -> ActionResult.FAIL;
        };
    }

    @Override
    @Nullable
    public <D> Facing getFacing(@Nullable D direction) {
        if (Objects.isNull(direction)) {
            return null;
        }
        return switch ((Direction)direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> Facing.DOWN;
            case Direction.EAST -> Facing.EAST;
            case Direction.NORTH -> Facing.NORTH;
            case Direction.SOUTH -> Facing.SOUTH;
            case Direction.UP -> Facing.UP;
            case Direction.WEST -> Facing.WEST;
        };
    }

    @Override
    public <H> Hand getHand(H hand) {
        return hand == InteractionHand.MAIN_HAND ? Hand.MAINHAND : Hand.OFFHAND;
    }

    @Override
    public <V> Vector3 getVec3d(V vector) {
        Vec3 vec = (Vec3)vector;
        return new Vector3(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }

    public <B> B setAABB(Box box) {
        return (B)new AABB(box.minX(), box.minY(), box.minZ(), box.maxX(), box.maxY(), box.maxZ());
    }

    @Override
    public <A> A setActionResult(ActionResult result) {
        return (A)(switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case ActionResult.CONSUME -> InteractionResult.CONSUME;
            case ActionResult.PASS -> InteractionResult.PASS;
            case ActionResult.SUCCESS -> InteractionResult.SUCCESS;
            case ActionResult.FAIL -> InteractionResult.FAIL;
        });
    }

    @Nullable
    public <F> F setFacing(@Nullable Facing facing) {
        if (Objects.isNull((Object)facing)) {
            return null;
        }
        return (F)(switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Facing.DOWN -> Direction.DOWN;
            case Facing.EAST -> Direction.EAST;
            case Facing.NORTH -> Direction.NORTH;
            case Facing.SOUTH -> Direction.SOUTH;
            case Facing.UP -> Direction.UP;
            case Facing.WEST -> Direction.WEST;
        });
    }

    @Override
    public <H> H setHand(Hand hand) {
        return (H)(hand == Hand.MAINHAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
    }

    @Override
    public <V> V setVec3d(Vector3 vector) {
        return (V)new Vec3(vector.dX(), vector.dY(), vector.dZ());
    }
}

