/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v19.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.shared.v19.common.biome.Biome1_19;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class World1_19
extends WorldAPI<LevelAccessor> {
    public World1_19(Object world) {
        super((LevelAccessor)world);
    }

    @Override
    public boolean canSnowAt(BlockPosAPI<?> api) {
        BlockPos pos = (BlockPos)api.unwrap();
        return ((Biome)((LevelAccessor)this.wrapped).m_204166_(pos).m_203334_()).m_198904_(pos);
    }

    @Override
    public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        BiomeAPI biome = WrapperHelper.wrapBiome(((LevelAccessor)this.wrapped).m_204166_((BlockPos)pos.unwrap()).m_203334_());
        ((Biome1_19)biome).setAccess(((LevelAccessor)this.wrapped).m_5962_());
        return biome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box box) {
        ArrayList entities = new ArrayList();
        if (this.wrapped instanceof Level) {
            LevelAccessor levelAccessor = (LevelAccessor)this.wrapped;
            synchronized (levelAccessor) {
                for (ChunkAccess chunk : this.getChunks(box)) {
                    for (BlockPos pos : chunk.m_5928_()) {
                        if (!box.isInside(pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) continue;
                        entities.add(WrapperHelper.wrapBlockEntity(chunk.m_7702_(pos)));
                    }
                }
            }
        }
        return entities;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> pos) {
        BlockEntity tile = ((LevelAccessor)this.wrapped).m_7702_((BlockPos)pos.unwrap());
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    Collection<ChunkAccess> getChunks(Box box) {
        HashSet<ChunkAccess> chunks = new HashSet<ChunkAccess>();
        for (double x = box.minX(); x < box.maxX(); x += 16.0) {
            double z = box.minZ();
            while (x < box.maxZ()) {
                int chunkX = SectionPos.m_123171_((int)((int)x));
                int chunkZ = SectionPos.m_123171_((int)((int)z));
                chunks.add(((LevelAccessor)this.wrapped).m_6325_(chunkX, chunkZ));
                x += 16.0;
            }
        }
        return chunks;
    }

    @Override
    public int getDayNumber() {
        return (int)((double)this.getTimeTotal() / 24000.0);
    }

    @Override
    public int getDifficultyOrdinal() {
        if (((LevelAccessor)this.wrapped).m_6106_().m_5466_()) {
            return 4;
        }
        return switch (((LevelAccessor)this.wrapped).m_46791_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 0;
            case Difficulty.EASY -> 1;
            case Difficulty.NORMAL -> 2;
            case Difficulty.HARD -> 3;
        };
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this, ((LevelAccessor)this.wrapped).m_6042_());
    }

    @Override
    public List<EntityAPI<?, ?>> getEntitiesInBox(Box box) {
        return this.getEntitiesInBox(new AABB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<EntityAPI<?, ?>> getEntitiesInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (Entity entity : ((LevelAccessor)this.wrapped).m_45976_(Entity.class, (AABB)box)) {
            entities.add(WrapperHelper.wrapEntity(entity));
        }
        return entities;
    }

    @Override
    public int getLightBlock(BlockPosAPI<?> pos) {
        return ((LevelAccessor)this.wrapped).m_45517_(LightLayer.BLOCK, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightSky(BlockPosAPI<?> pos) {
        return ((LevelAccessor)this.wrapped).m_45517_(LightLayer.SKY, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightTotal(BlockPosAPI<?> pos) {
        return ((LevelAccessor)this.wrapped).m_5518_().m_75831_((BlockPos)pos.unwrap(), 0);
    }

    @Override
    public List<LivingEntityAPI<?, ?>> getLivingInBox(Box box) {
        return this.getLivingInBox(new AABB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<LivingEntityAPI<?, ?>> getLivingInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (LivingEntity entity : ((LevelAccessor)this.wrapped).m_45976_(LivingEntity.class, (AABB)box)) {
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        }
        return entities;
    }

    @Override
    public int getMoonPhase() {
        return ((LevelAccessor)this.wrapped).m_46941_();
    }

    private Raid getRaid(BlockPosAPI<?> pos) {
        return ((LevelAccessor)this.wrapped).m_5776_() ? null : ((ServerLevel)this.wrapped).m_8832_((BlockPos)pos.unwrap());
    }

    @Override
    @Nullable
    public String getRaidStatus(BlockPosAPI<?> pos) {
        Raid raid = this.getRaid(pos);
        if (Objects.isNull(raid)) {
            return null;
        }
        if (raid.m_37767_()) {
            return "VICTORY";
        }
        if (raid.m_37768_()) {
            return "LOSS";
        }
        if (raid.m_37762_()) {
            return "STOPPED";
        }
        if (raid.m_37782_()) {
            return "ONGOING";
        }
        return null;
    }

    @Override
    public int getRaidWave(BlockPosAPI<?> pos) {
        Raid raid = this.getRaid(pos);
        return Objects.nonNull(raid) ? raid.m_37771_() : -1;
    }

    @Override
    public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapState(((LevelAccessor)this.wrapped).m_8055_((BlockPos)pos.unwrap()));
    }

    @Override
    public StructureAPI<?> getStructureAt(BlockPosAPI<?> api) {
        if (this.wrapped instanceof ServerLevel) {
            StructureManager manager = ((ServerLevel)this.wrapped).m_215010_();
            BlockPos pos = (BlockPos)api.unwrap();
            RegistryAccess access = ((LevelAccessor)this.wrapped).m_5962_();
            Registry registry = access.m_6632_(Registry.f_235725_).orElse(null);
            if (Objects.isNull(registry)) {
                return null;
            }
            for (Map.Entry entry : registry.m_6579_()) {
                Structure structure = (Structure)entry.getValue();
                if (!manager.m_220494_(pos, structure).m_73603_()) continue;
                return WrapperHelper.wrapStructure(structure);
            }
        }
        return null;
    }

    @Override
    public long getTimeDay() {
        return this.getTimeTotal() % 24000L;
    }

    @Override
    public long getTimeTotal() {
        return ((LevelAccessor)this.wrapped).m_8044_();
    }

    @Override
    public boolean isClient() {
        return ((LevelAccessor)this.wrapped).m_5776_();
    }

    @Override
    public boolean isDaytime() {
        return this.wrapped instanceof Level && this.getTimeDay() < 13000L;
    }

    @Override
    public boolean isNighttime() {
        return this.wrapped instanceof Level && this.getTimeDay() >= 13000L;
    }

    @Override
    public boolean isRaining() {
        return this.wrapped instanceof Level && ((Level)this.wrapped).m_46471_();
    }

    @Override
    public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return ((LevelAccessor)this.wrapped).m_45527_((BlockPos)pos.unwrap());
    }

    @Override
    public boolean isStorming() {
        return this.wrapped instanceof Level && ((Level)this.wrapped).m_46470_();
    }

    @Override
    public boolean isSunrise() {
        return this.getTimeDay() >= 23000L;
    }

    @Override
    public boolean isSunset() {
        long time = this.getTimeDay();
        return time >= 12000L && time < 13000L;
    }

    @Override
    public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        ((LevelAccessor)this.wrapped).m_7731_((BlockPos)pos.unwrap(), (BlockState)state.unwrap(), 2);
    }

    @Override
    public void spawnEntity(EntityAPI<?, ?> entity, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((LevelAccessor)this.wrapped).m_5776_()) {
            ((LevelAccessor)this.wrapped).m_7967_((Entity)entity.unwrapEntity());
            if (Objects.nonNull(onSpawn)) {
                onSpawn.accept(entity);
            }
        }
    }

    @Override
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (this.wrapped instanceof Level && !((LevelAccessor)this.wrapped).m_5776_()) {
            ItemEntity item = new ItemEntity((Level)this.wrapped, pos.dX(), pos.dY(), pos.dZ(), (ItemStack)stack.unwrap());
            item.m_32060_();
            this.spawnEntity(WrapperHelper.wrapEntity(item), onSpawn);
        }
    }

    @Override
    public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((LevelAccessor)this.wrapped).m_5776_()) {
            ItemStackAPI stack = WrapperHelper.wrapItemStack(new ItemStack((ItemLike)((Item)api.unwrap())));
            if (Objects.nonNull(beforeSpawn)) {
                beforeSpawn.accept(stack);
            }
            this.spawnItem(stack, pos, onSpawn);
        }
    }
}

