/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.shared.v16.m5.common.block;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockPropertyAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.shared.v16.m5.common.block.BlockProperty1_16_5;
import mods.thecomputerizer.theimpossiblelibrary.shared.v16.m5.common.block.Material1_16_5;
import mods.thecomputerizer.theimpossiblelibrary.shared.v16.m5.common.block.MaterialColor1_16_5;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;

public class BlockHelper1_16_5
implements BlockHelperAPI {
    static final Map<String, MaterialColor> COLOR_BY_NAME = BlockHelper1_16_5.buildColorMap();
    static final Map<String, Material> MATERIAL_BY_NAME = BlockHelper1_16_5.buildMaterialMap();

    static Map<String, MaterialColor> buildColorMap() {
        HashMap<String, MaterialColor> map = new HashMap<String, MaterialColor>();
        map.put("AIR", MaterialColor.field_151660_b);
        map.put("BLACK", MaterialColor.field_151646_E);
        map.put("BLACK_TERRACOTTA", MaterialColor.field_193560_ab);
        map.put("BLUE", MaterialColor.field_151649_A);
        map.put("BLUE_TERRACOTTA", MaterialColor.field_193572_X);
        map.put("BROWN", MaterialColor.field_151650_B);
        map.put("BROWN_TERRACOTTA", MaterialColor.field_193573_Y);
        map.put("CLAY", MaterialColor.field_151667_k);
        map.put("CYAN", MaterialColor.field_151679_y);
        map.put("CYAN_TERRACOTTA", MaterialColor.field_193570_V);
        map.put("DIAMOND", MaterialColor.field_151648_G);
        map.put("DIRT", MaterialColor.field_151664_l);
        map.put("EMERALD", MaterialColor.field_151653_I);
        map.put("FOLIAGE", MaterialColor.field_151669_i);
        map.put("GOLD", MaterialColor.field_151647_F);
        map.put("GRASS", MaterialColor.field_151661_c);
        map.put("GRAY", MaterialColor.field_151670_w);
        map.put("GRAY_TERRACOTTA", MaterialColor.field_193568_T);
        map.put("GREEN", MaterialColor.field_151651_C);
        map.put("GREEN_TERRACOTTA", MaterialColor.field_193574_Z);
        map.put("ICE", MaterialColor.field_151657_g);
        map.put("LAPIS", MaterialColor.field_151652_H);
        map.put("LIGHT_BLUE", MaterialColor.field_151674_s);
        map.put("LIGHT_BLUE_TERRACOTTA", MaterialColor.field_193564_P);
        map.put("LIGHT_GRAY", MaterialColor.field_197656_x);
        map.put("LIGHT_GRAY_TERRACOTTA", MaterialColor.field_197655_T);
        map.put("LIME", MaterialColor.field_151672_u);
        map.put("LIME_TERRACOTTA", MaterialColor.field_193566_R);
        map.put("MAGENTA", MaterialColor.field_151675_r);
        map.put("MAGENTA_TERRACOTTA", MaterialColor.field_193563_O);
        map.put("METAL", MaterialColor.field_151668_h);
        map.put("NETHER", MaterialColor.field_151655_K);
        map.put("ORANGE", MaterialColor.field_151676_q);
        map.put("ORANGE_TERRACOTTA", MaterialColor.field_193562_N);
        map.put("PINK", MaterialColor.field_151671_v);
        map.put("PINK_TERRACOTTA", MaterialColor.field_193567_S);
        map.put("PURPLE", MaterialColor.field_151678_z);
        map.put("PURPLE_TERRACOTTA", MaterialColor.field_193571_W);
        map.put("QUARTZ", MaterialColor.field_151677_p);
        map.put("RED", MaterialColor.field_151645_D);
        map.put("RED_TERRACOTTA", MaterialColor.field_193559_aa);
        map.put("SAND", MaterialColor.field_151658_d);
        map.put("SNOW", MaterialColor.field_151666_j);
        map.put("STONE", MaterialColor.field_151665_m);
        map.put("WATER", MaterialColor.field_151662_n);
        map.put("WHITE_TERRACOTTA", MaterialColor.field_193561_M);
        map.put("WOOL", MaterialColor.field_151659_e);
        map.put("WOOD", MaterialColor.field_151663_o);
        map.put("YELLOW", MaterialColor.field_151673_t);
        map.put("YELLOW_TERRACOTTA", MaterialColor.field_193565_Q);
        return Collections.unmodifiableMap(map);
    }

    static Map<String, Material> buildMaterialMap() {
        HashMap<String, Material> map = new HashMap<String, Material>();
        map.put("AIR", Material.field_151579_a);
        map.put("ANVIL", Material.field_151574_g);
        map.put("BARRIER", Material.field_175972_I);
        map.put("CACTUS", Material.field_151570_A);
        map.put("CAKE", Material.field_151568_F);
        map.put("CLAY", Material.field_151571_B);
        map.put("CORAL", Material.field_151589_v);
        map.put("DIRT", Material.field_151578_c);
        map.put("DRAGON_EGG", Material.field_151566_D);
        map.put("EXPLOSIVE", Material.field_151590_u);
        map.put("FIRE", Material.field_151581_o);
        map.put("GLASS", Material.field_151592_s);
        map.put("VEGETABLE", Material.field_151572_C);
        map.put("GRASS", Material.field_151577_b);
        map.put("ICE", Material.field_151588_w);
        map.put("LAVA", Material.field_151587_i);
        map.put("LEAVES", Material.field_151584_j);
        map.put("METAL", Material.field_151573_f);
        map.put("PACKED_ICE", Material.field_151598_x);
        map.put("PISTON", Material.field_76233_E);
        map.put("PORTAL", Material.field_151567_E);
        map.put("SAND", Material.field_151595_p);
        map.put("SNOW", Material.field_151596_z);
        map.put("SNOW_LAYER", Material.field_151597_y);
        map.put("SPONGE", Material.field_151583_m);
        map.put("STONE", Material.field_151576_e);
        map.put("STRUCTURE_VOID", Material.field_189963_J);
        map.put("WATER", Material.field_151586_h);
        map.put("WEB", Material.field_151569_G);
        map.put("WOOL", Material.field_151580_n);
        map.put("WOOD", Material.field_151575_d);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public <V extends Comparable<V>> BlockPropertyAPI<?, V> createProperty(String name, V defVal) {
        if (defVal instanceof Boolean) {
            return new BlockProperty1_16_5(BooleanProperty.func_177716_a((String)name));
        }
        if (defVal instanceof Enum) {
            return new BlockProperty1_16_5(this.createPropertyEnum(name, defVal.getClass()));
        }
        if (defVal instanceof Number) {
            return new BlockProperty1_16_5(IntegerProperty.func_177719_a((String)name, (int)0, (int)((Number)((Object)defVal)).intValue()));
        }
        TILRef.logError("Unsupported createProperty type for {}!", Objects.nonNull(defVal) ? defVal.getClass() : "null");
        return null;
    }

    private <E extends Enum<E>> EnumProperty<E> createPropertyEnum(String name, Class<?> clazz) {
        return EnumProperty.func_177709_a((String)name, clazz);
    }

    @Override
    public <P> BlockPropertyAPI<?, ?> getAsProperty(P property) {
        if (property instanceof Property) {
            return new BlockProperty1_16_5((Property)property);
        }
        TILRef.logError("Object {} is not an instance of {}!", property, Property.class);
        return null;
    }

    public Material1_16_5 getMaterialByName(String name) {
        Material mat = TextHelper.isBlank(name) ? Material.field_151575_d : MATERIAL_BY_NAME.getOrDefault(name, Material.field_151575_d);
        return new Material1_16_5(mat);
    }

    public MaterialColor1_16_5 getMaterialColorByName(String name) {
        MaterialColor color = TextHelper.isBlank(name) ? MaterialColor.field_151661_c : COLOR_BY_NAME.getOrDefault(name, MaterialColor.field_151661_c);
        return new MaterialColor1_16_5(color);
    }
}

