/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.registry.tab;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.tab.FutureCreativeTab;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.jetbrains.annotations.Nullable;

public class FutureCreativeTabNeoForge1_21
extends FutureCreativeTab<CreativeModeTab> {
    private final List<ItemStack> suppliedItems = new ArrayList<ItemStack>();

    public FutureCreativeTabNeoForge1_21(ResourceLocationAPI<?> registryName) {
        super(registryName);
    }

    @Override
    public void register(@Nullable Object arg) {
        if (Objects.isNull(arg) || Objects.isNull(this.registryName)) {
            TILRef.logError("Cannot register future creative tab with null arg or registryName!", new Object[0]);
            return;
        }
        RegisterEvent event = (RegisterEvent)arg;
        ResourceLocation name = (ResourceLocation)this.registryName.unwrap();
        event.register(Registries.CREATIVE_MODE_TAB, name, () -> {
            CreativeModeTab.Builder builder = new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 0).title((Component)TextHelper.getTranslated("itemGroup." + name.getPath(), new Object[0]).getAsComponent());
            if (Objects.nonNull(this.iconSupplier)) {
                builder.icon(() -> (ItemStack)this.iconSupplier.get());
            }
            this.wrapped = builder.displayItems((args, output) -> {
                for (ItemStack stack : this.suppliedItems) {
                    output.accept(stack);
                }
            }).build();
            this.registered = true;
            return (CreativeModeTab)this.wrapped;
        });
    }

    @Override
    public void supply(@Nullable Object arg, List<Supplier<ItemStackAPI<?>>> stackSuppliers) {
        if (Objects.isNull(arg)) {
            TILRef.logError("Cannot supply future creative tab with null arg!", new Object[0]);
            return;
        }
        BuildCreativeModeTabContentsEvent event = (BuildCreativeModeTabContentsEvent)arg;
        for (Supplier<ItemStackAPI<?>> supplier : stackSuppliers) {
            ItemStack stack = (ItemStack)supplier.get().unwrap();
            CreativeModeTab.TabVisibility visibility = this.visibility((Set<ItemStack>)event.getParentEntries(), (Set<ItemStack>)event.getSearchEntries(), stack);
            if (Objects.nonNull(visibility)) {
                event.accept(stack, visibility);
            }
            if (this.suppliedItems.contains(stack)) continue;
            this.suppliedItems.add(stack);
        }
        stackSuppliers.clear();
    }

    @Nullable
    private CreativeModeTab.TabVisibility visibility(Set<ItemStack> parent, Set<ItemStack> search, ItemStack stack) {
        if (parent.contains(stack)) {
            return search.contains(stack) ? CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY : null;
        }
        if (search.contains(stack)) {
            return parent.contains(stack) ? CreativeModeTab.TabVisibility.PARENT_TAB_ONLY : null;
        }
        return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
    }
}

