/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core;

import cpw.mods.jarhandling.JarContents;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Objects;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.NeoForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.MultiVersionModReader;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.loader.TILModFileNeoForge1_21;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TILSelfLocator
implements IModFileCandidateLocator {
    private static final CoreAPI CORE;
    private static final String JAR_EXT = ".jar";
    private static final String IMPL_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core";
    private static final String LOCATING_PKG = "net.neoforged.neoforgespi.locating";
    private static final Logger LOGGER;
    private static final String MOD_FILE_IMPL = "mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.TILSelfLocator";
    private static final String MOD_FILE_SERVICE = "net.neoforged.neoforgespi.locating.IModFileCandidateLocator";
    private static final String MOD_LANGUAGE_IMPL = "mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.MultiVersionLanguageLoader";
    private static final String MOD_LANGUAGE_SERVICE = "net.neoforged.neoforgespi.locating.IModLanguageLoader";
    private static final String MOD_READER_IMPL = "mods.thecomputerizer.theimpossiblelibrary.neoforge.v21.core.MultiVersionModReader";
    private static final String MOD_READER_SERVICE = "net.neoforged.neoforgespi.locating.IModFileReader";
    private final MultiVersionLoaderAPI loader = CORE.getLoader();

    public TILSelfLocator() {
        LOGGER.info("Successfully initialized!");
    }

    boolean addSelf(URL url, IDiscoveryPipeline pipeline) {
        LOGGER.info("Attempting to read self from URL {}", (Object)url);
        return this.addSelf(Paths.get(this.fixPath(url.getPath()), new String[0]), pipeline);
    }

    boolean addSelf(Path path, IDiscoveryPipeline pipeline) {
        LOGGER.info("Attempting to read self from path {}", (Object)path);
        IModFile file = this.readSelf(JarContents.of((Path)path));
        if (Objects.nonNull(file)) {
            pipeline.addModFile(file);
            return true;
        }
        LOGGER.error("Read IModFile instance as null!");
        return false;
    }

    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        Class<?> c = this.getClass();
        ProtectionDomain pd = this.getClass().getProtectionDomain();
        if (Objects.nonNull(pd)) {
            CodeSource source = pd.getCodeSource();
            if (Objects.nonNull(source)) {
                if (this.addSelf(source.getLocation(), pipeline)) {
                    LOGGER.info("Successfully added mod file for {}", (Object)"theimpossiblelibrary");
                } else {
                    LOGGER.error("Failed to add self mod! Any dependents trying to load will likely break!");
                }
            } else {
                LOGGER.error("CodeSource instance for {} did not exist!", c);
            }
        } else {
            LOGGER.error("ProtectionDomain instance for {} did not exist!", c);
        }
    }

    String fixPath(String path) {
        if (path.startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        if (path.contains(JAR_EXT) && !path.endsWith(JAR_EXT)) {
            path = path.substring(0, path.lastIndexOf(JAR_EXT) + JAR_EXT.length());
        }
        return path.replace("%20", " ");
    }

    public int getPriority() {
        return 999;
    }

    @Nullable
    MultiVersionModCandidate mergeCandidates(@Nullable MultiVersionModCandidate candidate1, @Nullable MultiVersionModCandidate candidate2) {
        if (Objects.nonNull(candidate1)) {
            if (Objects.nonNull(candidate2)) {
                candidate1.merge(candidate2);
            }
            return candidate1;
        }
        return candidate2;
    }

    boolean queryFile(String loaderName, File file) {
        String fileName = file.getName();
        TILDev.logInfo("[{}]: Checking if file {} is the loader", loaderName, fileName);
        if (Objects.isNull(MultiVersionModCandidate.loaderFile) && TILDev.isLoader(fileName)) {
            TILDev.logInfo("[{}]: File is the loader", loaderName);
            MultiVersionModCandidate.loaderFile = file;
        }
        return false;
    }

    @Nullable
    IModFile readSelf(JarContents jar) {
        MultiVersionModCandidate candidate = null;
        Manifest manifest = jar.getManifest();
        if (Objects.nonNull(manifest) && MultiVersionModFinder.hasMods(manifest.getMainAttributes())) {
            Path path = jar.getPrimaryPath();
            this.loader.addPotentialModPath(path);
            String loaderName = this.loader.getName();
            TILRef.logInfo("[{}]: Found mod candidate at {}", loaderName, path);
            File file = path.toFile();
            if (this.queryFile(loaderName, file)) {
                return null;
            }
            candidate = this.mergeCandidates(MultiVersionModFinder.discoverCoreCandidate(this.loader, file), MultiVersionModFinder.discoverModCandidate(this.loader, file));
        }
        if (Objects.isNull(candidate)) {
            return null;
        }
        Collection<?> infos = CORE.loadCandidate(candidate, this.loader, this.getClass().getClassLoader());
        return infos.isEmpty() ? null : new TILModFileNeoForge1_21(this, candidate, infos);
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"TILSelfLocator");
        ClassLoader loader = MultiVersionModReader.class.getClassLoader();
        NeoForgeCoreLoader.fixForServiceLayer();
        CORE = (CoreAPI)NeoForgeCoreLoader.initCoreAPI(loader);
        if (Objects.isNull(CORE)) {
            throw new RuntimeException("Failed to retrieve CoreAPI instance for TILSelfLocator");
        }
        if (loader != NeoForgeCoreLoader.bootLoader()) {
            NeoForgeCoreLoader.fixService(MOD_FILE_SERVICE, MOD_FILE_IMPL, loader, true);
            NeoForgeCoreLoader.fixService(MOD_LANGUAGE_SERVICE, MOD_LANGUAGE_IMPL, loader);
            NeoForgeCoreLoader.fixService(MOD_READER_SERVICE, MOD_READER_IMPL, loader);
        }
    }
}

