/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import cpw.mods.jarhandling.SecureJar;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.neoforge.core.loader.TILBetterModScan;
import net.neoforged.fml.loading.ClasspathLocatorUtils;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModLocator;
import net.neoforged.neoforgespi.locating.IModProvider;
import net.neoforged.neoforgespi.locating.ModFileFactory;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeoForgeModLoading {
    static final Logger LOGGER;
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final BiConsumer<TILBetterModScan, Object> AFTER_WRITING_MODS;
    static final Function<Object, Object> INFO_GETTER;
    static final Function<Object, String> MODULE_NAME_GETTER;
    static final BiFunction<URL, String, Path> urlToPath;
    static final Function<Path, Manifest> pathToManifest;
    static String coreModEngineClass;
    static String[] coreModExtensions;
    static Class<?> modClassVisitorClass;
    static Class<?> scannerClass;
    static Function<Object[], Object> modFileCreator;
    static boolean fixedCoreMods;
    static boolean isNew;

    private static <F> void addScannedMod(Object file, List<F> mods) {
        mods.add(new IModLocator.ModFileOrException((IModFile)file, null));
    }

    static void checkPath(MultiVersionLoaderAPI loader, Path path, Predicate<Path> filter) {
        String loaderName = loader.getName();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        String fileName = path.getFileName().toString();
        LOGGER.debug("[{}]: Checking if file {} is the loader", (Object)loaderName, (Object)fileName);
        if (Objects.isNull(MultiVersionModCandidate.loaderFile) && TILDev.isLoader(fileName)) {
            LOGGER.debug("[{}]: File is the loader", (Object)loaderName);
            MultiVersionModCandidate.loaderFile = path.toFile();
        }
        if (filter.test(path)) {
            LOGGER.info("[{}]: Found mod candidate at {}", (Object)loaderName, (Object)path);
            loader.addPotentialModPath(path);
        }
    }

    static void checkURL(MultiVersionLoaderAPI loader, URL url, Predicate<Path> filter) {
        LOGGER.debug("[{}]: Checking URL {} for MANIFEST {}", new Object[]{loader.getName(), url, MANIFEST});
        NeoForgeModLoading.checkPath(loader, urlToPath.apply(url, MANIFEST), filter);
    }

    static void findFiles(MultiVersionLoaderAPI loader, Predicate<Path> filter, File ... files) {
        TILRef.logInfo("[{}]: Loading {} mod files", loader.getName(), files.length);
        for (File mod : files) {
            TILRef.logDebug("[{}]: Potentially loading mod file at path {}", loader.getName(), mod.toPath());
            NeoForgeModLoading.checkPath(loader, mod.toPath(), filter);
        }
    }

    public static void findPaths(ClassLoader classLoader, MultiVersionLoaderAPI loader) {
        Predicate<Path> filter = path -> {
            if (Objects.isNull(path)) {
                return false;
            }
            Manifest manifest = pathToManifest.apply((Path)path);
            if (Objects.isNull(manifest)) {
                return false;
            }
            return MultiVersionModFinder.hasMods(manifest.getMainAttributes());
        };
        NeoForgeModLoading.findURLs(loader, classLoader, filter);
        NeoForgeModLoading.findFiles(loader, filter, FileHelper.list(loader.findModRoot(), File::isFile));
    }

    static void findURLs(MultiVersionLoaderAPI loader, ClassLoader classLoader, Predicate<Path> filter) {
        try {
            Enumeration<URL> manifests = ClassLoader.getSystemClassLoader().getResources(MANIFEST);
            while (manifests.hasMoreElements()) {
                NeoForgeModLoading.checkURL(loader, manifests.nextElement(), filter);
            }
        }
        catch (IOException ex) {
            TILRef.logError("[{}]: Failed to calculate URLs for paths with {} using {}", loader.getName(), MANIFEST, classLoader, ex);
        }
    }

    private static void fixCoreModPackages() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> engineClass = ClassHelper.findClass(coreModEngineClass, loader);
        HashSet<Object> allowed = new HashSet<Object>((Collection)StaticComponentContainer.Fields.getStatic(engineClass, "ALLOWED_PACKAGES"));
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.api.core");
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.neoforge.core");
        for (String extension : coreModExtensions) {
            allowed.add("mods.thecomputerizer.theimpossiblelibrary.neoforge." + extension + ".core");
        }
        LOGGER.debug("Expanded coremod package whitelist to {}", allowed);
        StaticComponentContainer.Fields.setStaticDirect(engineClass, "ALLOWED_PACKAGES", allowed);
    }

    private static Object getCoreMods(Object file) {
        return StaticComponentContainer.Methods.invoke(file, "getCoreMods", new Object[0]);
    }

    private static boolean hasCoreModPath(String ... paths) {
        for (String path : paths) {
            if (!path.contains("coremods.json")) continue;
            return true;
        }
        return false;
    }

    public static boolean identifyMods(boolean result, Object file) {
        LOGGER.debug("Identifying mods");
        if (result) {
            NeoForgeModLoading.queryCoreMods(file);
        }
        LOGGER.debug("Finished identifying mods");
        return result;
    }

    public static Map<MultiVersionModInfo, MultiVersionModData> initFileInfo(String version, Collection<?> infos) {
        HashMap<MultiVersionModInfo, MultiVersionModData> infoMap = new HashMap<MultiVersionModInfo, MultiVersionModData>();
        for (Object info : infos) {
            infoMap.put((MultiVersionModInfo)info, null);
        }
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Created TILModFileNeoForge1_{} with {} in context {}", new Object[]{version, infos, context});
        return infoMap;
    }

    public static <F> void initModLoading(ClassLoader loader, Object locator, Map<MultiVersionModCandidate, F> candidateMap) {
        CoreAPI core = CoreAPI.getInstance(loader);
        if (Objects.isNull(core)) {
            throw new RuntimeException("Failed to initialize multiversion mod loader! Cannot find CoreAPI on " + loader);
        }
        NeoForgeModLoading.findPaths(loader, (MultiVersionLoaderAPI)CoreAPI.invoke(core, "getLoader"));
        NeoForgeModLoading.loadMods(loader, locator, core, candidateMap);
    }

    @Nullable
    private static TILBetterModScan initModScanner(ModFile file) {
        LOGGER.info("Starting multiversion mod scan");
        TILBetterModScan scan = new TILBetterModScan();
        scan.addModFileInfo(file.getModFileInfo());
        file.scanFile(p -> NeoForgeModLoading.scanReflectively(StaticComponentContainer.Constructors.newInstanceOf(scannerClass, file), p, scan));
        LOGGER.debug("Injecting @Mod annotations from multiversion mod info");
        if (Objects.nonNull(scan.getAnnotations())) {
            return scan;
        }
        LOGGER.error("@Mod scan annotation set for multiversion mod is null???");
        return null;
    }

    private static IModFileInfo langFileInfo(IModFile file) {
        if (!(file instanceof ModFile)) {
            LOGGER.error("IModFile instance must extend ModFile to be supported for IModFileInfo construction!");
            return null;
        }
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)NeoForgeModLoading.langProviderConfig());
        Consumer<IModFileInfo> consumer = arg_0 -> NeoForgeModLoading.lambda$langFileInfo$7((IConfigurable)configWrapper, arg_0);
        return new ModFileInfo((ModFile)file, (IConfigurable)configWrapper, consumer, Collections.emptyList());
    }

    public static Config langProviderConfig() {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"minecraft");
        config.set("loaderVersion", (Object)"1");
        Config mod = Config.inMemory();
        mod.set("modId", (Object)"multiversionprovider");
        mod.set("version", (Object)"0.4.5");
        mod.set("displayName", (Object)"Multiversion Language Provider");
        mod.set("logoFile", (Object)"logo.png");
        mod.set("authors", (Object)"The_Computerizer");
        mod.set("description", (Object)"Multiversion language loader for The Impossible Library");
        config.set("mods", Collections.singletonList(mod));
        return config;
    }

    public static ModFile langProviderModFile(ModFile reference) {
        SecureJar jar = SecureJar.from((Path[])new Path[]{reference.getFilePath()});
        ModFileFactory.ModFileInfoParser parser = NeoForgeModLoading::langFileInfo;
        IModProvider provider = reference.getProvider();
        return new ModFile(jar, provider, parser, "LANGPROVIDER");
    }

    private static <F> void loadCandidateInfos(Object locator, Map<?, ?> infoMap, Map<MultiVersionModCandidate, F> candidateMap) {
        if (Objects.isNull(modFileCreator)) {
            LOGGER.error("Cannot load mod candidate info with null modFileCreator function! Was setModFileCreator called?");
            return;
        }
        for (Map.Entry<?, ?> entry : infoMap.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            Object file = modFileCreator.apply(new Object[]{candidate.getFile().toPath(), locator, entry.getValue()});
            candidateMap.put(candidate, file);
        }
    }

    private static <F> void loadMods(ClassLoader loader, Object locator, Object core, Map<MultiVersionModCandidate, F> candidateMap) {
        Class[] withLoader = new Class[]{ClassLoader.class};
        CoreAPI.invoke(core, "loadCoreModInfo", withLoader, loader);
        CoreAPI.invoke(core, "instantiateCoreMods");
        CoreAPI.invoke(core, "writeModContainers", withLoader, loader);
        Object infoMap = CoreAPI.invoke(core, "getModInfo");
        NeoForgeModLoading.loadCandidateInfos(locator, (Map)infoMap, candidateMap);
    }

    private static TILBetterModScan onFinishedWritingMods(TILBetterModScan scan, IModFile file) {
        if (!isNew) {
            List loaders = (List)StaticComponentContainer.Methods.invoke((Object)file, "getLoaders", new Object[0]);
            if (loaders.isEmpty()) {
                LOGGER.error("Why are there no language loaders??");
            }
            for (Object loader : loaders) {
                AFTER_WRITING_MODS.accept(scan, loader);
            }
        }
        LOGGER.debug("Finishing multiversion mod scan");
        scan.addFilePath(file.getFilePath());
        return scan;
    }

    public static void populateMultiversionData(Object infoMapObj, Object dataMap) {
        if (Objects.isNull(infoMapObj)) {
            LOGGER.error("Cannot populate multiversion data with null info map! Was the getter set up correctly?");
            return;
        }
        Map infoMap = (Map)infoMapObj;
        for (MultiVersionModData data : ((Map)dataMap).values()) {
            MultiVersionModInfo info = data.getInfo();
            if (!infoMap.containsKey(info)) continue;
            LOGGER.debug("Populated data for {}", (Object)info);
            infoMap.put(info, data);
        }
    }

    public static void populateMultiversionData(MultiVersionModCandidate candidate, Object modFile) {
        Object infoMapObj = INFO_GETTER.apply(modFile);
        Map infoMap = (Map)infoMapObj;
        CoreAPI core = candidate.getCore();
        File file = candidate.getFile();
        for (MultiVersionModInfo info : infoMap.keySet()) {
            MultiVersionModData data = core.getModData(file, candidate, info);
            if (!Objects.nonNull(data)) continue;
            infoMap.put(info, data);
            LOGGER.debug("Populated data for {}", (Object)info);
        }
    }

    public static void queryCoreMods(String ... resourcePaths) {
        if (!fixedCoreMods && NeoForgeModLoading.hasCoreModPath(resourcePaths)) {
            NeoForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static void queryCoreMods(Object file) {
        if (fixedCoreMods) {
            return;
        }
        Object coremods = NeoForgeModLoading.getCoreMods(file);
        if (coremods instanceof Collection && !((Collection)coremods).isEmpty()) {
            NeoForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static <F> List<F> scanMods(Collection<?> candidates) {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Scanning for mods in multiversion jars (context = {})", (Object)context);
        ArrayList mods = new ArrayList();
        LOGGER.debug("Getting CoreAPI instance");
        CoreAPI instance = CoreAPI.getInstance();
        if (Objects.isNull(instance)) {
            LOGGER.error("Failed to get CoreAPI instance :(");
        }
        Object data = CoreAPI.invoke(instance, "getModData", new Class[]{File.class}, new File("."));
        for (Object candidate : candidates) {
            NeoForgeModLoading.populateMultiversionData(INFO_GETTER.apply(candidate), data);
            if ("theimpossiblelibrary".equals(MODULE_NAME_GETTER.apply(candidate))) {
                NeoForgeModLoading.addScannedMod(NeoForgeModLoading.langProviderModFile((ModFile)candidate), mods);
            }
            NeoForgeModLoading.addScannedMod(candidate, mods);
        }
        return mods;
    }

    private static void scanReflectively(Object scanner, Path path, ModFileScanData scan) {
        LOGGER.trace("Attempting to scan multiversion jar path {}", (Object)path);
        try {
            StaticComponentContainer.Methods.invokeDirect(scanner, "fileVisitor", path, scan);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to scan {}!", (Object)path, (Object)ex);
        }
    }

    public static void setFileVersion(Class<?> caller, String version, String actualVersion) {
        String[] stringArray;
        String pkgExt = version.contains("_") ? version.replace("_", ".m") : version;
        String className = "mods.thecomputerizer.theimpossiblelibrary.neoforge.v" + pkgExt + ".core.loader.TILModFileNeoForge1_" + version;
        Class<?> fileClass = ClassHelper.findClass(className);
        modFileCreator = args -> {
            SecureJar jar = SecureJar.from((Path[])new Path[]{(Path)args[0]});
            return StaticComponentContainer.Constructors.newInstanceOf(fileClass, jar, args[1], args[2]);
        };
        isNew = version.startsWith("21");
        coreModEngineClass = "net.neoforged.coremod.CoreMod" + (isNew ? "Scripting" : "") + "Engine";
        if (isNew) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "v21";
            stringArray2[1] = "v20.m6";
            stringArray = stringArray2;
            stringArray2[2] = "v21.m1";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "v20";
            stringArray = stringArray3;
            stringArray3[1] = "v20.m4";
        }
        coreModExtensions = stringArray;
        String pkg = "net.neoforged.fml.loading." + (isNew ? "modscan." : "moddiscovery.");
        modClassVisitorClass = ClassHelper.findClass(pkg + "ModClassVisitor");
        scannerClass = ClassHelper.findClass(pkg + "Scanner");
        LOGGER.info("1.{} NeoForge Locator plugin loaded on {}", (Object)actualVersion, (Object)caller.getClassLoader());
    }

    private static void writeClassBytes(IModFile file, TILBetterModScan scan, MultiVersionModData data, String className, byte[] bytes) {
        scan.addWrittenClass(className, data.getInfo(), file, bytes);
        ClassVisitor visitor = (ClassVisitor)StaticComponentContainer.Constructors.newInstanceOf(modClassVisitorClass, new Object[0]);
        ClassReader reader = new ClassReader(bytes);
        reader.accept(visitor, 0);
        StaticComponentContainer.Methods.invokeDirect(visitor, "buildData", scan.getClasses(), scan.getAnnotations());
    }

    private static void writeEntry(IModFile file, TILBetterModScan scan, Map.Entry<MultiVersionModInfo, MultiVersionModData> entry) {
        MultiVersionModInfo info = entry.getKey();
        String modid = info.getModID();
        MultiVersionModData data = entry.getValue();
        if (Objects.isNull(data)) {
            LOGGER.warn("Skipping mod injection for {} since no data exists", (Object)modid);
            return;
        }
        scan.setCore(data.getCandidate().getCore());
        for (Map.Entry<String, byte[]> classBytes : data.writeModClass()) {
            NeoForgeModLoading.writeClassBytes(file, scan, data, classBytes.getKey(), classBytes.getValue());
        }
        for (IModInfo mod : file.getModInfos()) {
            if (!modid.equals(mod.getModId())) continue;
            scan.setModClass(mod, info.getModClasspath());
            break;
        }
    }

    public static TILBetterModScan writeMods(ModFile file) {
        Object infoMapObj = INFO_GETTER.apply(file);
        Map infoMap = (Map)infoMapObj;
        TILBetterModScan scan = NeoForgeModLoading.initModScanner(file);
        if (Objects.isNull((Object)scan)) {
            LOGGER.error("Failed to initialize TILBetterModScan!");
            return null;
        }
        for (Map.Entry<MultiVersionModInfo, MultiVersionModData> entry : infoMap.entrySet()) {
            NeoForgeModLoading.writeEntry((IModFile)file, scan, entry);
        }
        return NeoForgeModLoading.onFinishedWritingMods(scan, (IModFile)file);
    }

    private static /* synthetic */ void lambda$langFileInfo$7(IConfigurable configWrapper, IModFileInfo info) {
        StaticComponentContainer.Methods.invokeDirect(configWrapper, "setFile", info);
    }

    static {
        ClassHelper.checkBurningWaveInit();
        LOGGER = LoggerFactory.getLogger((String)"NeoForge Mod Loading");
        AFTER_WRITING_MODS = (scan, language) -> {
            LOGGER.debug("Injecting scan data into the language loader");
            Consumer visitor = (Consumer)StaticComponentContainer.Methods.invokeDirect(language, "getFileVisitor", new Object[0]);
            visitor.accept(scan);
        };
        INFO_GETTER = file -> StaticComponentContainer.Methods.invokeDirect(file, "getInfos", new Object[0]);
        MODULE_NAME_GETTER = file -> ((IModFile)file).getModFileInfo().moduleName();
        urlToPath = (url, manifest) -> ClasspathLocatorUtils.findJarPathFor((String)manifest, (String)manifest, (URL)url);
        pathToManifest = path -> {
            SecureJar.ModuleDataProvider provider = SecureJar.from((Path[])new Path[]{path}).moduleDataProvider();
            return Objects.nonNull(provider) ? provider.getManifest() : null;
        };
    }
}

