/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.neoforge.core;

import cpw.mods.cl.JarModuleFinder;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import cpw.mods.jarhandling.impl.Jar;
import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import java.lang.module.Configuration;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReference;
import java.lang.module.ResolvedModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public class NeoForgeCoreLoader {
    private static final String API_PKG = "mods.thecomputerizer.theimpossiblelibrary.api";
    private static final String NEOFORGE_PKG = "mods.thecomputerizer.theimpossiblelibrary.neoforge";
    private static final String APICORE = "mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI";
    private static final Logger LOGGER = LogManager.getLogger((String)"TIL NeoForgeCoreLoader");

    private static void addConfigurationModule(Configuration bootConfig, String name, ResolvedModule resolvedModule, ClassLoader thisLoader) {
        HashMap<String, ResolvedModule> nameToModule = new HashMap<String, ResolvedModule>((Map)StaticComponentContainer.Fields.getDirect((Object)bootConfig, "nameToModule"));
        nameToModule.putIfAbsent(name, resolvedModule);
        StaticComponentContainer.Fields.setDirect((Object)bootConfig, "nameToModule", Collections.unmodifiableMap(nameToModule));
        StaticComponentContainer.Fields.setDirect((Object)resolvedModule, "cf", (Object)bootConfig);
        Configuration thisConfig = (Configuration)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "configuration");
        NeoForgeCoreLoader.removeFromUnmodifiableSetField(thisConfig, "modules", resolvedModule);
        NeoForgeCoreLoader.removeFromUnmodifiableMapField(thisConfig, "nameToModule", name);
        HashMap<ResolvedModule, Set> thisGraph = new HashMap<ResolvedModule, Set>((Map)StaticComponentContainer.Fields.getDirect((Object)thisConfig, "graph"));
        thisGraph.entrySet().removeIf(entry -> ((ResolvedModule)entry.getKey()).name().equals(name));
        thisGraph.forEach((key, values) -> values.remove(resolvedModule));
        StaticComponentContainer.Fields.setDirect((Object)thisConfig, "graph", thisGraph);
    }

    static void addModuleThouroughly(Module module, ResolvedModule resolvedModule, ModuleLayer moduleLayer, String name, Set<String> packages, ModuleReference moduleRef, ClassLoader target) {
        StaticComponentContainer.Fields.setDirect((Object)module, "name", (Object)name);
        Configuration configuration = (Configuration)StaticComponentContainer.Fields.getDirect((Object)target, "configuration");
        Map resolvedRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)target, "resolvedRoots");
        Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)target, "packageLookup");
        Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)target, "parentLoaders");
        resolvedRoots.put(name, moduleRef);
        for (String pkg : packages) {
            packageLookup.put(pkg, resolvedModule);
        }
        parentLoaders.entrySet().removeIf(entry -> packages.contains(entry.getKey()));
        HashSet<ResolvedModule> configModules = new HashSet<ResolvedModule>(configuration.modules());
        HashMap<String, ResolvedModule> configNameToModule = new HashMap<String, ResolvedModule>((Map)StaticComponentContainer.Fields.getDirect((Object)configuration, "nameToModule"));
        configModules.removeIf(rm -> name.equals(rm.name()));
        configModules.add(resolvedModule);
        configNameToModule.put(name, resolvedModule);
        StaticComponentContainer.Fields.setDirect((Object)configuration, "modules", Collections.unmodifiableSet(configModules));
        StaticComponentContainer.Fields.setDirect((Object)configuration, "nameToModule", Collections.unmodifiableMap(configNameToModule));
        Set<Module> layerModules = moduleLayer.modules();
        boolean found = false;
        if (Objects.nonNull(layerModules)) {
            layerModules = new HashSet<Module>(layerModules);
            for (Module lModule : layerModules) {
                String lName = lModule.getName();
                if (!Objects.nonNull(lName) || !lName.equals(module.getName())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            if (Objects.nonNull(layerModules)) {
                layerModules.add(module);
                StaticComponentContainer.Fields.setDirect((Object)moduleLayer, "modules", layerModules);
            }
            HashMap<String, Module> layerNameToModule = new HashMap<String, Module>((Map)StaticComponentContainer.Fields.getDirect((Object)moduleLayer, "nameToModule"));
            layerNameToModule.put(name, module);
            StaticComponentContainer.Fields.setDirect((Object)moduleLayer, "nameToModule", Collections.unmodifiableMap(layerNameToModule));
        }
        StaticComponentContainer.Fields.setDirect((Object)module, "layer", (Object)moduleLayer);
        StaticComponentContainer.Fields.setDirect((Object)module, "loader", (Object)target);
        StaticComponentContainer.Fields.setDirect((Object)resolvedModule, "cf", (Object)configuration);
    }

    private static Set<String> addResolvedModule(ResolvedModule module, ClassLoader thisLoader) {
        ClassLoader loader = NeoForgeCoreLoader.bootLoader();
        Map roots = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "resolvedRoots");
        ModuleReference reference = (ModuleReference)StaticComponentContainer.Methods.invokeDirect(module, "reference", new Object[0]);
        ModuleDescriptor descriptor = reference.descriptor();
        String name = descriptor.name();
        roots.put(name, reference);
        Set<String> packages = descriptor.packages();
        NeoForgeCoreLoader.moveModuleToLayer(loader, "BOOT", "SERVICE", name);
        NeoForgeCoreLoader.addConfigurationModule((Configuration)StaticComponentContainer.Fields.getDirect((Object)loader, "configuration"), name, module, thisLoader);
        Map theseRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "resolvedRoots");
        theseRoots.remove(name);
        return packages;
    }

    private static void addToServiceCatalog(Module module, ModuleLayer layer) {
        StaticComponentContainer.Methods.invokeDirect(NeoForgeCoreLoader.getServicesCatalog(layer), "register", module);
    }

    public static ClassLoader bootLoader() {
        return Launcher.class.getClassLoader();
    }

    static ModuleDescriptor buildNewModuleDescriptor(String name, Jar jar, List<String> usesServices) {
        LOGGER.info("Building new module descriptor for {}", (Object)name);
        Set packages = jar.getPackages();
        List providers = jar.getProviders();
        JarMetadata metadata = (JarMetadata)StaticComponentContainer.Fields.getDirect((Object)jar, "metadata");
        String version = (String)StaticComponentContainer.Methods.invokeDirect(metadata, "version", new Object[0]);
        ModuleDescriptor.Builder builder = ModuleDescriptor.newAutomaticModule(name).version(version).packages(packages);
        for (SecureJar.Provider provider : providers) {
            List actualProviders = provider.providers();
            if (actualProviders.isEmpty()) continue;
            String service = provider.serviceName();
            builder = builder.provides(service, new ArrayList<String>(actualProviders));
        }
        for (String service : usesServices) {
            builder.uses(service);
        }
        ModuleDescriptor desc = builder.build();
        LOGGER.info("Finished building descriptor {}", (Object)desc);
        return desc;
    }

    static Map<?, ?> burningWaveProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("banner.hide", "true");
        properties.put("managed-logger.repository.enabled", "false");
        return properties;
    }

    public static void exportAllModules() throws Throwable {
        LOGGER.info("Exporting all modules");
        Class<?> mClass = Class.forName("java.lang.Module");
        for (String layerName : new String[]{"BOOT", "SERVICE", "PLUGIN", "GAME"}) {
            ModuleLayer layer = NeoForgeCoreLoader.getModuleLayer(layerName);
            Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule");
            for (Module module : nameToModule.values()) {
                for (String pkg : module.getDescriptor().packages()) {
                    StaticComponentContainer.Methods.invokeStaticDirect(mClass, "addExportsToAll0", module, pkg);
                    StaticComponentContainer.Methods.invokeStaticDirect(mClass, "addExportsToAllUnnamed0", module, pkg);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static void finalizeModule(String oldName, String newName, Module module, ClassLoader target, ClassLoader ... loaders) {
        void var10_12;
        String moduleName = module.getName();
        HashSet<Class> allMoved = new HashSet<Class>();
        HashMap removals = new HashMap();
        ClassLoader[] classLoaderArray = loaders;
        int n = classLoaderArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            ClassLoader loader = classLoaderArray[var10_12];
            HashSet classes = (HashSet)StaticComponentContainer.Fields.getDirect((Object)loader, "classes");
            if (!Objects.isNull(classes)) {
                classes = new HashSet(classes);
                for (Class c : classes) {
                    String name = c.getModule().getName();
                    if (Objects.isNull(name) || !name.equals(oldName) && !name.equals(newName)) continue;
                    StaticComponentContainer.Fields.setDirect((Object)c, "classLoader", (Object)target);
                    allMoved.add(c);
                    removals.putIfAbsent(loader, new HashSet());
                    ((Collection)removals.get(loader)).add(c);
                    StaticComponentContainer.Fields.setDirect((Object)c, "module", (Object)module);
                }
            }
            ++var10_12;
        }
        Collection targetClasses = (Collection)StaticComponentContainer.Fields.getDirect((Object)target, "classes");
        for (Class clazz : targetClasses) {
            String name = clazz.getModule().getName();
            if (!Objects.nonNull(moduleName) || !moduleName.equals(name)) continue;
            StaticComponentContainer.Fields.setDirect((Object)clazz, "module", (Object)module);
        }
        targetClasses.addAll(allMoved);
        for (Map.Entry entry : removals.entrySet()) {
            Collection classes = (Collection)StaticComponentContainer.Fields.getDirect(entry.getKey(), "classes");
            classes.removeAll((Collection)entry.getValue());
        }
    }

    static Class<?> findClassInHeirarchy(ClassLoader loader, String className) {
        Class<?> foundClass = null;
        ClassLoader searchIn = loader;
        while (Objects.nonNull(searchIn)) {
            try {
                foundClass = StaticComponentContainer.Driver.getClassByName(className, false, loader, StaticComponentContainer.Classes.getClass());
            }
            catch (Throwable t) {
                LOGGER.debug("Class not found in ClassLoader {} (name = {})", (Object)searchIn, (Object)className);
            }
            if (Objects.nonNull(foundClass)) break;
            searchIn = StaticComponentContainer.ClassLoaders.getParent(searchIn);
        }
        if (Objects.isNull(foundClass)) {
            LOGGER.error("Class {} not found in ClassLoader heirarchy for {}", (Object)className, (Object)loader);
            return null;
        }
        return foundClass;
    }

    public static Object[] findModuleLoaderForPackage(String pkg, ClassLoader[] loaders) {
        for (int i = 0; i < loaders.length; ++i) {
            ClassLoader loader = loaders[i];
            String name = i == 0 ? "BOOT" : (i == 1 ? "SERVICE" : "PLUGIN");
            Map lookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "packageLookup");
            Object resolvedModule = lookup.get(pkg);
            if (!Objects.nonNull(resolvedModule)) continue;
            return new Object[]{loader, resolvedModule, name};
        }
        return null;
    }

    public static void fixForServiceLayer() {
        LOGGER.info("Running SERVICE layer fix");
        ClassLoader thisLoader = NeoForgeCoreLoader.class.getClassLoader();
        if (thisLoader == NeoForgeCoreLoader.bootLoader()) {
            LOGGER.warn("Tried to fix SERVICE layer twice!");
            return;
        }
        String pkg = ConsulterSupplyFunction.class.getPackage().getName();
        Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "packageLookup");
        ResolvedModule module = (ResolvedModule)packageLookup.get(pkg);
        if (Objects.nonNull(module)) {
            HashSet<String> packages = new HashSet<String>(NeoForgeCoreLoader.addResolvedModule(module, thisLoader));
            packageLookup.entrySet().removeIf(entry -> {
                if (module.equals(entry.getValue())) {
                    packages.add((String)entry.getKey());
                    return true;
                }
                return false;
            });
            ClassLoader boot = NeoForgeCoreLoader.bootLoader();
            Map bootLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)boot, "packageLookup");
            Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)thisLoader, "parentLoaders");
            for (String p : packages) {
                bootLookup.put(p, module);
                parentLoaders.put(p, boot);
            }
            LOGGER.info("Finished migrating module {} from the SERVICE layer to the BOOT layer", (Object)module.name());
        } else {
            LOGGER.fatal("FAILED TO GET RESOLVED MODULE FOR {}", (Object)pkg);
        }
    }

    public static void fixService(String service, String impl, ClassLoader loaderFrom) {
        NeoForgeCoreLoader.fixService(service, impl, loaderFrom, false);
    }

    public static void fixService(String service, String impl, ClassLoader loaderFrom, boolean isRemoval) {
        LOGGER.info("Attempting to fix service {} (implementation of {})", (Object)impl, (Object)service);
        ClassLoader loader = NeoForgeCoreLoader.bootLoader();
        String pkg = ConsulterSupplyFunction.class.getPackage().getName();
        Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "packageLookup");
        ResolvedModule resolved = (ResolvedModule)packageLookup.get(pkg);
        if (Objects.isNull(resolved)) {
            LOGGER.error("Failed to get module from package! {}", (Object)pkg);
            return;
        }
        String name = resolved.name();
        ModuleLayer serviceLayer = NeoForgeCoreLoader.getModuleLayer("SERVICE");
        ModuleLayer bootLayer = NeoForgeCoreLoader.getModuleLayer("BOOT");
        Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)bootLayer, "nameToModule");
        Module module = (Module)nameToModule.get(name);
        if (Objects.isNull(module)) {
            LOGGER.error("Failed to get module {} in BOOT layer!", (Object)name);
            return;
        }
        NeoForgeCoreLoader.fixServiceFor(service, impl, module, bootLayer, isRemoval);
        if (!isRemoval) {
            NeoForgeCoreLoader.fixServiceFor(service, impl, module, serviceLayer, true);
            try {
                Class<?> implClass = Class.forName(impl, false, loader);
                StaticComponentContainer.Fields.setDirect(implClass, "module", (Object)module);
                StaticComponentContainer.Fields.setDirect(implClass, "classLoader", (Object)loader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        LOGGER.info("Sucessfully notified the ServicesCatalog that {} has been moved", (Object)impl);
    }

    private static void fixServiceFor(String service, String impl, Module module, ModuleLayer layer, boolean isRemoval) {
        Object servicesCatalog = NeoForgeCoreLoader.getServicesCatalog(NeoForgeCoreLoader.getModuleLayer("BOOT"));
        Class<?> pClass = NeoForgeCoreLoader.serviceProviderClass(servicesCatalog);
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(servicesCatalog, "map"));
        Object found = null;
        if (map.containsKey(service)) {
            List providers = (List)map.get(service);
            for (Object provider : providers) {
                String name = (String)StaticComponentContainer.Methods.invokeDirect(provider, "providerName", new Object[0]);
                if (!name.equals(impl)) continue;
                StaticComponentContainer.Fields.setDirect(provider, "module", (Object)module);
                found = provider;
            }
        }
        if (Objects.nonNull(found)) {
            if (isRemoval) {
                ((List)map.get(service)).remove(found);
            }
        } else if (!isRemoval) {
            Object provider = StaticComponentContainer.Constructors.newInstanceOf(pClass, module, impl);
            StaticComponentContainer.Methods.invokeDirect(servicesCatalog, "addProviders", service, provider);
        }
    }

    static ArgumentHandler getArgumentHandler() {
        return (ArgumentHandler)StaticComponentContainer.Fields.getDirect((Object)Launcher.INSTANCE, "argumentHandler");
    }

    @Nullable
    public static Object getBootLoadedCoreAPI() {
        return NeoForgeCoreLoader.getCoreAPIReflectively(NeoForgeCoreLoader.bootLoader());
    }

    static Object getCoreAPIReflectively(ClassLoader loader) {
        try {
            return StaticComponentContainer.Fields.getStaticDirect(Class.forName(APICORE, false, loader), "INSTANCE");
        }
        catch (ClassNotFoundException ex) {
            LOGGER.debug("CoreAPI not found on {}", (Object)loader);
            return null;
        }
    }

    static IModuleLayerManager getLayerManager() {
        return Launcher.INSTANCE.environment().findModuleLayerManager().orElse(null);
    }

    static Module getModuleFromLayer(String layerName, String name) {
        ModuleLayer layer = NeoForgeCoreLoader.getModuleLayer(layerName);
        Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule");
        return (Module)nameToModule.get(name);
    }

    public static Module getModuleFromPackage(String pkg, String layerName, boolean newFormat) {
        ModuleLayer layer = NeoForgeCoreLoader.getModuleLayer(layerName);
        Map packageLookup = (Map)StaticComponentContainer.Fields.get((Object)NeoForgeCoreLoader.layerClassLoader(layerName), "packageLookup");
        ResolvedModule resolved = (ResolvedModule)packageLookup.get(pkg);
        if (Objects.isNull(resolved)) {
            LOGGER.error("Cannot get module for pacakge {} since it does not exist in input layer {}!", (Object)pkg, (Object)layerName);
            return null;
        }
        Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule");
        return (Module)nameToModule.get(resolved.name());
    }

    static ModuleLayer getModuleLayer(String name) {
        IModuleLayerManager layerManager = NeoForgeCoreLoader.getLayerManager();
        if (Objects.isNull(layerManager)) {
            LOGGER.error("IModuleLayerManager instance not found in environment!");
            return null;
        }
        return layerManager.getLayer(IModuleLayerManager.Layer.valueOf((String)name)).orElse(null);
    }

    static Object getServicesCatalog(ModuleLayer layer) {
        Object langAccess = StaticComponentContainer.Fields.getStaticDirect(ServiceLoader.class, "LANG_ACCESS");
        return StaticComponentContainer.Methods.invokeDirect(langAccess, "getServicesCatalog", layer);
    }

    static String getVersionStr() {
        ArgumentHandler handler = NeoForgeCoreLoader.getArgumentHandler();
        if (Objects.isNull(handler)) {
            return null;
        }
        Object[] rawArgs = (String[])StaticComponentContainer.Fields.getDirect((Object)handler, "args");
        if (Objects.isNull(rawArgs)) {
            LOGGER.error("Failed to find version using handler {}", (Object)handler);
            return null;
        }
        int versionIndex = -1;
        boolean found = false;
        for (int i = 0; i < rawArgs.length; ++i) {
            if (!rawArgs[i].equals("--fml.mcVersion")) continue;
            versionIndex = i + 1;
            found = true;
            break;
        }
        if (found) {
            LOGGER.debug("Found fml.mcVersion arg at index {} -> {}", (Object)versionIndex, rawArgs[versionIndex]);
            return rawArgs[versionIndex];
        }
        LOGGER.error("Failed to find fml.mcVersion or version flags from args {}", (Object)Arrays.toString(rawArgs));
        return null;
    }

    @Nullable
    public static Object initCoreAPI(ClassLoader loader) {
        LOGGER.debug("Starting CoreAPI init");
        Object bootInstance = NeoForgeCoreLoader.getBootLoadedCoreAPI();
        if (Objects.nonNull(bootInstance)) {
            LOGGER.debug("Returning existing CoreAPI instance found in the BOOT layer");
            return bootInstance;
        }
        String version = NeoForgeCoreLoader.getVersionStr();
        Class<?> coreClass = NeoForgeCoreLoader.loadAPI(version, NeoForgeCoreLoader.bootLoader());
        try {
            return coreClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.fatal("Caught reflection exception while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        catch (Exception ex) {
            LOGGER.fatal("Unknown error while trying to get CoreAPI instance as {}", coreClass, (Object)ex);
        }
        LOGGER.fatal("Failed to initialize CoreAPI [NeoForge-{}] using {}", (Object)version, (Object)loader);
        return null;
    }

    public static ClassLoader layerClassLoader(String name) {
        IModuleLayerManager.Layer layer = IModuleLayerManager.Layer.valueOf((String)name);
        IModuleLayerManager layerManager = NeoForgeCoreLoader.getLayerManager();
        if (Objects.isNull(layerManager)) {
            LOGGER.error("IModuleLayerManager instance not found in environment!");
            return NeoForgeCoreLoader.bootLoader();
        }
        Map completedLayers = (Map)StaticComponentContainer.Fields.getDirect((Object)layerManager, "completedLayers");
        ClassLoader loader = (ClassLoader)StaticComponentContainer.Fields.get(completedLayers.get(layer), "cl");
        LOGGER.debug("Returning ClassLoader for layer {} as {}", (Object)name, (Object)loader);
        return loader;
    }

    static Class<?> loadAPI(String version, ClassLoader loader) {
        String className = NeoForgeCoreLoader.versionClassName("core.TILCoreNeoForge", version);
        Class<?> clazz = null;
        try {
            clazz = StaticComponentContainer.Driver.getClassByName(className, true, loader, StaticComponentContainer.Classes.getClass());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load class {} for {}", (Object)className, (Object)loader, (Object)ex);
        }
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Failed to load CoreAPI instance [NeoForge-" + version + "]");
        }
        LOGGER.debug("Successfully loaded CoreAPI instance {}", clazz);
        return clazz;
    }

    static void loadNewModuleTo(@Nullable IModInfo mod, String targetLayerName, Set<String> finalizedPkgs) {
        if (Objects.isNull(mod)) {
            LOGGER.error("Cannot load module from nonexistent file!");
            return;
        }
        try {
            ModuleDescriptor descriptor;
            IModFileInfo fileInfo = mod.getOwningFile();
            IModFile file = fileInfo.getFile();
            SecureJar jar = file.getSecureJar();
            ClassLoader targetLoader = NeoForgeCoreLoader.layerClassLoader("GAME");
            String existingName = (String)StaticComponentContainer.Methods.invokeDirect(jar, "name", new Object[0]);
            String name = mod.getModId();
            ModuleLayer layer = NeoForgeCoreLoader.getModuleLayer(targetLayerName);
            Map nameToModule = (Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule");
            boolean foundExistingName = true;
            Module module = (Module)nameToModule.get(existingName);
            if (Objects.isNull(module)) {
                module = (Module)nameToModule.get(name);
                foundExistingName = false;
            }
            boolean existed = false;
            if (Objects.nonNull(module)) {
                LOGGER.info("Found existing module to set up for {}", (Object)name);
                existed = true;
            } else {
                LOGGER.info("Setting up new module with name {}", (Object)name);
            }
            if (Objects.nonNull(module)) {
                descriptor = module.getDescriptor();
                StaticComponentContainer.Fields.setDirect((Object)descriptor, "name", (Object)name);
            } else {
                List usesServices = fileInfo.usesServices();
                descriptor = NeoForgeCoreLoader.buildNewModuleDescriptor(name, (Jar)jar, usesServices);
            }
            JarModuleFinder finder = JarModuleFinder.of((SecureJar[])new SecureJar[]{jar});
            Map refMap = (Map)StaticComponentContainer.Fields.getDirect((Object)finder, "moduleReferenceMap");
            ModuleReference reference = (ModuleReference)refMap.get(existingName);
            URI uri = (URI)StaticComponentContainer.Fields.getDirect((Object)reference, "location");
            Configuration config = (Configuration)StaticComponentContainer.Fields.getDirect((Object)targetLoader, "configuration");
            StaticComponentContainer.Fields.setDirect((Object)reference, "descriptor", (Object)descriptor);
            ResolvedModule resolvedModule = (ResolvedModule)StaticComponentContainer.Constructors.newInstanceOf(ResolvedModule.class, config, reference);
            Set<String> packages = new HashSet<String>(resolvedModule.reference().descriptor().packages());
            packages.removeAll(finalizedPkgs);
            packages = Collections.unmodifiableSet(packages);
            finalizedPkgs.addAll(packages);
            if (Objects.isNull(module)) {
                module = (Module)StaticComponentContainer.Constructors.newInstanceOf(Module.class, layer, targetLoader, descriptor, uri);
            }
            NeoForgeCoreLoader.addModuleThouroughly(module, resolvedModule, layer, name, packages, reference, targetLoader);
            LOGGER.info("Finished setting up {}", (Object)module);
            ClassLoader boot = NeoForgeCoreLoader.bootLoader();
            ClassLoader service = NeoForgeCoreLoader.layerClassLoader("SERVICE");
            ClassLoader plugin = NeoForgeCoreLoader.layerClassLoader("PLUGIN");
            NeoForgeCoreLoader.nukeConfig(name, boot, service, plugin);
            NeoForgeCoreLoader.nukeLoaderFields(name, boot, service, plugin);
            NeoForgeCoreLoader.nukeModuleLayer(name, "BOOT", "SERVICE", "PLUGIN");
            if (!existingName.equals(name) && existed) {
                NeoForgeCoreLoader.nukeConfig(existingName, boot, service, plugin, targetLoader);
                NeoForgeCoreLoader.nukeLoaderFields(existingName, boot, service, plugin, targetLoader);
                NeoForgeCoreLoader.nukeModuleLayer(existingName, "BOOT", "SERVICE", "PLUGIN", "GAME");
            }
            if (foundExistingName) {
                nameToModule.remove(existingName);
            }
            nameToModule.put(name, module);
            NeoForgeCoreLoader.finalizeModule(existingName, name, module, targetLoader, boot, service, plugin);
            LOGGER.warn("------------------------------------------------------------------------------------------------");
            LOGGER.warn("SUCCESSFULLY LOADED {} TO THE GAME LAYER HAVE A NICE DAY", (Object)name);
            LOGGER.warn("------------------------------------------------------------------------------------------------");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load new module!", t);
        }
    }

    public static void moveModuleToLayer(ClassLoader targetLoader, String layerTo, String layerFrom, String moduleName) {
        LOGGER.info("Moving module {} from {} to {}", (Object)moduleName, (Object)layerFrom, (Object)layerTo);
        ModuleLayer to = NeoForgeCoreLoader.getModuleLayer(layerTo);
        if (Objects.isNull(to)) {
            LOGGER.error("Unable to move module {}! Cannot find target layer {}", (Object)moduleName, (Object)layerTo);
            return;
        }
        ModuleLayer from = NeoForgeCoreLoader.getModuleLayer(layerFrom);
        if (Objects.isNull(from)) {
            LOGGER.error("Unable to move module {}! Cannot find supplier layer {}", (Object)moduleName, (Object)layerFrom);
            return;
        }
        String fieldName = "nameToModule";
        HashMap moduleMapFrom = new HashMap((Map)StaticComponentContainer.Fields.get((Object)from, fieldName));
        Module module = (Module)moduleMapFrom.get(moduleName);
        if (Objects.isNull(module)) {
            LOGGER.error("Unable to move module {}! Cannot find module in supplier layer {}", (Object)moduleName, (Object)layerFrom);
            return;
        }
        StaticComponentContainer.Fields.setDirect((Object)module, "loader", (Object)targetLoader);
        StaticComponentContainer.Fields.setDirect((Object)module, "layer", (Object)to);
        HashMap<String, Module> moduleMapTo = new HashMap<String, Module>((Map)StaticComponentContainer.Fields.get((Object)to, fieldName));
        moduleMapTo.put(moduleName, module);
        moduleMapFrom.remove(moduleName);
        StaticComponentContainer.Fields.setDirect((Object)from, fieldName, Collections.unmodifiableMap(moduleMapFrom));
        StaticComponentContainer.Fields.setDirect((Object)to, fieldName, Collections.unmodifiableMap(moduleMapTo));
        HashSet modulesFrom = (HashSet)StaticComponentContainer.Fields.getDirect((Object)from, "modules");
        if (Objects.nonNull(modulesFrom)) {
            modulesFrom = new HashSet(modulesFrom);
            modulesFrom.remove(module);
            StaticComponentContainer.Fields.setDirect((Object)from, "modules", Collections.unmodifiableSet(modulesFrom));
        }
        HashSet<Module> modulesTo = (HashSet<Module>)StaticComponentContainer.Fields.getDirect((Object)from, "modules");
        LOGGER.info("modules collection null for layer {}? {}", (Object)layerTo, (Object)Objects.isNull(modulesTo));
        modulesTo = Objects.nonNull(modulesTo) ? new HashSet<Module>(modulesTo) : new HashSet();
        modulesTo.add(module);
        StaticComponentContainer.Fields.setDirect((Object)to, "modules", Collections.unmodifiableSet(modulesTo));
        NeoForgeCoreLoader.addToServiceCatalog(module, to);
    }

    public static void nukeAndFinalize(IModInfo mod, String pkg, Set<String> finalizedPkgs) {
        LOGGER.info("Finalizing package {}", (Object)pkg);
        ClassLoader boot = NeoForgeCoreLoader.bootLoader();
        ClassLoader service = NeoForgeCoreLoader.layerClassLoader("SERVICE");
        ClassLoader plugin = NeoForgeCoreLoader.layerClassLoader("PLUGIN");
        Object[] found = NeoForgeCoreLoader.findModuleLoaderForPackage(pkg, new ClassLoader[]{boot, service, plugin});
        if (Objects.isNull(found)) {
            NeoForgeCoreLoader.loadNewModuleTo(mod, "GAME", finalizedPkgs);
            return;
        }
        ClassLoader foundLoader = (ClassLoader)found[0];
        ResolvedModule resolvedModule = (ResolvedModule)found[1];
        LOGGER.info("Got resolved module as {}", (Object)resolvedModule);
        String name = resolvedModule.name();
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        LOGGER.warn("NUKING ALL REFERENCES OF MODULE {} FROM THE BOOT, SERVICE, & PLUGIN LAYERS", (Object)name);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        Map bootRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)foundLoader, "resolvedRoots");
        ModuleReference ref = (ModuleReference)bootRoots.get(name);
        ModuleLayer foundLayer = NeoForgeCoreLoader.getModuleLayer((String)found[2]);
        Map layerModules = (Map)StaticComponentContainer.Fields.getDirect((Object)foundLayer, "nameToModule");
        Module module = (Module)layerModules.get(name);
        ClassLoader target = NeoForgeCoreLoader.layerClassLoader("GAME");
        ModuleLayer moduleLayer = NeoForgeCoreLoader.getModuleLayer("GAME");
        Set<String> packages = new HashSet<String>(resolvedModule.reference().descriptor().packages());
        packages.removeAll(finalizedPkgs);
        packages = Collections.unmodifiableSet(packages);
        finalizedPkgs.addAll(packages);
        NeoForgeCoreLoader.addModuleThouroughly(module, resolvedModule, moduleLayer, name, packages, ref, target);
        NeoForgeCoreLoader.nukeConfig(name, boot, service, plugin);
        NeoForgeCoreLoader.nukeLoaderFields(name, boot, service, plugin);
        NeoForgeCoreLoader.nukeModuleLayer(name, "BOOT", "SERVICE", "PLUGIN");
        NeoForgeCoreLoader.finalizeModule(name, name, module, target, boot, service, plugin);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
        LOGGER.warn("MODULE {} HAS BEEN SUCCESSFULLY MOVED TO THE GAME LAYER HAVE A NICE DAY", (Object)name);
        LOGGER.warn("------------------------------------------------------------------------------------------------");
    }

    static void nukeConfig(String name, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            Configuration configuration = (Configuration)StaticComponentContainer.Fields.getDirect((Object)loader, "configuration");
            HashMap nameToModule = new HashMap((Map)StaticComponentContainer.Fields.getDirect((Object)configuration, "nameToModule"));
            ResolvedModule module = (ResolvedModule)nameToModule.get(name);
            if (!Objects.nonNull(module)) continue;
            nameToModule.remove(name);
            StaticComponentContainer.Fields.setDirect((Object)configuration, "nameToModule", Collections.unmodifiableMap(nameToModule));
            HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(configuration.modules());
            modules.remove(module);
            StaticComponentContainer.Fields.setDirect((Object)configuration, "modules", modules);
        }
    }

    static void nukeLoaderFields(String moduleName, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            Set<String> packages;
            Map resolvedRoots = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "resolvedRoots");
            Map packageLookup = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "packageLookup");
            Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)loader, "parentLoaders");
            resolvedRoots.remove(moduleName);
            ResolvedModule module = null;
            for (Map.Entry pkgEntry : packageLookup.entrySet()) {
                ResolvedModule value = (ResolvedModule)pkgEntry.getValue();
                if (!moduleName.equals(value.name())) continue;
                module = value;
                break;
            }
            if (Objects.isNull(module) || Objects.isNull(packages = module.reference().descriptor().packages())) continue;
            for (String pkg : packages) {
                packageLookup.remove(pkg);
                parentLoaders.remove(pkg);
            }
        }
    }

    static void nukeModuleLayer(String name, String ... layers) {
        for (String layer : layers) {
            ModuleLayer moduleLayer = NeoForgeCoreLoader.getModuleLayer(layer);
            if (Objects.isNull(moduleLayer)) {
                LOGGER.warn("Not nuking module layer {} since it was not found", (Object)layer);
                continue;
            }
            HashMap nameToModule = new HashMap((Map)StaticComponentContainer.Fields.getDirect((Object)moduleLayer, "nameToModule"));
            nameToModule.remove(name);
            StaticComponentContainer.Fields.setDirect((Object)moduleLayer, "nameToModule", Collections.unmodifiableMap(nameToModule));
            Set<Module> modules = moduleLayer.modules();
            if (!Objects.nonNull(modules)) continue;
            modules = new HashSet<Module>(modules);
            modules.removeIf(m -> name.equals(m.getName()));
            StaticComponentContainer.Fields.setDirect((Object)moduleLayer, "modules", Collections.unmodifiableSet(modules));
        }
    }

    static void removeFromUnmodifiableMapField(Object object, String name, Object toRemove) {
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(object, name));
        map.remove(toRemove);
        StaticComponentContainer.Fields.setDirect(object, name, Collections.unmodifiableMap(map));
    }

    static void removeFromUnmodifiableSetField(Object object, String name, Object toRemove) {
        HashSet set = new HashSet((Collection)StaticComponentContainer.Fields.getDirect(object, name));
        set.remove(toRemove);
        StaticComponentContainer.Fields.setDirect(object, name, Collections.unmodifiableSet(set));
    }

    public static void removeServiceFrom(String service, String impl, String layer) {
        LOGGER.info("Attempting to fix service {} (implementation of {})", (Object)impl, (Object)service);
        String moduleName = "theimpossiblelibrary";
        Object servicesCatalog = NeoForgeCoreLoader.getServicesCatalog(NeoForgeCoreLoader.getModuleLayer(layer));
        Class<?> pClass = NeoForgeCoreLoader.serviceProviderClass(servicesCatalog);
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect(servicesCatalog, "map"));
        if (map.containsKey(service)) {
            ((List)map.get(service)).removeIf(provider -> impl.equals(StaticComponentContainer.Methods.invokeDirect(provider, "providerName", new Object[0])));
        }
        LOGGER.info("Sucessfully removed all service providers from {} layer for {}", (Object)layer, (Object)impl);
    }

    public static void resyncModules(ClassLoader loaderTo, String layerTo, ClassLoader loaderFrom) {
        LOGGER.info("Resyncing module to {}", (Object)layerTo);
        String pkg = "mods.thecomputerizer.theimpossiblelibrary.neoforge.core";
        Map fromPkg = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderFrom, "packageLookup");
        ResolvedModule fromModule = (ResolvedModule)fromPkg.get("mods.thecomputerizer.theimpossiblelibrary.neoforge.core");
        Configuration fromCfg = (Configuration)StaticComponentContainer.Fields.getDirect((Object)loaderFrom, "configuration");
        if (!"PLUGIN".equals(layerTo)) {
            HashSet<ResolvedModule> modules = new HashSet<ResolvedModule>(fromCfg.modules());
            modules.add(fromModule);
            StaticComponentContainer.Fields.setDirect((Object)fromCfg, "modules", modules);
        }
        Map pkgs = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, "packageLookup");
        ResolvedModule module = (ResolvedModule)pkgs.get("mods.thecomputerizer.theimpossiblelibrary.neoforge.core");
        String name = module.name();
        Map roots = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, "resolvedRoots");
        roots.remove(name);
        Configuration config = (Configuration)StaticComponentContainer.Fields.getDirect((Object)loaderTo, "configuration");
        NeoForgeCoreLoader.removeFromUnmodifiableSetField(config, "modules", module);
        NeoForgeCoreLoader.removeFromUnmodifiableMapField(config, "nameToModule", name);
        Set<String> packages = module.reference().descriptor().packages();
        ModuleLayer layer = NeoForgeCoreLoader.getModuleLayer(layerTo);
        HashMap map = new HashMap((Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule"));
        map.remove(name);
        StaticComponentContainer.Fields.setDirect((Object)layer, "nameToModule", map);
        Map parentLoaders = (Map)StaticComponentContainer.Fields.getDirect((Object)loaderTo, "parentLoaders");
        for (String p : packages) {
            parentLoaders.put(p, loaderFrom);
        }
        HashMap<ResolvedModule, Set> graph = new HashMap<ResolvedModule, Set>((Map)StaticComponentContainer.Fields.getDirect((Object)config, "graph"));
        graph.remove(module);
        graph.forEach((key, values) -> values.remove(module));
        StaticComponentContainer.Fields.setDirect((Object)config, "graph", graph);
        pkgs.entrySet().removeIf(entry -> module.equals(entry.getValue()));
    }

    public static void sanityCheckModule(Class<?> c, String name) {
        String actualName = c.getModule().getName();
        if (!name.equals(actualName)) {
            StaticComponentContainer.Fields.setDirect(c, "module", (Object)NeoForgeCoreLoader.getModuleFromLayer("GAME", name));
            LOGGER.info("Moved {} from module {} to module {}", c, (Object)actualName, (Object)name);
        }
    }

    @Nullable
    public static Class<?> serviceProviderClass(Object servicesCatalog) {
        if (Objects.isNull(servicesCatalog)) {
            return null;
        }
        Class<?> sClass = servicesCatalog.getClass();
        String providerClassName = sClass.getName() + "$ServiceProvider";
        try {
            return Class.forName(providerClassName);
        }
        catch (ClassNotFoundException ex) {
            LOGGER.error("Failed to find class {}", (Object)providerClassName, (Object)ex);
            return null;
        }
    }

    public static void verifyModule(String className, IModInfo info, ModuleLayer layer) throws Exception {
        Optional<Module> optionalModule;
        LOGGER.info("Verifying that {} is valid for {} and can be found in {}", (Object)className, (Object)info, (Object)layer);
        IModFileInfo fileInfo = info.getOwningFile();
        String modid = info.getModId();
        String moduleName = fileInfo.moduleName();
        IModFile file = fileInfo.getFile();
        if (!modid.equals(moduleName)) {
            LOGGER.error("Mod id {} does not equal module name {}!", (Object)modid, (Object)moduleName);
        }
        if ((optionalModule = layer.findModule(moduleName)).isEmpty()) {
            for (Module module : layer.modules()) {
                if (!moduleName.equals(module.getName())) continue;
                boolean sameLayer = module.getLayer() == layer;
                LOGGER.info("Found module {} in {} layer that wasn't present in the nameToModule map", (Object)moduleName, (Object)(sameLayer ? "the same" : "a different"));
                HashMap<String, Module> nameToModule = new HashMap<String, Module>((Map)StaticComponentContainer.Fields.getDirect((Object)layer, "nameToModule"));
                nameToModule.put(moduleName, module);
                StaticComponentContainer.Fields.setDirect((Object)layer, "nameToModule", Collections.unmodifiableMap(nameToModule));
                break;
            }
        }
        if ((optionalModule = layer.findModule(moduleName)).isPresent()) {
            Class<?> c;
            Module cModule;
            Module module = optionalModule.get();
            if (module != (cModule = (c = Class.forName(className, false, layer.findLoader(module.getName()))).getModule())) {
                LOGGER.info("Attempting to fix modules that are not equal");
                StaticComponentContainer.Fields.setDirect(c, "module", (Object)module);
            } else {
                LOGGER.info("Modules are equal");
            }
        } else {
            LOGGER.error("Module {} is not present in the target layer!", (Object)moduleName);
        }
        LOGGER.info("Finished verifying {}", (Object)className);
    }

    static String versionClassName(String name, String version) {
        return NeoForgeCoreLoader.versionPackage(version) + "." + NeoForgeCoreLoader.versionQuantify(name, version);
    }

    static String versionPackage(String version) {
        String[] split = version.split("\\.");
        if (split.length < 3) {
            throw new RuntimeException("Can't parse package for unknown version " + version);
        }
        return "mods.thecomputerizer.theimpossiblelibrary.neoforge.v" + split[1] + ".m" + split[2];
    }

    static String versionQuantify(String name, String version) {
        return name + version.replace('.', '_');
    }

    static {
        if (NeoForgeCoreLoader.class.getClassLoader() != NeoForgeCoreLoader.bootLoader()) {
            LOGGER.info("I see you are running Java 9+ so I'll be using burningwave to break its strong encapsulation");
        }
        ClassHelper.checkBurningWaveInit();
    }
}

