/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.common.structure.StructureRef;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.jetbrains.annotations.Nullable;

public class World1_12_2
extends WorldAPI<World> {
    public World1_12_2(Object world) {
        super((World)world);
    }

    @Override
    public boolean canSnowAt(BlockPosAPI<?> pos) {
        return ((World)this.wrapped).func_175708_f((BlockPos)pos.unwrap(), false);
    }

    @Override
    public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapBiome(((World)this.wrapped).func_180494_b((BlockPos)pos.unwrap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box box) {
        ArrayList entities = new ArrayList();
        if (Objects.nonNull(this.wrapped)) {
            World world = (World)this.wrapped;
            synchronized (world) {
                for (TileEntity tile : ((World)this.wrapped).field_147482_g) {
                    BlockPos pos = tile.func_174877_v();
                    if (!box.isInside(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) continue;
                    entities.add(WrapperHelper.wrapBlockEntity(tile));
                }
            }
        }
        return entities;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> pos) {
        TileEntity tile = ((World)this.wrapped).func_175625_s((BlockPos)pos.unwrap());
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    @Override
    public int getDayNumber() {
        return (int)((double)this.getTimeTotal() / 24000.0);
    }

    @Override
    public int getDifficultyOrdinal() {
        if (((World)this.wrapped).func_72912_H().func_76093_s()) {
            return 4;
        }
        switch (((World)this.wrapped).func_175659_aa()) {
            case PEACEFUL: {
                return 0;
            }
            case EASY: {
                return 1;
            }
            case NORMAL: {
                return 2;
            }
            case HARD: {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this, ((World)this.wrapped).field_73011_w.func_186058_p());
    }

    @Override
    public List<EntityAPI<?, ?>> getEntitiesInBox(Box box) {
        return this.getEntitiesInBox(new AxisAlignedBB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    public List<EntityAPI<?, ?>> getEntitiesInBox(AxisAlignedBB box) {
        ArrayList entities = new ArrayList();
        for (Entity entity : ((World)this.wrapped).func_72872_a(Entity.class, box)) {
            entities.add(WrapperHelper.wrapEntity(entity));
        }
        return entities;
    }

    @Override
    public int getLightBlock(BlockPosAPI<?> pos) {
        return ((World)this.wrapped).func_175642_b(EnumSkyBlock.BLOCK, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightSky(BlockPosAPI<?> pos) {
        return ((World)this.wrapped).func_175642_b(EnumSkyBlock.SKY, (BlockPos)pos.unwrap());
    }

    @Override
    public int getLightTotal(BlockPosAPI<?> pos) {
        return ((World)this.wrapped).func_175699_k((BlockPos)pos.unwrap());
    }

    @Override
    public List<LivingEntityAPI<?, ?>> getLivingInBox(Box box) {
        return this.getLivingInBox(new AxisAlignedBB(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    public List<LivingEntityAPI<?, ?>> getLivingInBox(AxisAlignedBB box) {
        ArrayList entities = new ArrayList();
        for (EntityLivingBase entity : ((World)this.wrapped).func_72872_a(EntityLivingBase.class, box)) {
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        }
        return entities;
    }

    @Override
    public int getMoonPhase() {
        return ((World)this.wrapped).func_72853_d();
    }

    @Override
    @Nullable
    public String getRaidStatus(BlockPosAPI<?> pos) {
        return null;
    }

    @Override
    public int getRaidWave(BlockPosAPI<?> pos) {
        return -1;
    }

    @Override
    public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapState(((World)this.wrapped).func_180495_p((BlockPos)pos.unwrap()));
    }

    @Override
    public StructureAPI<?> getStructureAt(BlockPosAPI<?> pos) {
        if (this.wrapped instanceof WorldServer) {
            StructureRef ref = StructureRef.getStructureAt((WorldServer)this.wrapped, (BlockPos)pos.unwrap());
            return Objects.nonNull(ref) ? WrapperHelper.wrapStructure(ref) : null;
        }
        return null;
    }

    @Override
    public long getTimeDay() {
        return this.getTimeTotal() % 24000L;
    }

    @Override
    public long getTimeTotal() {
        return ((World)this.wrapped).func_72820_D();
    }

    @Override
    public boolean isClient() {
        return ((World)this.wrapped).field_72995_K;
    }

    @Override
    public boolean isDaytime() {
        return this.getTimeDay() < 13000L;
    }

    @Override
    public boolean isRaining() {
        return ((World)this.wrapped).func_72896_J();
    }

    @Override
    public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return ((World)this.wrapped).func_175710_j((BlockPos)pos.unwrap());
    }

    @Override
    public boolean isStorming() {
        return ((World)this.wrapped).func_72911_I();
    }

    @Override
    public boolean isSunrise() {
        return this.getTimeDay() >= 23000L;
    }

    @Override
    public boolean isSunset() {
        long time = this.getTimeDay();
        return time >= 12000L && time < 13000L;
    }

    @Override
    public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        ((World)this.wrapped).func_175656_a((BlockPos)pos.unwrap(), (IBlockState)state.unwrap());
    }

    @Override
    public void spawnEntity(EntityAPI<?, ?> entity, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((World)this.wrapped).field_72995_K) {
            ((World)this.wrapped).func_72838_d((Entity)entity.unwrapEntity());
            if (Objects.nonNull(onSpawn)) {
                onSpawn.accept(entity);
            }
        }
    }

    @Override
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((World)this.wrapped).field_72995_K) {
            EntityItem item = new EntityItem((World)this.wrapped, pos.dX(), pos.dY(), pos.dZ(), (ItemStack)stack.unwrap());
            item.func_174869_p();
            this.spawnEntity(WrapperHelper.wrapEntity(item), onSpawn);
        }
    }

    @Override
    public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((World)this.wrapped).field_72995_K) {
            ItemStackAPI stack = WrapperHelper.wrapItemStack(new ItemStack((Item)api.unwrap()));
            if (Objects.nonNull(beforeSpawn)) {
                beforeSpawn.accept(stack);
            }
            this.spawnItem(stack, pos, onSpawn);
        }
    }
}

