/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.legacy.v12.m2.integration;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.Weather2API;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import net.minecraft.world.World;
import net.mrbt0907.weather2.api.WeatherAPI;
import net.mrbt0907.weather2.api.weather.WeatherEnum;
import net.mrbt0907.weather2.util.Maths;
import net.mrbt0907.weather2.weather.WeatherManager;
import net.mrbt0907.weather2.weather.storm.SandstormObject;
import net.mrbt0907.weather2.weather.storm.WeatherObject;
import org.jetbrains.annotations.Nullable;

public class Weather21_12_2
extends Weather2API {
    @Nullable
    public Weather2API.WeatherType convertType(WeatherEnum.Type type) {
        switch (type) {
            case BLIZZARD: {
                return Weather2API.WeatherType.BLIZZARD;
            }
            case CLOUD: {
                return Weather2API.WeatherType.CLOUD;
            }
            case HURRICANE: {
                return Weather2API.WeatherType.HURRICANE;
            }
            case RAIN: {
                return Weather2API.WeatherType.RAIN;
            }
            case SANDSTORM: {
                return Weather2API.WeatherType.SANDSTORM;
            }
            case SUPERCELL: {
                return Weather2API.WeatherType.SUPERCELL;
            }
            case THUNDER: {
                return Weather2API.WeatherType.THUNDER;
            }
            case TORNADO: {
                return Weather2API.WeatherType.TORNADO;
            }
            case TROPICAL_DEPRESSION: {
                return Weather2API.WeatherType.TROPICAL_DEPRESSION;
            }
            case TROPICAL_DISTURBANCE: {
                return Weather2API.WeatherType.TROPICAL_DISTURBANCE;
            }
            case TROPICAL_STORM: {
                return Weather2API.WeatherType.TROPICAL_STORM;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestBlizzard(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        return this.getClosestData(world, pos, distance, Weather2API.WeatherType.BLIZZARD);
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestCloud(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        return this.getClosestData(world, pos, distance, Weather2API.WeatherType.CLOUD);
    }

    @Nullable
    public Weather2API.WeatherData getClosestData(WorldAPI<?> world, BlockPosAPI<?> pos, double distance, Weather2API.WeatherType type) {
        WeatherObject weather = this.getClosestWeatherType(world, pos, distance, type);
        return Objects.nonNull(weather) ? new Weather2API.WeatherData(this.convertType(weather.type), this.toBuiltInVec(weather.pos), weather.getStage()) : null;
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestHurricane(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        return this.getClosestData(world, pos, distance, Weather2API.WeatherType.HURRICANE);
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestSandStorm(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        WeatherManager manager = this.getManager(world);
        if (Objects.nonNull(manager)) {
            SandstormObject storm = manager.getClosestSandstorm(this.toVec(pos), distance);
            return Objects.nonNull(storm) ? new Weather2API.WeatherData(this.convertType(storm.type), this.toBuiltInVec(storm.pos), storm.getStage()) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestStorm(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        WeatherManager manager = this.getManager(world);
        if (Objects.nonNull(manager)) {
            WeatherObject weather = manager.getClosestWeather(this.toVec(pos), distance);
            return Objects.nonNull(weather) ? new Weather2API.WeatherData(this.convertType(weather.type), this.toBuiltInVec(weather.pos), weather.getStage()) : null;
        }
        return null;
    }

    @Override
    @Nullable
    public Weather2API.WeatherData getClosestTornado(WorldAPI<?> world, BlockPosAPI<?> pos, double distance) {
        return this.getClosestData(world, pos, distance, Weather2API.WeatherType.TORNADO);
    }

    @Nullable
    public WeatherObject getClosestWeatherType(WorldAPI<?> world, BlockPosAPI<?> pos, double distance, Weather2API.WeatherType type) {
        Map<WeatherObject, Integer> systems = this.getWeatherTypeAround(world, pos, distance, type);
        Maths.Vec3 vec = this.toVec(pos);
        WeatherObject ret = null;
        double minDist = distance + 1.0;
        for (WeatherObject weather : systems.keySet()) {
            double dist = weather.pos.distanceSq(vec) - (double)weather.size;
            if (!(dist < minDist)) continue;
            minDist = dist;
            ret = weather;
        }
        return ret;
    }

    @Nullable
    public WeatherManager getManager(WorldAPI<?> world) {
        return WeatherAPI.getManager((World)((World)world.unwrap()));
    }

    public Map<WeatherObject, Integer> getWeatherTypeAround(WorldAPI<?> world, BlockPosAPI<?> pos, double distance, Weather2API.WeatherType type) {
        WeatherManager manager = this.getManager(world);
        Map map = Objects.nonNull(manager) ? manager.getWeatherSystems(this.toVec(pos), distance) : Collections.emptyMap();
        map.entrySet().removeIf(entry -> this.convertType(((WeatherObject)entry.getKey()).type) != type);
        return map;
    }

    public Vector3 toBuiltInVec(Maths.Vec3 vec) {
        return new Vector3(vec.posX, vec.posY, vec.posZ);
    }

    public Maths.Vec3 toVec(BlockPosAPI<?> pos) {
        return new Maths.Vec3(pos.x(), pos.y(), pos.z());
    }
}

