/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v21.network;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.forge.v21.network.MessageWrapperForge1_21;
import mods.thecomputerizer.theimpossiblelibrary.shared.v21.network.Network1_21;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import org.jetbrains.annotations.Nullable;

public class NetworkForge1_21
extends Network1_21<Channel<CustomPacketPayload>, NetworkDirection<?>> {
    private Channel<CustomPacketPayload> network;

    static <B extends ByteBuf> StreamCodec<B, MessageWrapperForge1_21> streamCodec() {
        return StreamCodec.of((buf, payload) -> payload.encode((ByteBuf)buf), MessageWrapperForge1_21::getInstance);
    }

    @Override
    public NetworkDirection<?> getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT" -> NetworkDirection.LOGIN_TO_CLIENT;
            case "PLAY_TO_SERVER" -> NetworkDirection.PLAY_TO_SERVER;
            case "LOGIN_TO_SERVER" -> NetworkDirection.LOGIN_TO_SERVER;
            default -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }

    @Override
    public String getNameFromDir(NetworkDirection<?> dir) {
        if (dir == NetworkDirection.PLAY_TO_CLIENT) {
            return "PLAY_TO_CLIENT";
        }
        if (dir == NetworkDirection.PLAY_TO_SERVER) {
            return "PLAY_TO_SERVER";
        }
        if (dir == NetworkDirection.LOGIN_TO_CLIENT) {
            return "LOGIN_TO_CLIENT";
        }
        if (dir == NetworkDirection.LOGIN_TO_SERVER) {
            return "LOGIN_TO_SERVER";
        }
        if (dir == NetworkDirection.CONFIGURATION_TO_CLIENT) {
            return "CONFIGURATION_TO_CLIENT";
        }
        return "CONFIGURATION_TO_SERVER";
    }

    @Override
    public NetworkDirection<?> getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection<?> getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection<?> getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection<?> getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection<?> getOppositeDir(NetworkDirection<?> dir) {
        if (dir == NetworkDirection.PLAY_TO_CLIENT) {
            return NetworkDirection.PLAY_TO_SERVER;
        }
        if (dir == NetworkDirection.PLAY_TO_SERVER) {
            return NetworkDirection.PLAY_TO_CLIENT;
        }
        if (dir == NetworkDirection.LOGIN_TO_CLIENT) {
            return NetworkDirection.LOGIN_TO_SERVER;
        }
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public Channel<CustomPacketPayload> getNetwork() {
        if (Objects.isNull(this.network)) {
            ResourceLocation name = (ResourceLocation)TILRef.res("main_network").unwrap();
            this.network = ((PayloadFlow)ChannelBuilder.named((ResourceLocation)name).clientAcceptedVersions((status, version) -> true).serverAcceptedVersions((status, version) -> true).networkProtocolVersion(1).payloadChannel().any().bidirectional()).addMain(MessageWrapperForge1_21.TYPE, NetworkForge1_21.streamCodec(), MessageWrapperAPI::handle).build();
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection<?> dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection<?> dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection<?>> dir, int id) {
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send((Object)((MessageWrapperForge1_21)message), PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)));
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().send((Object)((MessageWrapperForge1_21)message), PacketDistributor.SERVER.noArg());
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection<?> dir, MessageAPI<CTX> message) {
        MessageWrapperForge1_21 wrapper = MessageWrapperForge1_21.getInstance();
        wrapper.setMessage(dir, message);
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection<?> dir, MessageAPI<CTX> ... messages) {
        MessageWrapperForge1_21 wrapper = MessageWrapperForge1_21.getInstance();
        wrapper.setMessages(dir, messages);
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection<?> dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperForge1_21 wrapper = MessageWrapperForge1_21.getInstance();
        wrapper.setMessages(dir, messages);
        return wrapper;
    }
}

