/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.v18.m2.network;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageDirectionInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.network.message.MessageWrapperAPI;
import mods.thecomputerizer.theimpossiblelibrary.shared.v18.m2.network.Network1_18_2;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class NetworkForge1_18_2
extends Network1_18_2<SimpleChannel, NetworkDirection> {
    private SimpleChannel network;

    @Override
    public NetworkDirection getDirFromName(String name) {
        return switch (name.toUpperCase()) {
            case "LOGIN_TO_CLIENT" -> NetworkDirection.LOGIN_TO_CLIENT;
            case "PLAY_TO_SERVER" -> NetworkDirection.PLAY_TO_SERVER;
            case "LOGIN_TO_SERVER" -> NetworkDirection.LOGIN_TO_SERVER;
            default -> NetworkDirection.PLAY_TO_CLIENT;
        };
    }

    @Override
    public String getNameFromDir(NetworkDirection dir) {
        return dir.name();
    }

    @Override
    public NetworkDirection getDirToClient() {
        return NetworkDirection.PLAY_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToClientLogin() {
        return NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public NetworkDirection getDirToServer() {
        return NetworkDirection.PLAY_TO_SERVER;
    }

    @Override
    public NetworkDirection getDirToServerLogin() {
        return NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    @Nullable
    public NetworkDirection getOppositeDir(NetworkDirection dir) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case NetworkDirection.PLAY_TO_CLIENT -> NetworkDirection.PLAY_TO_SERVER;
            case NetworkDirection.PLAY_TO_SERVER -> NetworkDirection.PLAY_TO_CLIENT;
            case NetworkDirection.LOGIN_TO_CLIENT -> NetworkDirection.LOGIN_TO_SERVER;
            case NetworkDirection.LOGIN_TO_SERVER -> NetworkDirection.LOGIN_TO_CLIENT;
        };
    }

    @Override
    public SimpleChannel getNetwork() {
        if (Objects.isNull(this.network)) {
            this.network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)((ResourceLocation)TILRef.res("main_network").unwrap())).clientAcceptedVersions(version -> true).serverAcceptedVersions(version -> true).networkProtocolVersion(TILRef::getNetworkVersion).simpleChannel();
        }
        return this.network;
    }

    @Override
    public boolean isDirToClient(NetworkDirection dir) {
        return dir == NetworkDirection.PLAY_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_CLIENT;
    }

    @Override
    public boolean isDirLogin(NetworkDirection dir) {
        return dir == NetworkDirection.LOGIN_TO_CLIENT || dir == NetworkDirection.LOGIN_TO_SERVER;
    }

    @Override
    public void registerMessage(MessageDirectionInfo<NetworkDirection> dir, int id) {
        Class msgClass = MessageWrapperAPI.getClass(dir);
        this.getNetwork().messageBuilder(msgClass, id).encoder(MessageWrapperAPI.encoder()).decoder(MessageWrapperAPI.decoder(dir)).consumer(MessageWrapperAPI.handler(dir, Supplier::get, NetworkEvent.Context::getSender)).add();
    }

    @Override
    public <P, M extends MessageWrapperAPI<?, ?>> void sendToPlayer(M message, P player) {
        this.getNetwork().send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), message);
    }

    @Override
    public <M extends MessageWrapperAPI<?, ?>> void sendToServer(M message) {
        this.getNetwork().sendToServer(message);
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessage(NetworkDirection dir, MessageAPI<CTX> message) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        wrapper.setMessage(dir, message);
        return wrapper;
    }

    @Override
    @SafeVarargs
    public final <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, MessageAPI<CTX> ... messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }

    @Override
    public <CTX> MessageWrapperAPI<?, CTX> wrapMessages(NetworkDirection dir, Collection<MessageAPI<CTX>> messages) {
        MessageWrapperAPI wrapper = MessageWrapperAPI.getInstance(dir);
        wrapper.setMessages(dir, messages);
        return wrapper;
    }
}

