/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.burningwave.core.assembler.StaticComponentContainer;

public class TILBetterModScan
extends ModFileScanData {
    private static final String MODLOADER = "net.minecraftforge.fml.ModLoader";
    private static final Set<String> NUKED_PACKAGES = new HashSet<String>();
    private static final Map<String, IModFile> MOD_FILES = new HashMap<String, IModFile>();
    private static final Map<String, MultiVersionModInfo> MOD_INFOS = new HashMap<String, MultiVersionModInfo>();
    private static final Map<String, byte[]> WRITTEN_CLASSES = new HashMap<String, byte[]>();
    private static final Set<Path> PATHS = new HashSet<Path>();

    public void addFilePath(Path path) {
        PATHS.add(path);
        TILRef.logInfo("Adding file path to scan (total paths = {})", PATHS);
    }

    public void addWrittenClass(String className, MultiVersionModInfo info, IModFile file, byte[] bytecode) {
        MOD_INFOS.put(className, info);
        WRITTEN_CLASSES.put(className, bytecode);
        MOD_FILES.put(className.substring(0, className.lastIndexOf(46)), file);
    }

    @IndirectCallers
    public void defineClasses(ClassLoader target) {
        if (MOD_INFOS.isEmpty() || WRITTEN_CLASSES.isEmpty()) {
            TILRef.logInfo("No classes left to define for TILBetterModScan", new Object[0]);
            return;
        }
        for (String className : MOD_INFOS.keySet()) {
            TILRef.logInfo(className, new Object[0]);
        }
        boolean java8 = ForgeCoreLoader.isJava8();
        HashSet<String> pkgs = new HashSet<String>();
        ArrayList defined = new ArrayList();
        HashSet outerClasses = new HashSet();
        HashMap<String, IModInfo> pkgToModMap = new HashMap<String, IModInfo>();
        for (Map.Entry<String, byte[]> entry : WRITTEN_CLASSES.entrySet()) {
            String className = entry.getKey();
            byte[] bytes = entry.getValue();
            try {
                Class<?> clazz = ClassHelper.resolveClass(target, ClassHelper.defineClass(target, className, bytes));
                if (Objects.nonNull(clazz)) {
                    defined.add(clazz);
                    String string = className.substring(0, className.lastIndexOf(46));
                    if (!className.contains("$") && !pkgs.contains(string)) {
                        outerClasses.add(clazz);
                    }
                    pkgs.add(string);
                    pkgToModMap.putIfAbsent(string, this.getModFromFile(MOD_FILES.get(string), MOD_INFOS.get(className).getModID()));
                    continue;
                }
                TILRef.logError("Class was defined as null?? {}", className);
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to define class " + className, t);
            }
        }
        CoreAPI.GameVersion version = CoreAPI.getInstance().getVersion();
        boolean newFormat = version == CoreAPI.GameVersion.V20_4 || version == CoreAPI.GameVersion.V20_6 || version == CoreAPI.GameVersion.V21_1;
        WRITTEN_CLASSES.clear();
        if (pkgs.isEmpty()) {
            TILRef.logWarn("No classes were defined so no sources will be added", new Object[0]);
            return;
        }
        if (newFormat) {
            this.fixBrokenModsNew(ClassHelper.findClass(MODLOADER, target));
        }
        if (java8) {
            try {
                this.fixBrokenMods(ClassHelper.findClass(MODLOADER, target));
                ForgeCoreLoader.nukeAndFinalizeJava8(this.sourceStack(outerClasses), target, NUKED_PACKAGES.isEmpty());
            }
            catch (Throwable t) {
                TILRef.logError("Failed to finalize packages for Java 8 {}", pkgs, t);
            }
        } else {
            String doLast = this.getLastPkg(pkgs);
            try {
                HashSet<String> finalizedPkgs = new HashSet<String>();
                for (String string : pkgs) {
                    this.handleNotJava8(string, (IModInfo)pkgToModMap.get(string), finalizedPkgs);
                }
                this.handleNotJava8(doLast, (IModInfo)pkgToModMap.get(doLast), finalizedPkgs);
                for (Class clazz : defined) {
                    ForgeCoreLoader.sanityCheckModule(clazz, MOD_INFOS.get(clazz.getName()).getModID());
                }
                ForgeCoreLoader.exportAllModules();
            }
            catch (Throwable t) {
                TILRef.logError("Failed to finalize packages for Java 9+ {}", pkgs, t);
            }
        }
        NUKED_PACKAGES.addAll(pkgs);
    }

    public void fixBrokenMods(Class<?> loaderClass) {
        List warnings = (List)StaticComponentContainer.Fields.get(StaticComponentContainer.Methods.invokeStatic(loaderClass, "get", new Object[0]), "loadingWarnings");
        if (Objects.isNull(warnings)) {
            TILRef.logWarn("You win this round, Forge", new Object[0]);
        } else {
            warnings.removeIf(warning -> {
                String[] split = ((String)StaticComponentContainer.Methods.invoke(warning, "formatToString", new Object[0])).split(" ");
                if (split.length > 1) {
                    for (Path path : PATHS) {
                        if (!path.toString().endsWith(split[1])) continue;
                        TILRef.logWarn("{} is a perfectly valid mod file thanks", path);
                        return true;
                    }
                }
                return false;
            });
        }
    }

    public void fixBrokenModsNew(Class<?> loaderClass) {
        List exceptions = (List)StaticComponentContainer.Fields.get(StaticComponentContainer.Methods.invokeStatic(loaderClass, "get", new Object[0]), "loadingExceptions");
        if (Objects.isNull(exceptions)) {
            TILRef.logWarn("You win this round, Forge", new Object[0]);
        } else {
            TILRef.logWarn("Alright Forge, lets see about those \"invalid\" mod files", new Object[0]);
            exceptions.removeIf(warning -> {
                String[] split = ((String)StaticComponentContainer.Methods.invoke(warning, "formatToString", new Object[0])).split(" ");
                if (split.length > 1) {
                    for (Path path : PATHS) {
                        if (!path.toString().endsWith(split[1])) continue;
                        TILRef.logWarn("{} is a perfectly valid mod file thanks", path);
                        return true;
                    }
                }
                return false;
            });
        }
    }

    protected String getLastPkg(Collection<String> pkgs) {
        String last = null;
        for (String pkg : pkgs) {
            if (!pkg.contains("mods.thecomputerizer.theimpossiblelibrary")) continue;
            last = pkg;
            break;
        }
        if (Objects.nonNull(last)) {
            pkgs.remove(last);
        }
        return last;
    }

    protected IModInfo getModFromFile(IModFile file, String modid) {
        for (IModInfo info : file.getModInfos()) {
            if (!modid.equals(info.getModId())) continue;
            return info;
        }
        return null;
    }

    private void handleNotJava8(String pkg, IModInfo mod, Set<String> finalizedPkgs) {
        if (NUKED_PACKAGES.contains(pkg)) {
            TILRef.logInfo("Skipping already handled sources for {}", pkg);
            return;
        }
        ForgeCoreLoader.nukeAndFinalize(mod, pkg, finalizedPkgs, this.isNewFormat());
    }

    private boolean isNewFormat() {
        switch (CoreAPI.getInstance().getVersion()) {
            case V20_4: 
            case V20_6: 
            case V21_1: {
                return true;
            }
        }
        return false;
    }

    protected Set<Class<?>> sourceStack(Collection<Class<?>> generated) {
        HashSet sourcesFrom = new HashSet(generated);
        for (MultiVersionModInfo info : MOD_INFOS.values()) {
            sourcesFrom.add(info.getEntryClass());
        }
        return sourcesFrom;
    }
}

