/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.forge.core.loader;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionLoaderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModCandidate;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModData;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModFinder;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.ForgeCoreLoader;
import mods.thecomputerizer.theimpossiblelibrary.forge.core.loader.TILBetterModScan;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.ModFileFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ForgeModLoading {
    static final Logger LOGGER = LogManager.getLogger((String)"Forge Mod Loading");
    static final BiConsumer<TILBetterModScan, Object> AFTER_WRITING_MODS = (scan, language) -> {
        LOGGER.debug("Injecting scan data into the language loader");
        Consumer visitor = (Consumer)StaticComponentContainer.Methods.invokeDirect(language, "getFileVisitor", new Object[0]);
        visitor.accept(scan);
    };
    static final Map<MultiVersionModCandidate, ModFile> CANDIDATE_MAP = new HashMap<MultiVersionModCandidate, ModFile>();
    static final Map<Object, Map<MultiVersionModInfo, MultiVersionModData>> FILE_INFO_MAP = new HashMap<Object, Map<MultiVersionModInfo, MultiVersionModData>>();
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final String MOD_CLASS_VISITOR = "net.minecraftforge.fml.loading.moddiscovery.ModClassVisitor";
    static final String NIGHT_CONFIG_WRAPPER = "net.minecraftforge.fml.loading.moddiscovery.NightConfigWrapper";
    static final String SCANNER = "net.minecraftforge.fml.loading.moddiscovery.Scanner";
    static final String SELF_ENTRYPOINT = "mods.thecomputerizer.theimpossiblelibrary.api.common.TILCommonEntryPoint";
    static Function<ModFile, IModFileInfo> langProviderFileInfo;
    static BiFunction<URL, String, Path> urlToPath;
    static BiFunction<Path, Object, Manifest> pathToManifest;
    static String coreModEngineClass;
    static String[] coreModExtensions;
    static BiFunction<ModFile, Collection<?>, ModFileInfo> modFileInfoCreator;
    static Class<?> dynamicModFileClass;
    static boolean fixedCoreMods;
    static boolean pathBased;
    static boolean locatorBased;
    static String workingVersion;

    private static <F> void addScannedMod(Object file, List<F> mods, String type) {
        if (locatorBased) {
            StaticComponentContainer.Fields.setDirect(file, "modFileType", (Object)ForgeModLoading.getModFileType(type));
            mods.add(file);
        } else {
            String fileClassName = "net.minecraftforge.forgespi.locating.IModLocator$ModFileOrException";
            Class<?> fileClass = ClassHelper.findClass("net.minecraftforge.forgespi.locating.IModLocator$ModFileOrException");
            mods.add(StaticComponentContainer.Constructors.newInstanceOf(fileClass, file, null));
        }
    }

    static void checkPath(MultiVersionLoaderAPI loader, Path path, Predicate<Path> filter) {
        String loaderName = loader.getName();
        if (Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        String fileName = path.getFileName().toString();
        LOGGER.debug("[{}]: Checking if file {} is the loader", (Object)loaderName, (Object)fileName);
        if (Objects.isNull(MultiVersionModCandidate.loaderFile) && TILDev.isLoader(fileName)) {
            LOGGER.debug("[{}]: File is the loader", (Object)loaderName);
            MultiVersionModCandidate.loaderFile = path.toFile();
        }
        if (filter.test(path)) {
            LOGGER.info("[{}]: Found mod candidate at {}", (Object)loaderName, (Object)path);
            loader.addPotentialModPath(path);
        }
    }

    static void checkURL(MultiVersionLoaderAPI loader, URL url, Predicate<Path> filter) {
        LOGGER.debug("[{}]: Checking URL {} for MANIFEST {}", (Object)loader.getName(), (Object)url, (Object)MANIFEST);
        ForgeModLoading.checkPath(loader, urlToPath.apply(url, MANIFEST), filter);
    }

    static ModFile createModFile(Path path, Object locator, ModFileFactory.ModFileInfoParser parser, String type) {
        if (Objects.isNull(dynamicModFileClass)) {
            LOGGER.error("Cannot create ModFile with null dynamicModFileClass! Did it fail to initialize?");
            return null;
        }
        Path pathOrJar = path;
        if (!pathBased) {
            Class<?> jarClass = ClassHelper.findClass("cpw.mods.jarhandling.SecureJar");
            pathOrJar = StaticComponentContainer.Methods.invokeStatic(jarClass, "from", path);
        }
        return (ModFile)StaticComponentContainer.Constructors.newInstanceOf(dynamicModFileClass, pathOrJar, locator, parser, type);
    }

    @Nullable
    static Class<?> dynamicModFileCreator() {
        ClassHelper.checkBurningWaveInit();
        String pkgName = ForgeModLoading.class.getPackage().getName();
        String className = pkgName + ".TILForgeModFile";
        byte[] byteCode = ForgeModLoading.generateModFileExtension(className);
        if (Objects.isNull(byteCode)) {
            LOGGER.error("Failed to define bytecode for {}", (Object)className);
            return null;
        }
        ASMHelper.writeDebugByteCode(className, byteCode);
        LOGGER.info("Successfully generated bytecode for {}", (Object)className);
        try {
            Class<?> defined = ClassHelper.defineAndResolveClass(ModFile.class.getClassLoader(), className, byteCode);
            LOGGER.info("Successfully generated ModFile extension {}", defined);
            if (!ForgeCoreLoader.isJava8()) {
                Object module = StaticComponentContainer.Methods.invoke(ForgeModLoading.class, "getModule", new Object[0]);
                StaticComponentContainer.Fields.setDirect(defined, "module", module);
            }
            return defined;
        }
        catch (Throwable t) {
            LOGGER.error("Failed to generate ModFile extension {}", (Object)className, (Object)t);
            return null;
        }
    }

    static void findFiles(MultiVersionLoaderAPI loader, Predicate<Path> filter, File ... files) {
        LOGGER.info("[{}]: Loading {} mod files", (Object)loader.getName(), (Object)files.length);
        for (File mod : files) {
            LOGGER.debug("[{}]: Potentially loading mod file at path {}", (Object)loader.getName(), (Object)mod.toPath());
            ForgeModLoading.checkPath(loader, mod.toPath(), filter);
        }
    }

    public static void findPaths(ClassLoader classLoader, MultiVersionLoaderAPI loader, Object locator) {
        Predicate<Path> filter = path -> {
            if (Objects.isNull(path)) {
                return false;
            }
            Manifest manifest = pathToManifest.apply((Path)path, locator);
            if (Objects.isNull(manifest)) {
                return false;
            }
            return MultiVersionModFinder.hasMods(manifest.getMainAttributes());
        };
        ForgeModLoading.findURLs(loader, classLoader, filter);
        ForgeModLoading.findFiles(loader, filter, FileHelper.list(loader.findModRoot(), File::isFile));
    }

    static void findURLs(MultiVersionLoaderAPI loader, ClassLoader classLoader, Predicate<Path> filter) {
        try {
            Enumeration<URL> manifests = ClassLoader.getSystemClassLoader().getResources(MANIFEST);
            while (manifests.hasMoreElements()) {
                ForgeModLoading.checkURL(loader, manifests.nextElement(), filter);
            }
        }
        catch (IOException ex) {
            LOGGER.error("[{}]: Failed to calculate URLs for paths with {} using {}", (Object)loader.getName(), (Object)MANIFEST, (Object)classLoader, (Object)ex);
        }
    }

    public static void fixCoreModPackages() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> engineClass = ClassHelper.findClass(coreModEngineClass, loader);
        HashSet<String> allowed = new HashSet<String>((Collection)StaticComponentContainer.Fields.getStatic(engineClass, "ALLOWED_PACKAGES"));
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.api.core");
        allowed.add("mods.thecomputerizer.theimpossiblelibrary.forge.core");
        for (String extension : coreModExtensions) {
            allowed.add("mods.thecomputerizer.theimpossiblelibrary.forge." + extension + ".core");
        }
        LOGGER.debug("Expanded coremod package whitelist to {}", allowed);
        StaticComponentContainer.Fields.setStaticDirect(engineClass, "ALLOWED_PACKAGES", allowed);
    }

    private static byte[] generateModFileExtension(String className) {
        Class pathOrJarClass = pathBased ? Path.class : ClassHelper.findClass("cpw.mods.jarhandling.SecureJar");
        Class locatorClass = locatorBased ? IModLocator.class : ClassHelper.findClass("net.minecraftforge.forgespi.locating.IModProvider");
        ClassWriter writer = ASMHelper.getWriter(52, 1, TypeHelper.fromBinary(className), TypeHelper.get(ModFile.class));
        if (Objects.isNull(pathOrJarClass) || Objects.isNull(locatorClass)) {
            LOGGER.error("Cannot add dynamic ModFile creator! Found null parameter class {} or {}", pathOrJarClass, locatorClass);
            return null;
        }
        String constructorDesc = TypeHelper.voidMethodDesc(pathOrJarClass, locatorClass, ModFileFactory.ModFileInfoParser.class, String.class);
        String superDesc = pathBased ? TypeHelper.voidMethodDesc(pathOrJarClass, locatorClass, ModFileFactory.ModFileInfoParser.class) : constructorDesc;
        String modFile = TypeHelper.get(ModFile.class).getInternalName();
        String modLoading = TypeHelper.get(ForgeModLoading.class).getInternalName();
        String writeModsDesc = TypeHelper.methodDesc(ModFileScanData.class, ModFile.class);
        String identifyModsDesc = TypeHelper.methodDesc(Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, ASMRef.OBJECT_TYPE);
        MethodVisitor constructor = writer.visitMethod(1, "<init>", constructorDesc, null, null);
        constructor.visitCode();
        for (int i = 0; i < (pathBased ? 4 : 5); ++i) {
            constructor.visitVarInsn(25, i);
        }
        constructor.visitMethodInsn(183, modFile, "<init>", superDesc, false);
        constructor.visitInsn(177);
        ASMHelper.finishMethod(constructor);
        MethodVisitor compileContent = writer.visitMethod(1, "compileContent", TypeHelper.methodDesc(ModFileScanData.class), null, null);
        compileContent.visitCode();
        compileContent.visitVarInsn(25, 0);
        compileContent.visitMethodInsn(184, modLoading, "writeMods", writeModsDesc, false);
        compileContent.visitInsn(176);
        ASMHelper.finishMethod(compileContent);
        MethodVisitor identifyMods = writer.visitMethod(1, "identifyMods", "()Z", null, null);
        identifyMods.visitCode();
        identifyMods.visitVarInsn(25, 0);
        identifyMods.visitMethodInsn(183, modFile, "identifyMods", "()Z", false);
        identifyMods.visitVarInsn(25, 0);
        identifyMods.visitMethodInsn(184, modLoading, "identifyMods", identifyModsDesc, false);
        identifyMods.visitInsn(172);
        ASMHelper.finishMethod(identifyMods);
        if (!pathBased) {
            int i;
            String findResourceDesc = TypeHelper.methodDesc(Path.class, String[].class);
            String queryCoreModsDesc = TypeHelper.voidMethodDesc(String[].class);
            MethodVisitor findResource = writer.visitMethod(1, "findResource", findResourceDesc, null, null);
            findResource.visitCode();
            for (i = 0; i < 2; ++i) {
                findResource.visitVarInsn(25, i);
            }
            findResource.visitMethodInsn(184, modLoading, "queryCoreMods", queryCoreModsDesc, false);
            for (i = 0; i < 2; ++i) {
                findResource.visitVarInsn(25, i);
            }
            findResource.visitMethodInsn(183, modFile, "findResource", findResourceDesc, false);
            findResource.visitInsn(176);
            ASMHelper.finishMethod(findResource);
        }
        return writer.toByteArray();
    }

    private static Object getCoreMods(Object file) {
        return StaticComponentContainer.Methods.invoke(file, "getCoreMods", new Object[0]);
    }

    public static IModFileInfo getFileInfo(IModFile file, Collection<?> infos) {
        if (file instanceof ModFile) {
            return (IModFileInfo)modFileInfoCreator.apply((ModFile)file, infos);
        }
        LOGGER.error("Cannot get IModFileInfo for IModFile that is not an instance of ModFile! {}", (Object)file);
        return null;
    }

    public static IModFile.Type getModFileType(String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            LOGGER.error("Null or empty mod file type! LIBRARY will be assumed");
            return IModFile.Type.LIBRARY;
        }
        switch (name) {
            case "GAMELIBRARY": {
                LOGGER.warn("The GAMELIBRARY mod file type is unable to be supported in all Forge versions! Please use LANGPROVIDER, LIBRARY, or MOD");
                LOGGER.warn("MOD will be assumed for now, but things could break soon");
                return IModFile.Type.MOD;
            }
            case "LANGPROVIDER": {
                return IModFile.Type.LANGPROVIDER;
            }
            case "LIBRARY": {
                return IModFile.Type.LIBRARY;
            }
            case "MOD": {
                return IModFile.Type.MOD;
            }
        }
        LOGGER.error("Unknown mod file type {}! LIBRARY will be assumed", (Object)name);
        return IModFile.Type.LIBRARY;
    }

    private static boolean hasCoreModPath(String ... paths) {
        for (String path : paths) {
            if (!path.contains("coremods.json")) continue;
            return true;
        }
        return false;
    }

    @IndirectCallers
    public static boolean identifyMods(boolean result, Object file) {
        LOGGER.debug("Identifying mods");
        if (result) {
            ForgeModLoading.queryCoreMods(file);
        }
        LOGGER.debug("Finished identifying mods");
        return result;
    }

    private static Config initConfigDependencies() {
        Config dependency = Config.inMemory();
        dependency.set("mandatory", (Object)true);
        dependency.set("modId", (Object)"theimpossiblelibrary");
        dependency.set("ordering", (Object)"AFTER");
        dependency.set("side", (Object)"BOTH");
        dependency.set("versionRange", (Object)"[0.4.0,)");
        return dependency;
    }

    private static List<Config> initConfigMods(Config config, Collection<?> infos) {
        ArrayList<Config> mods = new ArrayList<Config>();
        boolean setLicense = false;
        for (Object info : infos) {
            if (!setLicense) {
                config.set("license", StaticComponentContainer.Methods.invoke(info, "getLicense", new Object[0]));
                setLicense = true;
            }
            Config mod = Config.inMemory();
            mod.set("description", StaticComponentContainer.Methods.invoke(info, "getDescription", new Object[0]));
            mod.set("displayName", StaticComponentContainer.Methods.invoke(info, "getName", new Object[0]));
            mod.set("license", StaticComponentContainer.Methods.invoke(info, "getLicense", new Object[0]));
            mod.set("logoFile", (Object)"logo.png");
            mod.set("modId", StaticComponentContainer.Methods.invoke(info, "getModID", new Object[0]));
            mod.set("version", StaticComponentContainer.Methods.invoke(info, "getVersion", new Object[0]));
            mods.add(mod);
        }
        if (!setLicense) {
            config.set("license", (Object)"LGPL V3");
        }
        return mods;
    }

    public static IConfigurable initFileConfig(Collection<?> infos) {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"multiversionprovider");
        config.set("loaderVersion", (Object)"[0.4.0,)");
        List<Config> mods = ForgeModLoading.initConfigMods(config, infos);
        config.add("mods", mods);
        if (!mods.isEmpty() && !"theimpossiblelibrary".equals(mods.get(0).get("modId"))) {
            config.add("dependencies", new ArrayList<Config>(Collections.singletonList(ForgeModLoading.initConfigDependencies())));
        }
        return ForgeModLoading.wrapConfig((UnmodifiableConfig)config);
    }

    private static Map<MultiVersionModInfo, MultiVersionModData> initInfoMap(Collection<?> infos) {
        HashMap<MultiVersionModInfo, MultiVersionModData> infoMap = new HashMap<MultiVersionModInfo, MultiVersionModData>();
        for (Object info : infos) {
            infoMap.put((MultiVersionModInfo)info, null);
        }
        LOGGER.info("Created <info,data> map with {} entries for multiversion mod file ({}) using {}", (Object)infos.size(), (Object)workingVersion, infos);
        return infoMap;
    }

    public static void initModLoading(ClassLoader loader, Object locator) {
        CoreAPI core = CoreAPI.getInstance(loader);
        if (Objects.isNull(core)) {
            throw new RuntimeException("Failed to initialize Forge mod loading! Cannot find CoreAPI on " + loader);
        }
        ClassHelper.checkBurningWaveInit();
        ForgeModLoading.findPaths(loader, (MultiVersionLoaderAPI)CoreAPI.invoke(core, "getLoader"), locator);
        ForgeModLoading.loadMods(loader, locator, core);
    }

    @Nullable
    private static TILBetterModScan initModScanner(ModFile file) {
        LOGGER.info("Starting multiversion mod scan");
        TILBetterModScan scan = new TILBetterModScan();
        scan.addModFileInfo(file.getModFileInfo());
        Class<?> cScanner = ClassHelper.findClass(SCANNER);
        file.scanFile(p -> ForgeModLoading.scanReflectively(StaticComponentContainer.Constructors.newInstanceOf(cScanner, file), p, scan));
        LOGGER.debug("Injecting @Mod annotations from multiversion mod info");
        if (Objects.nonNull(scan.getAnnotations())) {
            return scan;
        }
        LOGGER.error("@Mod scan annotation set for multiversion mod is null???");
        return null;
    }

    private static IModFileInfo langFileInfo(IModFile file) {
        if (!(file instanceof ModFile)) {
            LOGGER.error("IModFile instance must extend ModFile to be supported for IModFileInfo construction!");
            return null;
        }
        return langProviderFileInfo.apply((ModFile)file);
    }

    private static Config langProviderConfig() {
        Config config = Config.inMemory();
        config.set("modLoader", (Object)"minecraft");
        config.set("loaderVersion", (Object)"1");
        Config mod = Config.inMemory();
        mod.set("modId", (Object)"multiversionprovider");
        mod.set("version", (Object)"0.4.5");
        mod.set("displayName", (Object)"Multiversion Language Provider");
        mod.set("logoFile", (Object)"logo.png");
        mod.set("authors", (Object)"The_Computerizer");
        mod.set("description", (Object)"Multiversion language loader for The Impossible Library");
        config.set("mods", new ArrayList<Config>(Collections.singletonList(mod)));
        return config;
    }

    public static ModFile langProviderModFile(ModFile reference) {
        Object locator = StaticComponentContainer.Methods.invoke((Object)reference, locatorBased ? "getLocator" : "getProvider", new Object[0]);
        ModFileFactory.ModFileInfoParser parser = ForgeModLoading::langFileInfo;
        return ForgeModLoading.createModFile(reference.getFilePath(), locator, parser, "LANGPROVIDER");
    }

    private static void loadCandidateInfos(Object locator, Map<?, ?> infoMap) {
        for (Map.Entry<?, ?> entry : infoMap.entrySet()) {
            MultiVersionModCandidate candidate = (MultiVersionModCandidate)entry.getKey();
            Collection infos = (Collection)entry.getValue();
            ModFileFactory.ModFileInfoParser parser = file -> ForgeModLoading.getFileInfo(file, infos);
            ModFile file2 = ForgeModLoading.createModFile(candidate.getFile().toPath(), locator, parser, "MOD");
            CANDIDATE_MAP.put(candidate, file2);
            FILE_INFO_MAP.put(file2, ForgeModLoading.initInfoMap(infos));
        }
    }

    private static void loadMods(ClassLoader loader, Object locator, Object core) {
        Class[] withLoader = new Class[]{ClassLoader.class};
        CoreAPI.invoke(core, "loadCoreModInfo", withLoader, loader);
        CoreAPI.invoke(core, "instantiateCoreMods");
        CoreAPI.invoke(core, "writeModContainers", withLoader, loader);
        Object infoMap = CoreAPI.invoke(core, "getModInfo");
        ForgeModLoading.loadCandidateInfos(locator, (Map)infoMap);
    }

    private static TILBetterModScan onFinishedWritingMods(TILBetterModScan scan, IModFile file) {
        Object loader = StaticComponentContainer.Methods.invokeDirect(file, pathBased ? "getLoader" : "getLoaders", new Object[0]);
        if (Objects.isNull(loader)) {
            LOGGER.error("Why are there no language loaders??");
        } else if (loader instanceof Collection) {
            Collection loaders = (Collection)loader;
            if (loaders.isEmpty()) {
                LOGGER.error("Why are there no language loaders??");
            } else {
                for (Object l : loaders) {
                    AFTER_WRITING_MODS.accept(scan, l);
                }
            }
        } else {
            AFTER_WRITING_MODS.accept(scan, loader);
        }
        LOGGER.debug("Finishing multiversion mod scan");
        scan.addFilePath(file.getFilePath());
        return scan;
    }

    public static void populateMultiversionData(Map<MultiVersionModInfo, MultiVersionModData> infoMap, Object dataMap) {
        for (MultiVersionModData data : ((Map)dataMap).values()) {
            MultiVersionModInfo info = data.getInfo();
            if (!infoMap.containsKey(info)) continue;
            LOGGER.debug("Populated data for {}", (Object)info);
            infoMap.put(info, data);
        }
    }

    public static void queryCoreMods(String ... resourcePaths) {
        if (!fixedCoreMods && ForgeModLoading.hasCoreModPath(resourcePaths)) {
            ForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static void queryCoreMods(Object file) {
        if (fixedCoreMods) {
            return;
        }
        Object coremods = ForgeModLoading.getCoreMods(file);
        if (coremods instanceof Collection && !((Collection)coremods).isEmpty()) {
            ForgeModLoading.fixCoreModPackages();
            fixedCoreMods = true;
        }
    }

    public static <F> List<F> scanMods() {
        ClassLoader context = Thread.currentThread().getContextClassLoader();
        LOGGER.debug("Scanning for mods in multiversion jars (context = {})", (Object)context);
        ArrayList mods = new ArrayList();
        LOGGER.debug("Getting CoreAPI instance");
        CoreAPI instance = CoreAPI.getInstance();
        if (Objects.isNull(instance)) {
            LOGGER.error("Failed to get CoreAPI instance :(");
        }
        Object data = CoreAPI.invoke(instance, "getModData", new Class[]{File.class}, new File("."));
        for (Map.Entry<MultiVersionModCandidate, ModFile> candidateEntry : CANDIDATE_MAP.entrySet()) {
            ModFile candidateFile = candidateEntry.getValue();
            Map<MultiVersionModInfo, MultiVersionModData> map = FILE_INFO_MAP.get(candidateFile);
            if (Objects.isNull(map)) {
                LOGGER.error("Cannot populate multiversion data with null info map! Was the getter set up correctly?");
                continue;
            }
            ForgeModLoading.populateMultiversionData(map, data);
            if (candidateEntry.getKey().getModClassNames().contains(SELF_ENTRYPOINT)) {
                LOGGER.info("Adding scanned lang provider mod {}", (Object)candidateFile);
                ForgeModLoading.addScannedMod(ForgeModLoading.langProviderModFile(candidateFile), mods, "LANGPROVIDER");
            }
            LOGGER.info("Adding scanned mod {}", (Object)candidateFile);
            ForgeModLoading.addScannedMod(candidateFile, mods, "MOD");
        }
        return Collections.unmodifiableList(mods);
    }

    private static void scanReflectively(Object scanner, Path path, ModFileScanData scan) {
        LOGGER.trace("Attempting to scan multiversion jar path {}", (Object)path);
        try {
            StaticComponentContainer.Methods.invokeDirect(scanner, "fileVisitor", path, scan);
        }
        catch (Throwable ex) {
            LOGGER.error("Failed to scan {}!", (Object)path, (Object)ex);
        }
    }

    private static String[] setCoreModExtensions(String version) {
        switch (version) {
            case "16": 
            case "16_5": {
                return new String[]{"v16.m5"};
            }
            case "18": 
            case "18_2": {
                return new String[]{"v18.m2"};
            }
            case "19": 
            case "19_2": {
                return new String[]{"v19", "v19.m2"};
            }
            case "19_4": {
                return new String[]{"v19", "v19.m4"};
            }
            case "20": 
            case "20_1": {
                return new String[]{"v20", "v20.m1"};
            }
            case "20_4": {
                return new String[]{"v20", "v20.m4"};
            }
            case "20_6": {
                return new String[]{"v20", "v20.m6"};
            }
            case "21": 
            case "21_1": {
                return new String[]{"v21", "v21.m1"};
            }
        }
        return new String[0];
    }

    public static void setFileVersion(Class<?> caller, String version, String actualVersion) {
        workingVersion = version;
        pathBased = Misc.equalsAny(version, "16", "16_5");
        locatorBased = pathBased || Misc.equalsAny(version, "18", "18_2");
        modFileInfoCreator = ForgeModLoading.setModFileInfoCreator(version);
        dynamicModFileClass = ForgeModLoading.dynamicModFileCreator();
        langProviderFileInfo = ForgeModLoading.setLangProviderFileInfo(version);
        coreModEngineClass = "net.minecraftforge.coremod.CoreModEngine";
        coreModExtensions = ForgeModLoading.setCoreModExtensions(version);
        Class<?> lClass = ClassHelper.findClass("net.minecraftforge.fml.loading." + (pathBased ? "LibraryFinder" : "ClasspathLocatorUtils"));
        String arg2 = pathBased ? "manifest_jar" : MANIFEST;
        urlToPath = (url, manifest) -> (Path)StaticComponentContainer.Methods.invokeStatic(lClass, "findJarPathFor", manifest, arg2, url);
        pathToManifest = ForgeModLoading.setPathToManifest();
        LOGGER.info("{} Forge Locator plugin loaded on {}", (Object)actualVersion, (Object)caller.getClassLoader());
    }

    private static Function<ModFile, IModFileInfo> setLangProviderFileInfo(String version) {
        switch (version) {
            case "16": 
            case "16_5": {
                return file -> (IModFileInfo)StaticComponentContainer.Constructors.newInstanceOf(ModFileInfo.class, file, ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig()));
            }
            case "18": 
            case "18_2": 
            case "19": 
            case "19_2": 
            case "19_4": {
                return file -> (IModFileInfo)StaticComponentContainer.Constructors.newInstanceOf(ModFileInfo.class, file, ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig()), Collections.emptyList());
            }
            case "20": 
            case "20_1": 
            case "20_4": 
            case "20_6": 
            case "21": 
            case "21_1": {
                return file -> {
                    IConfigurable configWrapper = ForgeModLoading.wrapConfig((UnmodifiableConfig)ForgeModLoading.langProviderConfig());
                    Consumer<IModFileInfo> consumer = info -> StaticComponentContainer.Methods.invokeDirect(configWrapper, "setFile", info);
                    List languageSpecs = Collections.emptyList();
                    return (IModFileInfo)StaticComponentContainer.Constructors.newInstanceOf(ModFileInfo.class, file, configWrapper, consumer, languageSpecs);
                };
            }
        }
        return file -> {
            LOGGER.error("Unknown version for creating a ModFileInfo instance {}", (Object)version);
            return null;
        };
    }

    static BiFunction<ModFile, Collection<?>, ModFileInfo> setModFileInfoCreator(String version) {
        switch (version) {
            case "16": 
            case "16_5": 
            case "18": 
            case "18_2": 
            case "19": 
            case "19_2": 
            case "19_4": {
                return (file, infos) -> (ModFileInfo)StaticComponentContainer.Constructors.newInstanceOf(ModFileInfo.class, file, ForgeModLoading.initFileConfig(infos));
            }
            case "20": 
            case "20_1": 
            case "20_4": 
            case "20_6": 
            case "21": 
            case "21_1": {
                return (file, infos) -> {
                    IConfigurable configWrapper = ForgeModLoading.initFileConfig(infos);
                    Consumer<IModFileInfo> configConsumer = info -> StaticComponentContainer.Methods.invoke((Object)configWrapper, "setFile", info);
                    return (ModFileInfo)StaticComponentContainer.Constructors.newInstanceOf(ModFileInfo.class, file, configWrapper, configConsumer);
                };
            }
        }
        LOGGER.error("Cannot set ModFileInfo creator function for unknown version {}", (Object)version);
        return (file, infos) -> null;
    }

    private static BiFunction<Path, Object, Manifest> setPathToManifest() {
        if (pathBased) {
            return (path, locator) -> {
                try {
                    Optional optional = (Optional)StaticComponentContainer.Methods.invoke(locator, "findManifest", path);
                    return optional.orElse(null);
                }
                catch (Throwable ignoredT) {
                    LOGGER.warn("Failed to get manifest from path {}", path);
                    return null;
                }
            };
        }
        Class<?> jarClass = ClassHelper.findClass("cpw.mods.jarhandling.SecureJar");
        if (locatorBased) {
            return (path, ignored) -> {
                try {
                    Object jar = StaticComponentContainer.Methods.invokeStatic(jarClass, "from", path);
                    return (Manifest)StaticComponentContainer.Methods.invoke(jar, "getManifest", new Object[0]);
                }
                catch (Throwable ignoredT) {
                    LOGGER.warn("Failed to get manifest from path {}", path);
                    return null;
                }
            };
        }
        return (path, ignored) -> {
            try {
                Object jar = StaticComponentContainer.Methods.invokeStatic(jarClass, "from", path);
                Object dataProvider = StaticComponentContainer.Methods.invoke(jar, "moduleDataProvider", new Object[0]);
                return Objects.nonNull(dataProvider) ? (Manifest)StaticComponentContainer.Methods.invoke(dataProvider, "getManifest", new Object[0]) : null;
            }
            catch (Throwable ignoredT) {
                LOGGER.warn("Failed to get manifest from path {}", path);
                return null;
            }
        };
    }

    @IndirectCallers
    public static Object stupidCast(Object o) {
        LOGGER.info("Stupidly casting {}", o);
        return o;
    }

    private static IConfigurable wrapConfig(UnmodifiableConfig config) {
        Class<?> wrapperClass = ClassHelper.findClass(NIGHT_CONFIG_WRAPPER);
        return (IConfigurable)StaticComponentContainer.Constructors.newInstanceOf(wrapperClass, config);
    }

    private static void writeClassBytes(IModFile file, TILBetterModScan scan, Class<?> visitorClass, MultiVersionModData data, String className, byte[] bytes) {
        scan.addWrittenClass(className, data.getInfo(), file, bytes);
        ClassVisitor visitor = (ClassVisitor)StaticComponentContainer.Constructors.newInstanceOf(visitorClass, new Object[0]);
        ClassReader reader = new ClassReader(bytes);
        reader.accept(visitor, 0);
        StaticComponentContainer.Methods.invokeDirect(visitor, "buildData", scan.getClasses(), scan.getAnnotations());
    }

    private static void writeEntry(IModFile file, TILBetterModScan scan, Class<?> visitorClass, Map.Entry<MultiVersionModInfo, MultiVersionModData> entry) {
        MultiVersionModInfo info = entry.getKey();
        String modid = info.getModID();
        MultiVersionModData data = entry.getValue();
        if (Objects.isNull(data)) {
            LOGGER.warn("Skipping mod injection for {} since no data exists", (Object)modid);
            return;
        }
        for (Map.Entry<String, byte[]> classBytes : data.writeModClass()) {
            ForgeModLoading.writeClassBytes(file, scan, visitorClass, data, classBytes.getKey(), classBytes.getValue());
        }
    }

    @IndirectCallers
    public static ModFileScanData writeMods(ModFile file) {
        TILBetterModScan scan;
        Map<MultiVersionModInfo, MultiVersionModData> infoMap = FILE_INFO_MAP.get(file);
        if (Objects.isNull(infoMap) || infoMap.isEmpty()) {
            LOGGER.error("Cannot write multiversion mods for {} with null or empty info map! {}", (Object)file, infoMap);
        }
        if (Objects.isNull((Object)(scan = ForgeModLoading.initModScanner(file)))) {
            LOGGER.error("Failed to initialize TILBetterModScan!");
            return null;
        }
        Class<?> mvClass = ClassHelper.findClass(MOD_CLASS_VISITOR);
        for (Map.Entry<MultiVersionModInfo, MultiVersionModData> entry : infoMap.entrySet()) {
            ForgeModLoading.writeEntry((IModFile)file, scan, mvClass, entry);
        }
        return ForgeModLoading.onFinishedWritingMods(scan, (IModFile)file);
    }

    @Generated
    public static boolean isPathBased() {
        return pathBased;
    }

    @Generated
    public static boolean isLocatorBased() {
        return locatorBased;
    }

    @Generated
    public static String getWorkingVersion() {
        return workingVersion;
    }
}

