/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v21.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.GLAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;
import net.minecraft.class_1041;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GL1_21
implements GLAPI {
    protected float r = 1.0f;
    protected float g = 1.0f;
    protected float b = 1.0f;
    protected float a = 1.0f;
    protected class_293 workingFormat;
    protected class_287 workingBuffer;
    protected class_4587.class_4665 workingPose;
    private double scaleX = 1.0;
    private double scaleY = 1.0;

    @Override
    public void directBegin(int modeVal) {
        class_289 tesselator = RenderSystem.renderThreadTesselator();
        this.workingFormat = class_290.field_29337;
        this.workingBuffer = tesselator.method_60827(class_293.class_5596.field_27377, this.workingFormat);
        this.setWorkingColor(RenderSystem.getShaderColor());
        class_1041 window = class_310.method_1551().method_22683();
        double width = window.method_4489();
        double height = window.method_4506();
        double widthFactor = height > width ? width / height : 1.0;
        double heightFactor = width > height ? height / width : 1.0;
        this.scaleX = 1.0 + 1.0 / width * 16.0 * widthFactor;
        this.scaleY = 1.0 + 1.0 / height * 16.0 * heightFactor;
    }

    @Override
    public void directEnd() {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly end buffer before calling directBegin!", new Object[0]);
        } else {
            RenderSystem.disableCull();
            this.endWithShader(this.workingFormat);
            RenderSystem.enableCull();
            this.workingBuffer = null;
            this.r = 1.0f;
            this.g = 1.0f;
            this.b = 1.0f;
            this.a = 1.0f;
        }
    }

    @Override
    public void directVertexD(double x, double y, double z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexD(double x, double y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2D) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void directVertexF(float x, float y, float z) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (3F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, z, this.r, this.g, this.b, this.a, x, y, z);
        }
    }

    @Override
    public void directVertexF(float x, float y) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot directly add vertex (2F) to buffer before calling directBegin!", new Object[0]);
        } else {
            this.normalizedVertex(x, y, 0.0, this.r, this.g, this.b, this.a, x, y, 0.0);
        }
    }

    @Override
    public void disable(int cap) {
        GL11.glDisable((int)cap);
    }

    @Override
    public void enable(int cap) {
        GL11.glEnable((int)cap);
    }

    void endWithShader(class_293 format) {
        if (format == class_290.field_1576) {
            RenderSystem.setShader(class_757::method_34540);
        } else if (format == class_290.field_1575) {
            RenderSystem.setShader(class_757::method_34543);
        } else if (format == class_290.field_29337) {
            RenderSystem.setShader(class_757::method_34535);
        }
        class_286.method_43433((class_9801)this.workingBuffer.method_60800());
        RenderSystem.setShader(() -> null);
    }

    @Override
    public int lineStrip() {
        return 3;
    }

    @Override
    public int lines() {
        return 1;
    }

    protected class_4588 normal(class_4588 consumer, float x, float y, float z) {
        return Objects.nonNull(this.workingPose) ? consumer.method_60831(this.workingPose, x, y, z) : consumer.method_22914(x, y, z);
    }

    @Override
    public void normalizedVertex(double x, double y, double z, float r, float g, float b, float a, double nextX, double nextY, double nextZ) {
        if (Objects.isNull(this.workingBuffer)) {
            TILRef.logError("Cannot add normalized vertex to buffer before calling directBegin!", new Object[0]);
        }
        boolean same = x == nextX && y == nextY && z == nextZ;
        double nX = same ? 1.0 : (nextX *= this.scaleX) - (x *= this.scaleX);
        double nY = same ? 1.0 : (nextY *= this.scaleY) - (y *= this.scaleY);
        double nZ = same ? 1.0 : nextZ - z;
        double dist = MathHelper.distance(nX, nY, nZ);
        this.normal(this.vertex(x, y, z).method_22915(r, g, b, a), (float)(nX /= dist), (float)(nY /= dist), (float)(nZ /= dist));
        this.normal(this.vertex(nextX, nextY, nextZ).method_22915(r, g, b, a), (float)nX, (float)nY, (float)nZ);
    }

    @Override
    public int quads() {
        return 7;
    }

    @Override
    public void scissor(int left, int bottom, int width, int height) {
        GL20.glScissor((int)left, (int)bottom, (int)width, (int)height);
    }

    @Override
    public int scissorTest() {
        return 3089;
    }

    @Override
    public void setLineWidth(float width) {
        RenderSystem.lineWidth((float)width);
    }

    private void setWorkingColor(float ... workingColor) {
        this.r = workingColor[0];
        this.g = workingColor[1];
        this.b = workingColor[2];
        this.a = workingColor[3];
    }

    @Override
    public void setWorkingMatrix(Object matrix) {
        Object object = matrix;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_332.class, class_4587.class, class_4587.class_4665.class}, (Object)object, n)) {
            case 0: {
                class_332 guiGraphics = (class_332)object;
                this.workingPose = guiGraphics.method_51448().method_23760();
                break;
            }
            case 1: {
                class_4587 poseStack = (class_4587)object;
                this.workingPose = poseStack.method_23760();
                break;
            }
            case 2: {
                class_4587.class_4665 pose;
                this.workingPose = pose = (class_4587.class_4665)object;
                break;
            }
            default: {
                if (Objects.nonNull(matrix)) {
                    TILRef.logError("Tried to set working Pose for GL1_21 to a non GuiGraphics, PoseStack, or Pose {}", matrix);
                }
                this.workingPose = null;
            }
        }
    }

    @Override
    public int triangles() {
        return 4;
    }

    @Override
    public int triangleFan() {
        return 6;
    }

    protected class_4588 vertex(double x, double y, double z) {
        return Objects.nonNull(this.workingPose) ? this.workingBuffer.method_22918(this.workingPose.method_23761(), (float)x, (float)y, (float)z) : this.workingBuffer.method_22912((float)x, (float)y, (float)z);
    }
}

