/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v20.server;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import net.minecraft.class_32;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public abstract class MinecraftServer1_20
extends MinecraftServerAPI<MinecraftServer> {
    @Override
    public void registerCommand(CommandAPI cmd) {
    }

    @Override
    public void executeCommandLiteral(String command) {
        MinecraftServer server = this.getServer();
        if (Objects.nonNull(server)) {
            server.method_3734().method_44252(server.method_3739(), command);
        }
    }

    @Nullable
    protected Field getField(Object parent, String name, Class<?> descType) {
        Class parentClass = parent instanceof MinecraftServer ? MinecraftServer.class : parent.getClass();
        CoreAPI core = CoreAPI.getInstance();
        String clsName = core.mapClassName(parentClass.getName());
        name = core.mapFieldName(clsName, name, "L" + descType.getName() + ";");
        return ReflectionHelper.getField(parentClass, name);
    }

    @Override
    @Nullable
    public PlayerAPI<?, ?> getPlayerByUUID(String uuid) {
        class_3222 player = this.getServer().method_3760().method_14602(UUID.fromString(uuid));
        return Objects.nonNull(player) ? WrapperHelper.wrapPlayer(player) : null;
    }

    @Override
    public List<PlayerAPI<?, ?>> getPlayers() {
        ArrayList players = new ArrayList();
        for (Object player : this.getServer().method_3760().method_14571()) {
            players.add(WrapperHelper.wrapPlayer(player));
        }
        return players;
    }

    @Override
    @Nullable
    public File getSaveDir() {
        MinecraftServer server = this.getServer();
        if (Objects.isNull(server)) {
            TILRef.logError("Unable to get the save directory as the server did not exist! Was this called from the client side?", new Object[0]);
            return null;
        }
        Object save = this.getLevelSave(server);
        if (Objects.isNull(save)) {
            TILRef.logError("Failed to get LevelSave instance from server", new Object[0]);
            return null;
        }
        Path path = this.getLevelPath(save);
        if (Objects.isNull(path)) {
            TILRef.logError("Failed to get path instance from LevelSave", new Object[0]);
            return null;
        }
        return path.toFile();
    }

    @Nullable
    protected Path getLevelPath(Object save) {
        String fieldName = CoreAPI.isNamedEnv() ? "levelDirectory" : (CoreAPI.isSrgEnv() ? "f_230867_" : "field_23768");
        ClassHelper.checkBurningWaveInit();
        class_32.class_7411 dir = (class_32.class_7411)StaticComponentContainer.Fields.getDirect(save, fieldName);
        return dir.comp_732();
    }

    @Nullable
    protected Object getLevelSave(Object server) {
        Field saveField = this.getLevelSaveField(server);
        return ReflectionHelper.getFieldInstance(server, saveField);
    }

    @Nullable
    protected abstract Field getLevelSaveField(Object var1);

    @Override
    public abstract MinecraftServer getServer();
}

