/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.v18.m2.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.WrapperHelper;
import mods.thecomputerizer.theimpossiblelibrary.fabric.v18.m2.common.biome.Biome1_18_2;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3765;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5312;
import net.minecraft.class_5455;
import org.jetbrains.annotations.Nullable;

public class World1_18_2
extends WorldAPI<class_1936> {
    public World1_18_2(Object world) {
        super((class_1936)world);
    }

    @Override
    public boolean canSnowAt(BlockPosAPI<?> api) {
        class_2338 pos = (class_2338)api.unwrap();
        return ((class_1959)((class_1936)this.wrapped).method_23753(pos).comp_349()).method_33599(pos);
    }

    @Override
    public BiomeAPI<?> getBiomeAt(BlockPosAPI<?> pos) {
        BiomeAPI biome = WrapperHelper.wrapBiome(((class_1936)this.wrapped).method_23753((class_2338)pos.unwrap()).comp_349());
        ((Biome1_18_2)biome).setAccess(((class_1936)this.wrapped).method_30349());
        return biome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box box) {
        ArrayList entities = new ArrayList();
        if (this.wrapped instanceof class_1937) {
            class_1936 class_19362 = (class_1936)this.wrapped;
            synchronized (class_19362) {
                for (class_2791 chunk : this.getChunks(box)) {
                    for (class_2338 pos : chunk.method_12021()) {
                        if (!box.isInside(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
                        entities.add(WrapperHelper.wrapBlockEntity(chunk.method_8321(pos)));
                    }
                }
            }
        }
        return entities;
    }

    @Override
    @Nullable
    public BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> pos) {
        class_2586 tile = ((class_1936)this.wrapped).method_8321((class_2338)pos.unwrap());
        return Objects.nonNull(tile) ? WrapperHelper.wrapBlockEntity(tile) : null;
    }

    Collection<class_2791> getChunks(Box box) {
        HashSet<class_2791> chunks = new HashSet<class_2791>();
        for (double x = box.minX(); x < box.maxX(); x += 16.0) {
            double z = box.minZ();
            while (x < box.maxZ()) {
                int chunkX = class_4076.method_18675((int)((int)x));
                int chunkZ = class_4076.method_18675((int)((int)z));
                chunks.add(((class_1936)this.wrapped).method_8392(chunkX, chunkZ));
                x += 16.0;
            }
        }
        return chunks;
    }

    @Override
    public int getDayNumber() {
        return (int)((double)this.getTimeTotal() / 24000.0);
    }

    @Override
    public int getDifficultyOrdinal() {
        if (((class_1936)this.wrapped).method_8401().method_152()) {
            return 4;
        }
        return switch (((class_1936)this.wrapped).method_8407()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1267.field_5801 -> 0;
            case class_1267.field_5805 -> 1;
            case class_1267.field_5802 -> 2;
            case class_1267.field_5807 -> 3;
        };
    }

    @Override
    public DimensionAPI<?> getDimension() {
        return WrapperHelper.wrapDimension(this, ((class_1936)this.wrapped).method_8597());
    }

    @Override
    public List<EntityAPI<?, ?>> getEntitiesInBox(Box box) {
        return this.getEntitiesInBox(new class_238(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<EntityAPI<?, ?>> getEntitiesInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (class_1297 entity : ((class_1936)this.wrapped).method_18467(class_1297.class, (class_238)box)) {
            entities.add(WrapperHelper.wrapEntity(entity));
        }
        return entities;
    }

    @Override
    public int getLightBlock(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8314(class_1944.field_9282, (class_2338)pos.unwrap());
    }

    @Override
    public int getLightSky(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8314(class_1944.field_9284, (class_2338)pos.unwrap());
    }

    @Override
    public int getLightTotal(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_22336().method_22363((class_2338)pos.unwrap(), 0);
    }

    @Override
    public List<LivingEntityAPI<?, ?>> getLivingInBox(Box box) {
        return this.getLivingInBox(new class_238(box.min.dX(), box.min.dY(), box.min.dZ(), box.max.dX(), box.max.dY(), box.max.dZ()));
    }

    private List<LivingEntityAPI<?, ?>> getLivingInBox(Object box) {
        ArrayList entities = new ArrayList();
        for (class_1309 entity : ((class_1936)this.wrapped).method_18467(class_1309.class, (class_238)box)) {
            entities.add(WrapperHelper.wrapLivingEntity(entity));
        }
        return entities;
    }

    @Override
    public int getMoonPhase() {
        return ((class_1936)this.wrapped).method_30273();
    }

    private class_3765 getRaid(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8608() ? null : ((class_3218)this.wrapped).method_19502((class_2338)pos.unwrap());
    }

    @Override
    @Nullable
    public String getRaidStatus(BlockPosAPI<?> pos) {
        class_3765 raid = this.getRaid(pos);
        if (Objects.isNull(raid)) {
            return null;
        }
        if (raid.method_20023()) {
            return "VICTORY";
        }
        if (raid.method_20024()) {
            return "LOSS";
        }
        if (raid.method_20022()) {
            return "STOPPED";
        }
        if (raid.method_16504()) {
            return "ONGOING";
        }
        return null;
    }

    @Override
    public int getRaidWave(BlockPosAPI<?> pos) {
        class_3765 raid = this.getRaid(pos);
        return Objects.nonNull(raid) ? raid.method_16490() : -1;
    }

    @Override
    public BlockStateAPI<?> getStateAt(BlockPosAPI<?> pos) {
        return WrapperHelper.wrapState(((class_1936)this.wrapped).method_8320((class_2338)pos.unwrap()));
    }

    @Override
    public StructureAPI<?> getStructureAt(BlockPosAPI<?> api) {
        if (this.wrapped instanceof class_3218) {
            class_5138 manager = ((class_3218)this.wrapped).method_27056();
            class_2338 pos = (class_2338)api.unwrap();
            class_5455 access = ((class_1936)this.wrapped).method_30349();
            class_2378 registry = access.method_33310(class_2378.field_25915).orElse(null);
            if (Objects.isNull(registry)) {
                return null;
            }
            for (Map.Entry entry : registry.method_29722()) {
                class_5312 structure = (class_5312)entry.getValue();
                if (!manager.method_28388(pos, structure).method_16657()) continue;
                return WrapperHelper.wrapStructure(structure);
            }
        }
        return null;
    }

    @Override
    public long getTimeDay() {
        return this.getTimeTotal() % 24000L;
    }

    @Override
    public long getTimeTotal() {
        return ((class_1936)this.wrapped).method_30271();
    }

    @Override
    public boolean isClient() {
        return ((class_1936)this.wrapped).method_8608();
    }

    @Override
    public boolean isDaytime() {
        return this.wrapped instanceof class_1937 && this.getTimeDay() < 13000L;
    }

    @Override
    public boolean isNighttime() {
        return this.wrapped instanceof class_1937 && this.getTimeDay() >= 13000L;
    }

    @Override
    public boolean isRaining() {
        return this.wrapped instanceof class_1937 && ((class_1937)this.wrapped).method_8419();
    }

    @Override
    public boolean isSkyVisible(BlockPosAPI<?> pos) {
        return ((class_1936)this.wrapped).method_8311((class_2338)pos.unwrap());
    }

    @Override
    public boolean isStorming() {
        return this.wrapped instanceof class_1937 && ((class_1937)this.wrapped).method_8546();
    }

    @Override
    public boolean isSunrise() {
        return this.getTimeDay() >= 23000L;
    }

    @Override
    public boolean isSunset() {
        long time = this.getTimeDay();
        return time >= 12000L && time < 13000L;
    }

    @Override
    public void setState(BlockPosAPI<?> pos, BlockStateAPI<?> state) {
        ((class_1936)this.wrapped).method_8652((class_2338)pos.unwrap(), (class_2680)state.unwrap(), 2);
    }

    @Override
    public void spawnEntity(EntityAPI<?, ?> entity, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((class_1936)this.wrapped).method_8608()) {
            ((class_1936)this.wrapped).method_8649((class_1297)entity.unwrapEntity());
            if (Objects.nonNull(onSpawn)) {
                onSpawn.accept(entity);
            }
        }
    }

    @Override
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (this.wrapped instanceof class_1937 && !((class_1936)this.wrapped).method_8608()) {
            class_1542 item = new class_1542((class_1937)this.wrapped, pos.dX(), pos.dY(), pos.dZ(), (class_1799)stack.unwrap());
            item.method_6988();
            this.spawnEntity(WrapperHelper.wrapEntity(item), onSpawn);
        }
    }

    @Override
    public void spawnItem(ItemAPI<?> api, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn, @Nullable Consumer<EntityAPI<?, ?>> onSpawn) {
        if (!((class_1936)this.wrapped).method_8608()) {
            ItemStackAPI stack = WrapperHelper.wrapItemStack(new class_1799((class_1935)((class_1792)api.unwrap())));
            if (Objects.nonNull(beforeSpawn)) {
                beforeSpawn.accept(stack);
            }
            this.spawnItem(stack, pos, onSpawn);
        }
    }
}

