/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core.asm;

import java.util.List;
import java.util.Map;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ModWriter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import mods.thecomputerizer.theimpossiblelibrary.fabric.core.FabricHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class ModWriterFabric
extends ModWriter {
    protected static final String FABRIC_HELPER_INTERNAL = Type.getType(FabricHelper.class).getInternalName();
    protected static final String FINALIZER_DESC = TypeHelper.method(Type.VOID_TYPE, CommonEntryPoint.class).getDescriptor();

    protected ModWriterFabric(CoreAPI core, MultiVersionModInfo info, int javaVersion) {
        super(core, info, javaVersion);
    }

    protected void addEntryHooks(MethodVisitor visitor, boolean isStatic, String method) {
        this.addEntryHooks(visitor, isStatic, method, false);
    }

    protected Map.Entry<ClassWriter, Type> addInnerEntryPoint(ClassVisitor outerClass, boolean client, String innerName) {
        return this.addInnerClass(outerClass, innerName, inner -> {
            this.writeMethod((ClassVisitor)inner, cv -> ASMHelper.getConstructor(cv, 1, new Type[0]), constructor -> ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE.getInternalName(), EMPTY_METHOD_DESC, false));
            String init = client ? "onInitializeClient" : "onInitializeServer";
            this.writeMethod((ClassVisitor)inner, cv -> ASMHelper.getMethod(cv, 1, init, new Type[0]), method -> this.addEntryHooks((MethodVisitor)method, true, init));
        }, client, !client);
    }

    @Override
    protected Type getEventMethod(String className) {
        return ASMRef.EMPTY_METHOD;
    }

    @Override
    protected void mappedEntryPointMethods(Map<String, String[]> redirects, Map<String, Type> types) {
        this.mapEntryPointMethod(redirects, types, "<init>", ASMRef.EMPTY_METHOD, "onConstructed", "onPreRegistration");
        this.mapEntryPointMethod(redirects, types, "onInitialize", ASMRef.EMPTY_METHOD, "onCommonSetup");
        this.mapEntryPointMethod(redirects, types, "onInitializeClient", ASMRef.EMPTY_METHOD, "checkClientSetup", "onInterModEnqueue");
        this.mapEntryPointMethod(redirects, types, "onInitializeServer", ASMRef.EMPTY_METHOD, "checkDedicatedServerSetup", "onInterModEnqueue");
    }

    @Override
    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        super.writeMod(writer, classBytes);
        String init = "onInitialize";
        this.writeMethod((ClassVisitor)writer, cv -> ASMHelper.getMethod(cv, 1, "onInitialize", new Type[0]), method -> {
            this.addEntryHooks((MethodVisitor)method, false, "onInitialize");
            method.visitVarInsn(25, 0);
            method.visitFieldInsn(180, this.modTypeInternal, "entryPoint", this.entryPointDesc);
            method.visitMethodInsn(184, FABRIC_HELPER_INTERNAL, "finalizeEntrypoints", FINALIZER_DESC, false);
        });
        if (this.info.isClient() && this.core.getSide().isClient()) {
            this.writeInnerClass(this.addInnerEntryPoint((ClassVisitor)writer, true, "LoaderClient"), classBytes);
        }
        if (this.info.isServer() && this.core.getSide().isServer()) {
            this.writeInnerClass(this.addInnerEntryPoint((ClassVisitor)writer, false, "LoaderServer"), classBytes);
        }
    }
}

