/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.fabric.core;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.client.SharedHandlesClient;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class TILCoreEntryPointFabric
extends CoreEntryPoint {
    static final String ARRAYLIST = "java/util/ArrayList";
    static final String DEBUG_OVERLAY = TILCoreEntryPointFabric.mapClass("net.minecraft.client.gui.components.DebugScreenOverlay", "net.minecraft.class_340");
    static final String[] DEBUG_LIST_FIELDS = new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"};
    static final String CUSTOM_EVENTS = "mods/thecomputerizer/theimpossiblelibrary/fabric/client/event/CustomClientFabricEvents";
    static final String FABRIC_EVENT = "net/fabricmc/fabric/api/event/Event";
    protected static final String GUI = TILCoreEntryPointFabric.mapClass("net.minecraft.client.gui.Gui", "net.minecraft.class_329");
    static final String KEYBOARD_HANDLER = TILCoreEntryPointFabric.mapClass("net.minecraft.client.KeyboardHandler", "net.minecraft.class_309");
    static final String INVOKER_DESC = TypeHelper.methodDesc(ASMRef.OBJECT_TYPE);
    static final String LIST = "java/util/List";
    protected static final String MINECRAFT = TILCoreEntryPointFabric.mapClass("net/minecraft/client/Minecraft", "net/minecraft/class_310");
    static final String OPTIONS = TILCoreEntryPointFabric.mapClass("net/minecraft/client/Options", "net/minecraft/class_315");
    protected static final String POSESTACK = TILCoreEntryPointFabric.mapClass("com.mojang.blaze3d.vertex.PoseStack", "net.minecraft.class_4587");
    static final String REF = Type.getInternalName(TILRef.class);
    static final String SHARED_HANDLES_CLIENT = Type.getInternalName(SharedHandlesClient.class);
    protected final CoreAPI core = CoreAPI.getInstance();

    protected static String mapClass(String dev, String notDev) {
        return CoreAPI.getInstance().mapClassName(TILCoreEntryPointFabric.mapDev(dev, notDev), false);
    }

    protected static String mapDev(String dev, String notDev) {
        return TILDev.DEV ? dev : notDev;
    }

    public TILCoreEntryPointFabric() {
        TILRef.logInfo("Initialized core version handler {}", this.getClass());
    }

    void addRenderFields(List<FieldNode> fields) {
        String signature = this.toSignature(LIST, String.class.getName());
        for (String name : new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"}) {
            fields.add(new FieldNode(20, name, this.toDesc(LIST), signature, null));
        }
    }

    InsnList buildKeyPressInvoker() {
        String keyPressedOwner = this.customEventOwner("KeyPressed");
        String keyPressedDesc = TypeHelper.voidMethodDesc(Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE);
        this.beginList(new InsnList()).insField(178, CUSTOM_EVENTS, "KEY_PRESSED", this.toDesc(FABRIC_EVENT)).insInvokeVirtual(FABRIC_EVENT, "invoker", INVOKER_DESC).insType(192, keyPressedOwner);
        for (int i : new int[]{3, 4, 5, 6}) {
            this.insVar(21, i);
        }
        return this.insInvokeInterface(keyPressedOwner, "onKeyPressed", keyPressedDesc).endList();
    }

    InsnList buildRenderDebugInvoker(ClassNode node, String owner) {
        boolean actualDebug = DEBUG_OVERLAY.equals(owner);
        String renderDebugOwner = this.customEventOwner("RenderDebugInfo");
        Type listType = Type.getType(List.class);
        String renderDebugDesc = TypeHelper.voidMethodDesc(Type.getType((String)this.toDesc(POSESTACK)), listType, listType);
        String getInfoDesc = TypeHelper.methodDesc(List.class);
        String addAllDesc = TypeHelper.methodDesc(Type.BOOLEAN_TYPE, Collection.class);
        String listDesc = this.toDesc(LIST);
        this.beginList(new InsnList());
        if (actualDebug) {
            for (String name : DEBUG_LIST_FIELDS) {
                this.insThis().insField(180, owner, name, listDesc).insInvokeInterface(LIST, "clear");
                boolean left = name.endsWith("left");
                String methodName = this.core.mapMethodName(node.name, left ? (TILDev.DEV ? "getGameInformation" : "method_1835") : (TILDev.DEV ? "getSystemInformation" : "method_1839"), getInfoDesc);
                this.insThis().insField(180, owner, name, listDesc).insThis().insInvokeVirtual(owner, methodName, getInfoDesc).insInvokeInterface(LIST, "addAll", addAllDesc);
            }
        } else {
            this.renderDebugQuery(owner).insIf(154, new Label());
            for (String name : DEBUG_LIST_FIELDS) {
                this.insThis().insField(180, owner, name, listDesc).insInvokeInterface(LIST, "clear");
            }
        }
        this.insField(178, CUSTOM_EVENTS, "RENDER_DEBUG_INFO", this.toDesc(FABRIC_EVENT)).insInvokeVirtual(FABRIC_EVENT, "invoker", INVOKER_DESC).insType(192, renderDebugOwner);
        this.loadLocalPoseStack(1);
        for (String name : DEBUG_LIST_FIELDS) {
            this.insThis().insField(180, owner, name, listDesc);
        }
        this.insInvokeInterface(renderDebugOwner, "onRenderDebug", renderDebugDesc);
        if (!actualDebug) {
            String renderDesc = TypeHelper.voidMethodDesc(ASMRef.OBJECT_TYPE, listType, listType);
            this.insInvokeStatic(REF, "getClientHandles", TypeHelper.methodDesc(SharedHandlesClient.class));
            this.insVar(25, 1);
            for (String name : DEBUG_LIST_FIELDS) {
                this.insThis().insField(180, owner, name, listDesc);
            }
            this.insInvokeVirtual(SHARED_HANDLES_CLIENT, "renderDebugText", renderDesc);
        }
        return actualDebug ? this.endList() : this.insLabel().endList();
    }

    @Override
    public List<String> classTargets() {
        return this.core.isClientSide() ? Arrays.asList(KEYBOARD_HANDLER, DEBUG_OVERLAY, GUI) : Collections.emptyList();
    }

    String customEventOwner(String name) {
        return "mods/thecomputerizer/theimpossiblelibrary/fabric/client/event/CustomClientFabricEvents$" + name;
    }

    @Override
    public ClassNode editClass(ClassNode classNode) {
        TILRef.logInfo("Editing class node for {}", classNode.name);
        if (this.isTarget(classNode)) {
            boolean keyboard;
            String name = this.getClassName(classNode);
            boolean gui = name.endsWith("class_329") || name.endsWith("Gui");
            boolean screenOverlay = name.endsWith("class_340") || name.endsWith("DebugScreenOverlay");
            boolean bl = keyboard = name.endsWith("class_309") || name.endsWith("KeyboardHandler");
            if (gui || screenOverlay) {
                this.addRenderFields(classNode.fields);
            }
            for (MethodNode method : classNode.methods) {
                AbstractInsnNode node2;
                int ordinal;
                InsnList code = method.instructions;
                String methodName = this.getMethodName(classNode, method);
                if (keyboard && Misc.equalsAny(methodName, "keyPress", "method_1466")) {
                    ordinal = this.keyPressOrdinal(this.core.getVersion());
                    TILRef.logInfo("Building KEY_PRESSED invoker with ordinal {}", ordinal);
                    code.insert(ASMHelper.findLabel(code, ordinal), this.buildKeyPressInvoker());
                    continue;
                }
                if (screenOverlay) {
                    if (methodName.equals("<init>")) {
                        Function<AbstractInsnNode, Boolean> compare = node -> node.getOpcode() == 183;
                        node2 = ASMHelper.findNode(code, compare, 0);
                        code.insert(node2, this.initRenderFields(DEBUG_OVERLAY));
                        continue;
                    }
                    if (Misc.equalsAny(methodName, "drawGameInformation", "method_1847")) {
                        this.replace(code, "theimpossiblelibrary$left");
                        TILRef.logInfo("Building RENDER_DEBUG_INFO invoker for debug screen", new Object[0]);
                        code.insertBefore(code.getFirst(), this.buildRenderDebugInvoker(classNode, DEBUG_OVERLAY));
                        continue;
                    }
                    if (!Misc.equalsAny(methodName, "drawSystemInformation", "method_1848")) continue;
                    this.replace(code, "theimpossiblelibrary$right");
                    continue;
                }
                if (!gui) continue;
                if (methodName.equals("<init>")) {
                    Function<AbstractInsnNode, Boolean> compare = node -> node.getOpcode() == 183;
                    node2 = ASMHelper.findNode(code, compare, 0);
                    code.insert(node2, this.initRenderFields(GUI));
                    continue;
                }
                if (!Misc.equalsAny(methodName, "render", "method_1753")) continue;
                ordinal = this.guiRenderOrdinal(this.core.getVersion());
                TILRef.logInfo("Building RENDER_DEBUG_INFO invoker for gui with ordinal {}", ordinal);
                AbstractInsnNode label = ASMHelper.findLabel(code, ordinal);
                code.insertBefore(label, this.buildRenderDebugInvoker(classNode, GUI));
            }
        }
        return classNode;
    }

    @Override
    public String getCoreID() {
        return "theimpossiblelibrary_core";
    }

    @Override
    public String getCoreName() {
        return "The Impossible Library Core";
    }

    int guiRenderOrdinal(CoreAPI.GameVersion version) {
        switch (version) {
            case V16_5: {
                return 60;
            }
            case V18_2: 
            case V19_2: {
                return 68;
            }
            case V19_4: {
                return 62;
            }
            case V20_1: 
            case V20_4: {
                return 58;
            }
        }
        return 3;
    }

    int keyPressOrdinal(CoreAPI.GameVersion version) {
        switch (version) {
            case V16_5: {
                return 38;
            }
            case V18_2: 
            case V19_2: {
                return 45;
            }
            case V19_4: 
            case V20_1: {
                return 48;
            }
            case V20_4: 
            case V20_6: {
                return 50;
            }
        }
        return 52;
    }

    InsnList initRenderFields(String owner) {
        this.beginList(new InsnList());
        for (String name : new String[]{"theimpossiblelibrary$left", "theimpossiblelibrary$right"}) {
            this.insThis().insType(187, ARRAYLIST).insBasic(89).insInvokeSpecial(ARRAYLIST, "<init>").insField(181, owner, name, this.toDesc(LIST));
        }
        return this.endList();
    }

    protected void loadLocalPoseStack(int index) {
        this.insVar(25, index);
    }

    protected CoreEntryPoint renderDebugQuery(String owner) {
        this.insVar(25, 0);
        String mcFieldDesc = this.toDesc(MINECRAFT);
        String mcFieldName = TILCoreEntryPointFabric.mapDev("minecraft", "field_2035");
        String optionsFieldDesc = this.toDesc(OPTIONS);
        String optionsFieldName = TILCoreEntryPointFabric.mapDev("options", "field_1690");
        String renderFieldName = TILCoreEntryPointFabric.mapDev("renderDebug", "field_1866");
        return this.insField(180, owner, mcFieldName, mcFieldDesc).insField(180, MINECRAFT, optionsFieldName, optionsFieldDesc).insField(180, OPTIONS, renderFieldName, "Z");
    }

    void replace(InsnList code, String name) {
        Supplier<FieldInsnNode> fieldNode = () -> new FieldInsnNode(180, DEBUG_OVERLAY, name, this.toDesc(LIST));
        ASMHelper.replaceNode(code, node -> node.getOpcode() == 182 ? (AbstractInsnNode)fieldNode.get() : node, 0, 0);
    }
}

