/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.world;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import mods.thecomputerizer.theimpossiblelibrary.api.common.biome.BiomeAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockStateAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.MaterialAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.LivingEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.item.ItemStackAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.structure.StructureAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Box;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.world.DimensionAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.AbstractWrapped;
import org.jetbrains.annotations.Nullable;

public abstract class WorldAPI<W>
extends AbstractWrapped<W> {
    protected WorldAPI(W world) {
        super(world);
    }

    public abstract boolean canSnowAt(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract BiomeAPI<?> getBiomeAt(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract Collection<BlockEntityAPI<?, ?>> getBlockEntitiesInBox(Box var1);

    @IndirectCallers
    @Nullable
    public abstract BlockEntityAPI<?, ?> getBlockEntityAt(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract int getDayNumber();

    public abstract int getDifficultyOrdinal();

    public abstract DimensionAPI<?> getDimension();

    @IndirectCallers
    public abstract List<EntityAPI<?, ?>> getEntitiesInBox(Box var1);

    @IndirectCallers
    public abstract int getLightBlock(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract int getLightSky(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract int getLightTotal(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract List<LivingEntityAPI<?, ?>> getLivingInBox(Box var1);

    public MaterialAPI<?> getMaterialAt(BlockPosAPI<?> pos) {
        return this.getStateAt(pos).getMaterial();
    }

    @IndirectCallers
    public abstract int getMoonPhase();

    @IndirectCallers
    @Nullable
    public abstract String getRaidStatus(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract int getRaidWave(BlockPosAPI<?> var1);

    public abstract BlockStateAPI<?> getStateAt(BlockPosAPI<?> var1);

    @IndirectCallers
    public abstract StructureAPI<?> getStructureAt(BlockPosAPI<?> var1);

    public abstract long getTimeDay();

    public abstract long getTimeTotal();

    public abstract boolean isClient();

    public abstract boolean isDaytime();

    @IndirectCallers
    public boolean isDifficultyEasy() {
        return this.getDifficultyOrdinal() == 1;
    }

    @IndirectCallers
    public boolean isDifficultyHard() {
        return this.getDifficultyOrdinal() >= 3;
    }

    @IndirectCallers
    public boolean isDifficultyHardcore() {
        return this.getDifficultyOrdinal() == 4;
    }

    @IndirectCallers
    public boolean isDifficultyNormal() {
        return this.getDifficultyOrdinal() == 2;
    }

    @IndirectCallers
    public boolean isDifficultyPeaceful() {
        return this.getDifficultyOrdinal() == 0;
    }

    @IndirectCallers
    public boolean isNighttime() {
        return !this.isDaytime();
    }

    public abstract boolean isRaining();

    public boolean isServer() {
        return !this.isClient();
    }

    @IndirectCallers
    public abstract boolean isSkyVisible(BlockPosAPI<?> var1);

    @IndirectCallers
    public boolean isSnowingAt(BlockPosAPI<?> pos) {
        return this.isRaining() && this.canSnowAt(pos);
    }

    @IndirectCallers
    public abstract boolean isStorming();

    @IndirectCallers
    public abstract boolean isSunrise();

    @IndirectCallers
    public abstract boolean isSunset();

    @IndirectCallers
    public boolean isUnderwater(BlockPosAPI<?> pos) {
        MaterialAPI<?> material = this.getMaterialAt(pos);
        return Objects.nonNull(material) && material.isUnderwater();
    }

    @IndirectCallers
    public abstract void setState(BlockPosAPI<?> var1, BlockStateAPI<?> var2);

    @IndirectCallers
    public void spawnEntity(EntityAPI<?, ?> entity) {
        this.spawnEntity(entity, null);
    }

    public abstract void spawnEntity(EntityAPI<?, ?> var1, @Nullable Consumer<EntityAPI<?, ?>> var2);

    @IndirectCallers
    public void spawnItem(ItemStackAPI<?> stack, Vector3 pos) {
        this.spawnItem(stack, pos, null);
    }

    public abstract void spawnItem(ItemStackAPI<?> var1, Vector3 var2, @Nullable Consumer<EntityAPI<?, ?>> var3);

    @IndirectCallers
    public void spawnItem(ItemAPI<?> item, Vector3 pos) {
        this.spawnItem(item, pos, null, null);
    }

    @IndirectCallers
    public void spawnItem(ItemAPI<?> item, Vector3 pos, @Nullable Consumer<ItemStackAPI<?>> beforeSpawn) {
        this.spawnItem(item, pos, beforeSpawn, null);
    }

    public abstract void spawnItem(ItemAPI<?> var1, Vector3 var2, @Nullable Consumer<ItemStackAPI<?>> var3, @Nullable Consumer<EntityAPI<?, ?>> var4);
}

