/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.BaseTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.CompoundTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.ListTagAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.tag.TagHelper;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public class GenericUtils {
    @Nullable
    public static <T> T cast(@Nullable Object obj) {
        return (T)(Objects.nonNull(obj) ? obj : null);
    }

    @IndirectCallers
    @Nullable
    public static <I1, I2> BiConsumer<I1, I2> castBiConsumer(@Nullable BiConsumer<?, ?> consumer) {
        return Objects.nonNull(consumer) ? (input1, input2) -> consumer.accept(GenericUtils.cast(input1), GenericUtils.cast(input2)) : null;
    }

    @IndirectCallers
    @Nullable
    public static <I1, I2, O> BiFunction<I1, I2, O> castBiFunction(@Nullable BiFunction<?, ?, ?> function) {
        return Objects.nonNull(function) ? (input1, input2) -> GenericUtils.cast(function.apply(GenericUtils.cast(input1), GenericUtils.cast(input2))) : null;
    }

    @IndirectCallers
    @Nullable
    public static <I> Consumer<I> castConsumer(@Nullable Consumer<?> consumer) {
        return Objects.nonNull(consumer) ? input -> consumer.accept(GenericUtils.cast(input)) : null;
    }

    @IndirectCallers
    @Nullable
    public static <I, O> Function<I, O> castFunction(@Nullable Function<?, ?> function) {
        return Objects.nonNull(function) ? input -> GenericUtils.cast(function.apply(GenericUtils.cast(input))) : null;
    }

    @IndirectCallers
    public static <T> T castGenericType(@Nullable Object obj, Class<T> valType) {
        if (Objects.isNull(obj)) {
            return null;
        }
        return GenericUtils.isPrimitiveInstance(obj) ? GenericUtils.cast(GenericUtils.parseGenericType(obj.toString(), valType)) : valType.cast(obj);
    }

    @IndirectCallers
    @Nullable
    public static <O> Supplier<O> castSupplier(@Nullable Supplier<?> supplier) {
        return Objects.nonNull(supplier) ? () -> GenericUtils.cast(supplier.get()) : null;
    }

    public static boolean isAnyType(Class<?> clazz, Class<?> ... classTypes) {
        for (Class<?> type : classTypes) {
            if (!type.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceAnyType(Object obj, Class<?> ... types) {
        return GenericUtils.isAnyType(obj.getClass(), types);
    }

    @IndirectCallers
    public static boolean isListAnyType(List<?> list, Class<?> ... classTypes) {
        return !list.isEmpty() && GenericUtils.isInstanceAnyType(list.get(0), classTypes);
    }

    public static boolean isPrimitive(Class<?> clazz) {
        return GenericUtils.isAnyType(clazz, Boolean.TYPE, Number.class, String.class);
    }

    public static boolean isPrimitiveInstance(Object obj) {
        return GenericUtils.isPrimitive(obj.getClass());
    }

    public static boolean matches(@Nullable Object value, @Nullable Object other) {
        if (Objects.isNull(value)) {
            return Objects.isNull(other);
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (value.equals(other)) {
            return true;
        }
        if (value instanceof String) {
            return value.equals(other.toString());
        }
        if (value instanceof Number) {
            return GenericUtils.numberMatches((Number)value, other);
        }
        if (value instanceof Boolean) {
            boolean bool = (Boolean)value;
            if (other instanceof Number) {
                int num = ((Number)other).intValue();
                return bool && num == 1 || !bool && num == 0;
            }
        } else {
            if (value instanceof Object[]) {
                return ArrayHelper.matches((Object[])value, other);
            }
            if (value instanceof Iterable) {
                return IterableHelper.matches((Iterable)value, other);
            }
            if (value instanceof Iterator) {
                return IterableHelper.matches((Iterator)value, other);
            }
        }
        return value.toString().equals(other.toString());
    }

    public static Number numberAdd(Number n1, Number n2) {
        if (n1 instanceof Byte) {
            return n1.byteValue() + n2.byteValue();
        }
        if (n1 instanceof Double) {
            return n1.doubleValue() + n2.doubleValue();
        }
        if (n1 instanceof Float) {
            return Float.valueOf(n1.floatValue() + n2.floatValue());
        }
        if (n1 instanceof Integer) {
            return n1.intValue() + n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() + n2.longValue();
        }
        return n1.shortValue() + n2.shortValue();
    }

    public static Number numberDiv(Number n1, Number n2) {
        if (n1 instanceof Byte) {
            return n1.byteValue() / n2.byteValue();
        }
        if (n1 instanceof Double) {
            return n1.doubleValue() / n2.doubleValue();
        }
        if (n1 instanceof Float) {
            return Float.valueOf(n1.floatValue() / n2.floatValue());
        }
        if (n1 instanceof Integer) {
            return n1.intValue() / n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() / n2.longValue();
        }
        return n1.shortValue() / n2.shortValue();
    }

    public static boolean numberMatches(Number number, Object other) {
        if (number instanceof Byte) {
            return GenericUtils.numberMatches((Byte)number, other, obj -> Byte.parseByte((String)other), (n1, n2) -> n1.byteValue() == n2.byteValue());
        }
        if (number instanceof Double) {
            return GenericUtils.numberMatches((Double)number, other, obj -> Double.parseDouble((String)other), (n1, n2) -> n1.doubleValue() == n2.doubleValue());
        }
        if (number instanceof Float) {
            return GenericUtils.numberMatches((Float)number, other, obj -> Float.valueOf(Float.parseFloat((String)other)), (n1, n2) -> n1.floatValue() == n2.floatValue());
        }
        if (number instanceof Integer) {
            return GenericUtils.numberMatches((Integer)number, other, obj -> Integer.parseInt((String)other), (n1, n2) -> n1.intValue() == n2.intValue());
        }
        if (number instanceof Long) {
            return GenericUtils.numberMatches((Long)number, other, obj -> Long.parseLong((String)other), (n1, n2) -> n1.longValue() == n2.longValue());
        }
        if (number instanceof Short) {
            return GenericUtils.numberMatches((Short)number, other, obj -> Short.parseShort((String)other), (n1, n2) -> n1.shortValue() == n2.shortValue());
        }
        return number.toString().equals(other.toString());
    }

    private static <N extends Number> boolean numberMatches(N number, Object other, Function<Object, N> fromString, BiFunction<N, Number, Boolean> numberEquals) {
        if (other instanceof String) {
            return number.equals(fromString.apply(other));
        }
        if (other instanceof Number) {
            return numberEquals.apply(number, (Number)other);
        }
        if (other instanceof Object[]) {
            return ArrayHelper.matches((Object[])other, number);
        }
        if (other instanceof Iterable) {
            return IterableHelper.matches((Iterable)other, number);
        }
        if (other instanceof Iterator) {
            return IterableHelper.matches((Iterator)other, number);
        }
        return number.toString().equals(other.toString());
    }

    public static Number numberMul(Number n1, Number n2) {
        if (n1 instanceof Byte) {
            return n1.byteValue() * n2.byteValue();
        }
        if (n1 instanceof Double) {
            return n1.doubleValue() * n2.doubleValue();
        }
        if (n1 instanceof Float) {
            return Float.valueOf(n1.floatValue() * n2.floatValue());
        }
        if (n1 instanceof Integer) {
            return n1.intValue() * n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() * n2.longValue();
        }
        return n1.shortValue() * n2.shortValue();
    }

    public static Number numberSub(Number n1, Number n2) {
        if (n1 instanceof Byte) {
            return n1.byteValue() - n2.byteValue();
        }
        if (n1 instanceof Double) {
            return n1.doubleValue() - n2.doubleValue();
        }
        if (n1 instanceof Float) {
            return Float.valueOf(n1.floatValue() - n2.floatValue());
        }
        if (n1 instanceof Integer) {
            return n1.intValue() - n2.intValue();
        }
        if (n1 instanceof Long) {
            return n1.longValue() - n2.longValue();
        }
        return n1.shortValue() - n2.shortValue();
    }

    public static Object parseGenericFromTag(CompoundTagAPI<?> tag) {
        String className = tag.getString("type");
        if (className.isEmpty()) {
            return null;
        }
        try {
            Class<?> valType = Class.forName(className);
            if (List.class.isAssignableFrom(valType)) {
                return GenericUtils.readFromList(tag.getListTag("value"));
            }
            String storedVal = tag.getString("value");
            if (storedVal.isEmpty()) {
                return null;
            }
            return GenericUtils.parseGenericType(storedVal, valType);
        }
        catch (ClassNotFoundException ex) {
            TILRef.logError("Could not find class name {} when parsing a generic object from Tag!", className, ex);
            return null;
        }
    }

    public static Object parseGenericType(String unparsed, Class<?> valType) {
        if (valType.isPrimitive()) {
            return GenericUtils.parsePrimitive(unparsed, valType);
        }
        if ("Date".equals(valType.getSimpleName())) {
            return Date.parse(unparsed);
        }
        return unparsed;
    }

    public static <N extends Number> N parseNumber(String unparsed, Class<?> valType) {
        String typeName = valType.getSimpleName();
        if ("Integer".equals(typeName)) {
            typeName = "Int";
        }
        return (N)((Number)StaticComponentContainer.Methods.invokeStatic(valType, "parse" + typeName, unparsed));
    }

    public static <N extends Number> N parseNumber(String unparsed, N defaultValue) {
        Class<?> valType = defaultValue.getClass();
        try {
            return (N)GenericUtils.parseNumber(unparsed, valType);
        }
        catch (NumberFormatException ex) {
            TILRef.logError("Failed to parse {} as {}", unparsed, defaultValue.getClass().getName());
            return defaultValue;
        }
    }

    public static <V> V parsePrimitive(String unparsed, Class<V> valType) {
        Boolean ret = null;
        if (valType != Void.TYPE && valType != Void.class) {
            ret = valType == Boolean.TYPE || valType == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(unparsed)) : GenericUtils.parseNumber(unparsed, valType);
        }
        return (V)GenericUtils.cast(ret);
    }

    private static List<?> readFromList(ListTagAPI<?> list) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (BaseTagAPI<?> based : list.iterable()) {
            if (based.isCompound()) {
                ret.add(GenericUtils.parseGenericFromTag(based.asCompoundTag()));
                continue;
            }
            return null;
        }
        return ret;
    }

    @IndirectCallers
    public static void writeGenericToTag(CompoundTagAPI<?> tag, Object obj) {
        tag.putString("type", obj.getClass().getName());
        if (obj instanceof List) {
            tag.putTag("value", GenericUtils.writeList(obj));
        } else {
            tag.putString("value", obj.toString());
        }
    }

    private static ListTagAPI<?> writeList(Object obj) {
        ListTagAPI<?> list = TagHelper.makeListTag();
        if (Objects.nonNull(list)) {
            List val = (List)obj;
            for (Object element : val) {
                CompoundTagAPI<?> tag = TagHelper.makeCompoundTag();
                if (!Objects.nonNull(tag)) continue;
                tag.putString("type", element.getClass().getName());
                if (element instanceof List) {
                    tag.putTag("value", GenericUtils.writeList(element));
                } else {
                    tag.putString("value", element.toString());
                }
                list.addTag(tag);
            }
        }
        return list;
    }

    static {
        ClassHelper.checkBurningWaveInit();
    }
}

