/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.toml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParser;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParsingException;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlReader;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;

public class TomlToken {
    final TomlReader reader;
    final Comment comment;
    final Entry entry;
    final Table table;
    StringBuilder lineBuilder;
    int lineNumber = 1;

    public TomlToken(TomlReader reader) {
        this.reader = reader;
        this.comment = new Comment();
        this.entry = new Entry();
        this.table = new Table();
        this.lineBuilder = new StringBuilder();
    }

    public void finish() throws TomlParsingException {
        if (this.comment.building) {
            this.comment.end(this.lineBuilder.toString(), this.lineNumber, -1);
        }
        if (this.table.building) {
            this.table.end(this.lineBuilder.toString(), this.lineNumber, -1);
        }
        if (this.entry.building) {
            this.entry.end(this.lineBuilder.toString(), this.lineNumber, -1);
        }
        this.lineBuilder = new StringBuilder();
        this.lineNumber = 1;
    }

    public void step(char c, int index) throws TomlParsingException {
        if (!TomlParser.isCharNewLine(c)) {
            this.lineBuilder.append(c);
        }
        if (this.comment.building) {
            this.comment.checkEnd(c, index);
            if (this.comment.building) {
                this.comment.step(c, index);
            }
        } else if (!this.comment.checkStart(c, index)) {
            if (this.table.building) {
                this.table.checkEnd(c, index);
                if (this.table.building) {
                    this.table.step(c, index);
                }
            } else if (!this.entry.building) {
                if (this.table.checkStart(c, index)) {
                    this.table.building = true;
                    this.table.step(c, index);
                } else if (this.entry.checkStart(c, index)) {
                    this.entry.building = true;
                    this.entry.step(c, index);
                }
            } else {
                this.entry.checkEnd(c, index);
                if (this.entry.building) {
                    this.entry.step(c, index);
                }
            }
        } else {
            this.comment.building = true;
            this.comment.step(c, index);
        }
        if (c == '\n') {
            if (!this.comment.building && !this.entry.building && !this.table.building && TextHelper.isEmpty(this.lineBuilder.toString())) {
                this.reader.emptyLine();
            }
            this.lineBuilder = new StringBuilder();
            ++this.lineNumber;
        }
    }

    class TomlString
    extends TomlValue {
        boolean multiline;

        TomlString(Value parent) {
            super(parent);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            this.getReader().endString(this.getLastBuilder().toString(), line, lineNumber, index);
            this.multiline = false;
            this.reset();
        }

        @Override
        boolean checkValueEnd(Value value, char c, int index) {
            return !this.multiline && TomlParser.isCharNewLine(c);
        }

        @Override
        boolean checkStart(char c, int index) {
            return c == '\'' || c == '\"';
        }

        @Override
        void step(char c, int index) {
            if (this.last == '\u0000' && (c == '\'' || c == '\"')) {
                this.quoting = c;
                this.pushLast(c);
            } else {
                if (c == '\'' && this.last == '\'' && this.beforeLast == '\'') {
                    this.multiline = true;
                }
                if (this.isQuoting()) {
                    if (c == this.quoting) {
                        this.quoting = '\u0000';
                    } else {
                        this.append(c);
                    }
                }
            }
        }
    }

    public static enum NumberType {
        BINARY,
        FLOAT,
        HEXADECIMAL,
        OCTAL;

    }

    class TomlNumber
    extends TomlValue {
        private NumberType type;
        boolean decimal;
        boolean e;

        TomlNumber(Value parent) {
            super(parent);
            this.decimal = false;
            this.e = false;
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            TomlParser.parseNumber(this.getReader(), this.getLastBuilder().toString(), this.type, line, lineNumber, index);
            this.type = null;
            this.decimal = false;
            this.e = false;
            this.reset();
        }

        @Override
        boolean checkValueEnd(Value value, char c, int index) {
            return c == '\n';
        }

        @Override
        boolean checkStart(char c, int index) {
            return Character.isDigit(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('i'), Character.valueOf('n'));
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            switch (c) {
                case '.': {
                    if (this.last == '\u0000') {
                        TomlParser.doThrow("Illegal first character", this.getLine(), this.getLineNumber(), index);
                    }
                    if (Objects.nonNull((Object)this.type) && this.type != NumberType.FLOAT) {
                        TomlParser.doThrow("Illegal `.` in non float number", this.getLine(), this.getLineNumber(), index);
                        break;
                    }
                    if (this.decimal) {
                        TomlParser.doThrow("Illegal second `.` in number", this.getLine(), this.getLineNumber(), index);
                        break;
                    }
                    this.type = NumberType.FLOAT;
                    this.decimal = true;
                    break;
                }
                case '_': {
                    if (this.last == '_') {
                        TomlParser.doThrow("Illegal number character (`_` may not be used consecutively)", this.getLine(), this.getLineNumber(), index);
                    }
                    this.pushLast(c);
                    return;
                }
                case '+': 
                case '-': {
                    if (this.last == '\u0000') {
                        return;
                    }
                    if (this.last == 'E' || this.last == 'e') break;
                    TomlParser.doThrow("The `" + c + "` character is only allowed to be first, after `e`, or after `E`", this.getLine(), this.getLineNumber(), index);
                    break;
                }
                case 'a': {
                    if (this.last == 'n') break;
                    TomlParser.doThrow("The character `a` may only be used as a number for `nan` values", this.getLine(), this.getLineNumber(), index);
                    break;
                }
                case 'b': {
                    if (this.last != '0') {
                        TomlParser.doThrow("The character `b` may only be used as a number for binary values (0b1111)", this.getLine(), this.getLineNumber(), index);
                    }
                    this.type = NumberType.BINARY;
                    break;
                }
                case 'E': 
                case 'e': {
                    if (this.last == '\u0000') {
                        TomlParser.doThrow("Illegal first character", this.getLine(), this.getLineNumber(), index);
                    }
                    if (Objects.nonNull((Object)this.type) && this.type != NumberType.FLOAT) {
                        TomlParser.doThrow("Illegal " + c + " in non float number", this.getLine(), this.getLineNumber(), index);
                        break;
                    }
                    if (this.e) {
                        TomlParser.doThrow("Illegal second `e` or 'E' in number", this.getLine(), this.getLineNumber(), index);
                        break;
                    }
                    this.type = NumberType.FLOAT;
                    this.e = true;
                    break;
                }
                case 'f': {
                    if (this.last == 'n') break;
                    TomlParser.doThrow("The character `f` may only be used as a number for `inf` values", this.getLine(), this.getLineNumber(), index);
                    break;
                }
                case 'i': {
                    if (Misc.equalsAny(Character.valueOf(c), Character.valueOf('\u0000'), Character.valueOf('-'), Character.valueOf('+'))) break;
                    TomlParser.doThrow("The character `i` may only be used as a number for `inf` values", this.getLine(), this.getLineNumber(), index);
                }
                case 'n': {
                    if (Misc.equalsAny(Character.valueOf(c), Character.valueOf('\u0000'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('a'), Character.valueOf('i'))) break;
                    TomlParser.doThrow("The character `i` may only be used as a number for `inf` values", this.getLine(), this.getLineNumber(), index);
                }
                case 'o': {
                    if (this.last != '0') {
                        TomlParser.doThrow("The character `o` may only be used as a number for octal values (0o7777)", this.getLine(), this.getLineNumber(), index);
                    }
                    this.type = NumberType.OCTAL;
                    break;
                }
                case 'x': {
                    if (this.last != '0') {
                        TomlParser.doThrow("The character `x` may only be used as a number for hexadecimal values (0xffff)", this.getLine(), this.getLineNumber(), index);
                    }
                    this.type = NumberType.HEXADECIMAL;
                    break;
                }
                default: {
                    if (Character.isDigit(c)) break;
                    if (!TomlParser.isCharNewLine(c) && !Character.isWhitespace(c)) {
                        TomlParser.doThrow("Illegal character `" + c + "` in number", this.getLine(), this.getLineNumber(), index);
                    }
                    return;
                }
            }
            this.append(c);
        }
    }

    class TomlInlineTable
    extends TomlValue {
        final Key metaKey;
        final Value metaValue;
        int bracketLevel;

        TomlInlineTable(Value parent) {
            super(parent);
            this.metaKey = new Key();
            this.metaValue = new Value(null);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            if (this.metaKey.building) {
                this.metaKey.end(line, lineNumber, index);
            }
            if (this.metaValue.building) {
                this.metaValue.end(line, lineNumber, index);
            }
            this.getReader().endInlineTable(this.getLine(), this.getLineNumber(), index);
            this.bracketLevel = 0;
            this.reset();
        }

        @Override
        boolean checkValueEnd(Value value, char c, int index) throws TomlParsingException {
            if (TomlParser.isCharNewLine(c) || !this.isQuoting() && c == '}') {
                this.end(this.getLine(), this.getLineNumber(), index);
                return true;
            }
            if (this.metaKey.building) {
                this.metaKey.checkEnd(c, index);
            }
            return false;
        }

        @Override
        boolean checkStart(char c, int index) throws TomlParsingException {
            if (c == '{') {
                if (this.last == '\u0000') {
                    this.getReader().startInlineTable(this.getLine(), this.getLineNumber(), index);
                }
                return true;
            }
            return false;
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            if (TomlParser.isCharNewLine(c)) {
                TomlParser.doThrow("Inline tables do not support line breaks", this.getLine(), this.getLineNumber(), index);
            }
            if (!this.metaKey.built) {
                if (!this.metaKey.building && this.metaKey.checkStart(c, index)) {
                    this.metaKey.building = true;
                }
                if (this.metaKey.building) {
                    this.metaKey.step(c, index);
                }
            } else {
                if (!this.metaValue.building && this.metaValue.checkStart(c, index)) {
                    this.metaValue.building = true;
                }
                if (this.metaValue.building) {
                    this.metaValue.step(c, index);
                }
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    this.quoting = this.quoting == c ? (char)'\u0000' : c;
                    break;
                }
                case '[': {
                    if (this.isQuoting()) break;
                    ++this.bracketLevel;
                    break;
                }
                case ']': {
                    if (this.isQuoting()) break;
                    if (this.bracketLevel == 0) {
                        TomlParser.doThrow("Unexpected closing bracket", this.getLine(), this.getLineNumber(), index);
                        break;
                    }
                    --this.bracketLevel;
                    break;
                }
                case ',': {
                    if (this.isQuoting() || this.bracketLevel != 0) break;
                    if (this.metaValue.building) {
                        this.metaValue.end(this.getLine(), this.getLineNumber(), index);
                        this.metaKey.built = false;
                        break;
                    }
                    TomlParser.doThrow("Unassigned key", this.getLine(), this.getLineNumber(), index);
                }
            }
        }
    }

    class TomlBoolean
    extends TomlValue {
        TomlBoolean(Value parent) {
            super(parent);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            this.getReader().endBoolean(this.getLastBuilder().toString(), line, lineNumber, index);
            this.reset();
        }

        @Override
        boolean checkValueEnd(Value value, char c, int index) {
            return TomlParser.isCharNewLine(c);
        }

        @Override
        boolean checkStart(char c, int index) {
            return c == 'f' || c == 't';
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            if (TomlParser.isCharBool(c)) {
                this.append(c);
            } else if (!Character.isWhitespace(c)) {
                TomlParser.doThrow("Illegal boolean character", this.getLine(), this.getLineNumber(), index);
            }
        }
    }

    class TomlArray
    extends TomlValue {
        TomlValue metaValue;

        TomlArray(Value parent) {
            super(parent);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            if (Objects.nonNull(this.metaValue)) {
                this.metaValue.end(line, lineNumber, index);
            }
            this.metaValue = null;
            this.getReader().endArray(line, this.getLineNumber(), index);
            this.reset();
        }

        @Override
        boolean checkValueEnd(Value value, char c, int index) throws TomlParsingException {
            if (Objects.nonNull(this.metaValue)) {
                if (this.metaValue.isQuoting()) {
                    return this.metaValue.checkValueEnd(value, c, index);
                }
                if (c == ' ' || TomlParser.isCharNewLine(c)) {
                    this.metaValue.end(this.getLine(), this.getLineNumber(), index);
                    this.metaValue = null;
                    return false;
                }
            }
            return c == ']';
        }

        @Override
        boolean checkStart(char c, int index) throws TomlParsingException {
            if (c == '[') {
                if (Objects.isNull(this.metaValue)) {
                    this.getReader().startArray(this.getLine(), this.getLineNumber(), index);
                }
                return true;
            }
            return false;
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            if (this.last == '\u0000') {
                this.pushLast(c);
            } else if (Objects.nonNull(this.metaValue)) {
                this.metaValue.step(c, index);
            } else {
                for (TomlValue value : this.parent.TYPES) {
                    if (!value.checkStart(c, index)) continue;
                    if (value instanceof TomlArray) {
                        this.metaValue = new TomlArray(this.parent);
                        break;
                    }
                    if (value instanceof TomlBoolean) {
                        this.metaValue = new TomlBoolean(this.parent);
                        break;
                    }
                    if (value instanceof TomlInlineTable) {
                        this.metaValue = new TomlInlineTable(this.parent);
                        break;
                    }
                    if (value instanceof TomlNumber) {
                        this.metaValue = new TomlNumber(this.parent);
                        break;
                    }
                    this.metaValue = new TomlString(this.parent);
                    break;
                }
                if (Objects.nonNull(this.metaValue)) {
                    this.metaValue.step(c, index);
                }
            }
        }
    }

    abstract class TomlValue
    extends Root {
        Value parent;

        TomlValue(Value parent) {
            this.parent = parent;
        }

        @Override
        void checkEnd(char c, int index) {
        }

        abstract boolean checkValueEnd(Value var1, char var2, int var3) throws TomlParsingException;
    }

    class Value
    extends Root {
        final Entry parent;
        final List<TomlValue> TYPES;
        TomlValue type;

        Value(Entry parent) {
            this.parent = parent;
            this.TYPES = Objects.isNull(parent) ? Collections.emptyList() : Arrays.asList(new TomlArray(this), new TomlBoolean(this), new TomlInlineTable(this), new TomlNumber(this), new TomlString(this));
        }

        @Override
        void checkEnd(char c, int index) throws TomlParsingException {
            if (Objects.nonNull(this.type)) {
                if (this.type.checkValueEnd(this, c, index)) {
                    this.parent.end(this.getLine(), this.getLineNumber(), index);
                }
            } else if (TomlParser.isCharNewLine(c)) {
                TomlParser.doThrow("Undefined value", this.getLine(), this.getLineNumber(), index);
            }
        }

        @Override
        boolean checkStart(char c, int index) throws TomlParsingException {
            for (TomlValue value : this.TYPES) {
                if (!value.checkStart(c, index)) continue;
                this.type = value;
                return true;
            }
            return false;
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            if (Objects.nonNull(this.type)) {
                this.type.end(line, lineNumber, index);
            }
            this.type = null;
            this.reset();
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            this.type.step(c, index);
        }
    }

    class Key
    extends Root {
        boolean built;

        Key() {
        }

        @Override
        void checkEnd(char c, int index) throws TomlParsingException {
            if (!this.isQuoting() && c == '=') {
                this.end(this.getLine(), this.getLineNumber(), index);
            }
        }

        @Override
        boolean checkStart(char c, int index) {
            return c == '\'' || c == '\"' || TomlParser.isCharKey(c);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            TomlParser.parseKey(this.getReader(), this.builders, line, lineNumber, index);
            this.built = true;
            this.reset();
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            switch (c) {
                case '\"': 
                case '\'': {
                    this.append(c);
                    this.quoting = this.quoting == c ? (char)'\u0000' : c;
                    return;
                }
                case '.': {
                    this.pushBuild();
                    break;
                }
                default: {
                    if (TomlParser.isCharNewLine(c)) {
                        TomlParser.doThrow("Unassigned key", this.getLine(), this.getLineNumber(), index);
                    }
                    if (this.isQuoting() || TomlParser.isCharKey(c)) {
                        this.append(c);
                    } else {
                        if (Character.isWhitespace(c)) {
                            return;
                        }
                        TomlParser.doThrow("Illegal key character", this.getLine(), this.getLineNumber(), index);
                    }
                    return;
                }
            }
            this.pushLast(c);
        }
    }

    class Entry
    extends Root {
        final Key key;
        final Value value;

        Entry() {
            this.key = new Key();
            this.value = new Value(this);
        }

        @Override
        void checkEnd(char c, int index) throws TomlParsingException {
            if (!this.key.built) {
                this.key.checkEnd(c, index);
            } else if (this.value.building) {
                this.value.checkEnd(c, index);
            }
        }

        @Override
        boolean checkStart(char c, int index) {
            return this.key.checkStart(c, index);
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            if (!this.key.built) {
                TomlParser.doThrow("Unterminated key", line, lineNumber, index);
            }
            this.value.end(line, lineNumber, index);
            this.key.built = false;
            this.reset();
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            if (!this.key.built) {
                this.key.step(c, index);
            } else if (this.value.building || this.value.checkStart(c, index)) {
                this.value.building = true;
            }
            if (this.value.building) {
                this.value.step(c, index);
            }
        }
    }

    class Table
    extends Root {
        boolean array;

        Table() {
        }

        @Override
        void checkEnd(char c, int index) throws TomlParsingException {
            if (!(this.isQuoting() || c != ']' || this.array && this.last != ']')) {
                this.end(this.getLine(), this.getLineNumber(), index);
            }
        }

        @Override
        boolean checkStart(char c, int index) {
            return c == '[';
        }

        @Override
        void end(String line, int lineNumber, int index) throws TomlParsingException {
            TomlParser.parseTable(this.getReader(), this.array, this.builders, line, lineNumber, index);
            this.array = false;
            this.reset();
        }

        @Override
        void step(char c, int index) throws TomlParsingException {
            switch (c) {
                case '[': {
                    if (this.last == '\u0000') break;
                    if (this.last == '[' && this.beforeLast != '[') {
                        this.array = true;
                        break;
                    }
                    TomlParser.doThrow("Illegal table character", this.getLine(), this.getLineNumber(), index);
                }
                case ']': {
                    break;
                }
                case '\"': 
                case '\'': {
                    this.append(c);
                    this.quoting = this.quoting == c ? (char)'\u0000' : c;
                    return;
                }
                case '.': {
                    this.pushBuild();
                    break;
                }
                default: {
                    if (TomlParser.isCharNewLine(c)) {
                        TomlParser.doThrow("Unterminated table", this.getLine(), this.getLineNumber(), index);
                    }
                    if (this.isQuoting() || TomlParser.isCharTable(c)) {
                        this.append(c);
                    } else {
                        if (Character.isWhitespace(c)) {
                            return;
                        }
                        TomlParser.doThrow("Illegal table character", this.getLine(), this.getLineNumber(), index);
                    }
                    return;
                }
            }
            this.pushLast(c);
        }
    }

    class Comment
    extends Root {
        Comment() {
        }

        @Override
        void checkEnd(char c, int index) {
            if (TomlParser.isCharNewLine(c)) {
                this.end(this.getLine(), this.getLineNumber(), index);
            }
        }

        @Override
        boolean checkStart(char c, int index) {
            return c == '#';
        }

        @Override
        void end(String line, int lineNumber, int index) {
            this.getReader().endComment(this.getLastBuilder().toString());
            this.reset();
        }

        @Override
        void step(char c, int index) {
            if (this.last != '\u0000') {
                this.append(c);
            } else {
                this.pushLast(c);
            }
        }
    }

    abstract class Root {
        final List<StringBuilder> builders = new ArrayList<StringBuilder>();
        char last = '\u0000';
        char beforeLast = '\u0000';
        boolean building;
        char quoting = '\u0000';

        Root() {
            this.pushBuild();
        }

        void append(char c) {
            if (TomlParser.isCharNewLine(c)) {
                return;
            }
            this.getLastBuilder().append(c);
            this.pushLast(c);
        }

        @IndirectCallers
        abstract void checkEnd(char var1, int var2) throws TomlParsingException;

        abstract boolean checkStart(char var1, int var2) throws TomlParsingException;

        abstract void end(String var1, int var2, int var3) throws TomlParsingException;

        StringBuilder getLastBuilder() {
            return this.builders.get(this.builders.size() - 1);
        }

        String getLine() {
            return TomlToken.this.lineBuilder.toString();
        }

        int getLineNumber() {
            return TomlToken.this.lineNumber;
        }

        TomlReader getReader() {
            return TomlToken.this.reader;
        }

        boolean isQuoting() {
            return this.quoting == '\'' || this.quoting == '\"';
        }

        void pushBuild() {
            this.builders.add(new StringBuilder());
        }

        void pushLast(char c) {
            this.beforeLast = this.last;
            this.last = c;
        }

        void reset() {
            this.builders.clear();
            this.last = '\u0000';
            this.beforeLast = '\u0000';
            this.quoting = '\u0000';
            this.building = false;
            this.pushBuild();
        }

        abstract void step(char var1, int var2) throws TomlParsingException;
    }
}

