/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.toml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParsingException;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlReader;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlToken;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Patterns;

public class TomlParser {
    static void doThrow(String msg, String line, int lineNumber, int index) throws TomlParsingException {
        throw new TomlParsingException(msg + " -> [" + lineNumber + "] " + line, index);
    }

    public static boolean isCharBinary(char c) {
        return Misc.equalsAny(Character.valueOf(c), Character.valueOf('_'), Character.valueOf('0'), Character.valueOf('1'));
    }

    public static boolean isCharBool(char c) {
        return Misc.equalsAny(Character.valueOf(c), Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('l'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'));
    }

    public static boolean isCharFloat(char c) {
        return TomlParser.isCharInt(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('.'), Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('i'), Character.valueOf('n'));
    }

    public static boolean isCharHex(char c) {
        return Character.isDigit(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('_'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('E'));
    }

    public static boolean isCharInt(char c) {
        return Character.isDigit(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('+'), Character.valueOf('_'), Character.valueOf('-'));
    }

    public static boolean isCharKey(char c) {
        return !Character.isWhitespace(c) && (Character.isDigit(c) || Character.isAlphabetic(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('_'), Character.valueOf('-')));
    }

    public static boolean isCharNewLine(char c) {
        return !String.valueOf(c).matches(".");
    }

    public static boolean isCharNumber(char c) {
        return TomlParser.isCharFloat(c) || TomlParser.isCharInt(c) || TomlParser.isCharSpecialInt(c);
    }

    public static boolean isCharOctal(char c) {
        return Misc.equalsAny(Character.valueOf(c), Character.valueOf('_'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'));
    }

    public static boolean isCharSpecialInt(char c) {
        return TomlParser.isCharBinary(c) || TomlParser.isCharHex(c) || TomlParser.isCharOctal(c);
    }

    public static boolean isCharTable(char c) {
        return TomlParser.isCharKey(c) || Misc.equalsAny(Character.valueOf(c), Character.valueOf('.'));
    }

    public static int parseBinary(String unparsed, String line, int lineNumber, int index) throws TomlParsingException {
        try {
            return Integer.parseInt(unparsed.substring(2), 2);
        }
        catch (NumberFormatException ex) {
            TomlParser.doThrow("Failed to parse binary value `" + ex.getMessage() + "`", line, lineNumber, index);
            return 0;
        }
    }

    public static int parseHex(String unparsed, String line, int lineNumber, int index) throws TomlParsingException {
        try {
            return (int)Long.parseLong(unparsed.substring(2), 16);
        }
        catch (NumberFormatException ex) {
            TomlParser.doThrow("Failed to parse hex value `" + ex.getMessage() + "`", line, lineNumber, index);
            return 0;
        }
    }

    public static void parseKey(TomlReader reader, Collection<StringBuilder> builders, String line, int lineNumber, int index) throws TomlParsingException {
        String name = null;
        ArrayList<String> path = new ArrayList<String>();
        int i = 0;
        for (StringBuilder builder : builders) {
            String built = builder.toString();
            if (Patterns.isEncapsulatedBy(built, '\'') || Patterns.isEncapsulatedBy(built, '\"')) {
                built = built.substring(1, built.length() - 1);
            }
            if (i < builders.size() - 1) {
                path.add(built);
                continue;
            }
            name = built;
        }
        if (Objects.isNull(name)) {
            TomlParser.doThrow("Failed to parse key", line, lineNumber, index);
        }
        Collections.reverse(path);
        reader.endKey(path, name, line, lineNumber, index);
    }

    public static void parseNumber(TomlReader reader, String unparsed, TomlToken.NumberType type, String line, int lineNumber, int index) throws TomlParsingException {
        if (Objects.isNull((Object)type)) {
            reader.endInt(unparsed, line, lineNumber, index);
            return;
        }
        switch (type) {
            case BINARY: {
                reader.endInt(TomlParser.parseBinary(unparsed, line, lineNumber, index), line, lineNumber, index);
                break;
            }
            case FLOAT: {
                reader.endFloat(unparsed, line, lineNumber, index);
                break;
            }
            case HEXADECIMAL: {
                reader.endInt(TomlParser.parseHex(unparsed, line, lineNumber, index), line, lineNumber, index);
                break;
            }
            case OCTAL: {
                reader.endInt(TomlParser.parseOctal(unparsed, line, lineNumber, index), line, lineNumber, index);
                break;
            }
            default: {
                TomlParser.doThrow("Unknown number type " + (Object)((Object)type), line, lineNumber, index);
            }
        }
    }

    public static int parseOctal(String unparsed, String line, int lineNumber, int index) throws TomlParsingException {
        try {
            return Integer.parseInt(unparsed.substring(2), 8);
        }
        catch (NumberFormatException ex) {
            TomlParser.doThrow("Failed to parse octal value `" + ex.getMessage() + "`", line, lineNumber, index);
            return 0;
        }
    }

    public static void parseTable(TomlReader reader, boolean array, Collection<StringBuilder> builders, String line, int lineNumber, int index) throws TomlParsingException {
        ArrayList<String> names = new ArrayList<String>();
        for (StringBuilder builder : builders) {
            String built = builder.toString();
            if (Patterns.isEncapsulatedBy(built, '\'') || Patterns.isEncapsulatedBy(built, '\"')) {
                built = built.substring(1, built.length() - 1);
            }
            names.add(built);
        }
        if (array) {
            reader.endTableArray(names, line, lineNumber, index);
        } else {
            reader.endTable(names, line, lineNumber, index);
        }
    }
}

