/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.toml;

import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.io.FileHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.io.IOUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.ParameterHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlParsingException;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlReader;
import mods.thecomputerizer.theimpossiblelibrary.api.toml.TomlWritingException;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Matching;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Sorting;
import org.jetbrains.annotations.Nullable;

public class Toml {
    private String name;
    private final Map<String, Toml[]> tables;
    private final Map<String, TomlEntry<?>> entries;
    private String[] comments;
    private Toml parent;
    private Sorting[] sorters;

    public static Toml getEmpty() {
        return new Toml("root");
    }

    public static Toml readBuf(ByteBuf buf) throws TomlParsingException {
        return Toml.readString(NetworkHelper.readString(buf));
    }

    public static Toml readFile(File file) throws TomlParsingException, IOException {
        return Toml.readFile(file, new TomlReader());
    }

    public static Toml readFile(File file, TomlReader reader) throws IOException, TomlParsingException {
        try (FileInputStream stream = new FileInputStream(file);){
            Toml toml = Toml.readStream(stream, reader);
            return toml;
        }
    }

    public static Toml readFile(String filePath) throws TomlParsingException, IOException {
        return Toml.readFile(filePath, new TomlReader());
    }

    public static Toml readFile(String filePath, TomlReader reader) throws TomlParsingException, IOException {
        try (FileInputStream stream = new FileInputStream(filePath);){
            TILDev.logInfo("Reading toml from file path {}", filePath);
            Toml toml = Toml.readStream(stream, reader);
            return toml;
        }
    }

    public static Toml readLines(Iterable<String> lines) throws TomlParsingException {
        return Toml.readLines(lines, new TomlReader());
    }

    public static Toml readLines(Iterable<String> lines, TomlReader reader) throws TomlParsingException {
        return Toml.readString(TextHelper.fromIterable(lines), reader);
    }

    public static Toml readPath(Path path, OpenOption ... options) throws TomlParsingException, IOException {
        return Toml.readPath(path, new TomlReader(), options);
    }

    public static Toml readPath(Path path, TomlReader reader, OpenOption ... options) throws IOException, TomlParsingException {
        try (InputStream stream = Files.newInputStream(path, options);){
            Toml toml = Toml.readStream(stream, reader);
            return toml;
        }
    }

    public static Toml readStream(InputStream stream) throws IOException, TomlParsingException {
        return Toml.readStream(stream, new TomlReader());
    }

    public static Toml readStream(InputStream stream, TomlReader reader) throws IOException, TomlParsingException {
        return Toml.readString(IOUtils.streamToString(stream), reader);
    }

    public static Toml readString(String tomlString) throws TomlParsingException {
        return Toml.readString(tomlString, new TomlReader());
    }

    public static Toml readString(String tomlString, TomlReader reader) throws TomlParsingException {
        reader.read(tomlString);
        return new Toml(reader.rootBuilder, "root");
    }

    public static Toml readURI(URI uri, OpenOption ... options) throws TomlParsingException, IOException {
        return Toml.readURI(uri, new TomlReader(), options);
    }

    public static Toml readURI(URI uri, TomlReader reader, OpenOption ... options) throws TomlParsingException, IOException {
        return Toml.readPath(FileHelper.toPath(uri), reader, options);
    }

    public static Toml readURL(URL url) throws TomlParsingException, IOException {
        return Toml.readURL(url, new TomlReader());
    }

    public static Toml readURL(URL url, TomlReader reader) throws IOException, TomlParsingException {
        try (InputStream stream = url.openStream();){
            Toml toml = Toml.readStream(stream, reader);
            return toml;
        }
    }

    Toml(String name) {
        this(null, name);
    }

    Toml(@Nullable TomlReader.TableBuilder builder, String name) {
        this.name = name;
        this.entries = new LinkedHashMap();
        this.tables = new LinkedHashMap<String, Toml[]>();
        this.comments = new String[0];
        if (Objects.nonNull(builder)) {
            this.setRootEntries(builder.entries);
            this.setTables(builder.tables);
            this.setComments(builder.tableComments, builder.entryComments);
        }
    }

    Toml(ByteBuf buf) {
        this.name = NetworkHelper.readString(buf);
        boolean comments = buf.readBoolean();
        this.tables = NetworkHelper.readMapEntries(buf, () -> {
            String name = NetworkHelper.readString(buf);
            return IterableHelper.getMapEntry(name, NetworkHelper.readList(buf, () -> {
                Toml table = new Toml(buf);
                table.parent = this;
                return table;
            }).toArray(new Toml[0]));
        });
        this.entries = NetworkHelper.readMapEntries(buf, () -> {
            String key = NetworkHelper.readString(buf);
            return IterableHelper.getMapEntry(key, new TomlEntry(key, buf, comments));
        });
        this.comments = comments ? NetworkHelper.readList(buf, () -> NetworkHelper.readString(buf)).toArray(new String[0]) : new String[]{};
    }

    public void addComment(String comment) {
        if (TextHelper.isNotEmpty(comment)) {
            this.comments = ArrayHelper.append(this.comments, comment, true);
        }
    }

    public void addComments(Iterable<String> comments) {
        for (String comment : comments) {
            this.addComment(comment);
        }
    }

    public void addComments(String ... comments) {
        for (String comment : comments) {
            this.addComment(comment);
        }
    }

    public <V> TomlEntry<V> addEntry(String key, V value) {
        TomlEntry<V> entry = new TomlEntry<V>(key, value);
        this.addEntry(entry);
        return entry;
    }

    public <V> void addEntry(@Nullable TomlEntry<V> entry) {
        if (Objects.nonNull(entry)) {
            this.entries.put(entry.getKey(), entry);
        }
    }

    public void addEntryComment(String key, String comment) {
        TomlEntry<?> entry = this.getEntry(key);
        if (Objects.nonNull(entry)) {
            entry.addComment(comment);
        } else {
            TILRef.logWarn("Tried to add comment to non existent entry {} (comment -> `{}`)", key, comment);
        }
    }

    public void addEntryComments(String key, Iterable<String> comments) {
        TomlEntry<?> entry = this.getEntry(key);
        if (Objects.nonNull(entry)) {
            for (String comment : comments) {
                entry.addComment(comment);
            }
        } else {
            TILRef.logWarn("Tried to add {} comments to non existent entry {}", IterableHelper.count(comments), key);
        }
    }

    public void addEntryComments(String key, String ... comments) {
        TomlEntry<?> entry = this.getEntry(key);
        if (Objects.nonNull(entry)) {
            for (String comment : comments) {
                entry.addComment(comment);
            }
        } else {
            TILRef.logWarn("Tried to add {} comments to non existent entry {}", comments.length, key);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Toml addTable(String name, boolean array) throws TomlWritingException {
        Toml toml = new Toml(name);
        Toml[] tomls = this.tables.get(name);
        if (Objects.nonNull(tomls)) {
            if (!array) throw new TomlWritingException("Cannot add table [" + name + "] that already exists");
            ArrayHelper.append(tomls, toml, true);
        } else {
            this.tables.put(name, new Toml[]{toml});
        }
        toml.parent = this;
        return toml;
    }

    public void addTable(String name, Toml table) {
        table.name = name;
        this.tables.put(name, ArrayHelper.append((Object[])this.tables.get(name), table, true));
        table.parent = this;
    }

    public void clear() {
        this.clear(true, true, true);
    }

    public void clear(boolean tables) {
        this.clear(true, true, tables);
    }

    public void clear(boolean entries, boolean tables) {
        this.clear(true, entries, tables);
    }

    public void clear(boolean comments, boolean entries, boolean tables) {
        if (!(comments || entries || tables)) {
            TILRef.logInfo("Toml#clear called but comments, entries, & tables are all false? Nothing will be cleared", new Object[0]);
            return;
        }
        if (comments) {
            this.clearAllComments();
        }
        if (entries) {
            this.clearAllEntries();
        }
        if (tables) {
            this.clearAllTables();
        }
    }

    public void clearAllComments() {
        this.clearComments();
        this.clearAllEntryComments();
    }

    public void clearAllEntries() {
        this.entries.clear();
    }

    public void clearAllEntryComments() {
        for (TomlEntry<?> entry : this.entries.values()) {
            entry.clearComments();
        }
    }

    public void clearAllTables() {
        this.tables.clear();
    }

    public void clearAnyMatching(String toMatch, Matching ... matchers) {
        this.clearAnyMatching(toMatch, true, true, true, matchers);
    }

    public void clearAnyMatching(String toMatch, boolean tables, Matching ... matchers) {
        this.clearAnyMatching(toMatch, true, true, tables, matchers);
    }

    public void clearAnyMatching(String toMatch, boolean entries, boolean tables, Matching ... matchers) {
        this.clearAnyMatching(toMatch, true, entries, tables, matchers);
    }

    public void clearAnyMatching(String toMatch, boolean comments, boolean entries, boolean tables, Matching ... matchers) {
        if (!(comments || entries || tables)) {
            TILRef.logInfo("Toml#clearAnyMatching called but comments, entries, & tables are all false? Nothing will be cleared", new Object[0]);
            return;
        }
        if (comments) {
            this.clearAnyCommentsMatching(toMatch, matchers);
        }
        if (entries) {
            this.clearEntriesMatching(toMatch, matchers);
        }
        if (tables) {
            this.clearTablesMatching(toMatch, matchers);
        }
    }

    public void clearAnyCommentsMatching(String toMatch, Matching ... matchers) {
        this.clearCommentsMatching(toMatch, matchers);
        for (TomlEntry<?> entry : this.entries.values()) {
            entry.clearCommentsMatching(toMatch, matchers);
        }
    }

    public void clearComments() {
        this.comments = new String[0];
    }

    public void clearCommentsMatching(String toMatch, Matching ... matchers) {
        this.comments = ArrayHelper.removeMatching(this.comments, toMatch, comment -> Matching.matchesAny(comment, toMatch, matchers));
    }

    public void clearEntriesMatching(String toMatch, Matching ... matchers) {
        Set<String> removals = Matching.matchingValuesAny(this.entries.keySet(), toMatch, matchers);
        for (String removal : removals) {
            this.entries.remove(removal);
        }
    }

    public void clearEntryCommentsMatching(String key, String toMatch, Matching ... matchers) {
        TomlEntry<?> entry = this.getEntry(key);
        if (Objects.nonNull(entry)) {
            entry.clearCommentsMatching(toMatch, matchers);
        }
    }

    public void clearEntryComments(String key) {
        TomlEntry<?> entry = this.getEntry(key);
        if (Objects.nonNull(entry)) {
            entry.clearComments();
        }
    }

    public void clearTablesMatching(String toMatch, Matching ... matchers) {
        Set<String> removals = Matching.matchingValuesAny(this.tables.keySet(), toMatch, matchers);
        for (String removal : removals) {
            this.tables.remove(removal);
        }
    }

    public Collection<TomlEntry<?>> getAllEntries() {
        return this.entries.values();
    }

    public List<Toml> getAllTables() {
        ArrayList<Toml> tables = new ArrayList<Toml>();
        for (Toml[] tomls : this.tables.values()) {
            tables.addAll(Arrays.asList(tomls));
        }
        return Collections.unmodifiableList(tables);
    }

    public TomlEntry<?> getEntry(String name) {
        return this.entries.getOrDefault(name, null);
    }

    public TomlEntry<List<?>> getEntryArray(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof List ? entry : null;
    }

    public TomlEntry<Boolean> getEntryBool(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof Boolean ? entry : null;
    }

    public TomlEntry<Float> getEntryFloat(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof Float ? entry : null;
    }

    public TomlEntry<Integer> getEntryInt(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof Integer ? entry : null;
    }

    public TomlEntry<Number> getEntryNumber(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof Number ? entry : null;
    }

    public TomlEntry<String> getEntryString(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) && ((TomlEntry)entry).value instanceof String ? entry : null;
    }

    public Map<String, Object> getEntryValuesAsMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (TomlEntry<?> entry : this.entries.values()) {
            map.put(((TomlEntry)entry).key, ((TomlEntry)entry).value);
        }
        return map;
    }

    public <T> Optional<T> getOptional(String name) {
        TomlEntry<?> entry = this.getEntry(name);
        return Objects.nonNull(entry) ? Optional.of(((TomlEntry)entry).value) : Optional.empty();
    }

    public <T> Optional<T> getOptional(String name, @Nullable T defVal) {
        TomlEntry<?> entry = this.getEntry(name);
        return Optional.ofNullable(Objects.nonNull(entry) ? ((TomlEntry)entry).value : defVal);
    }

    public Optional<List<?>> getOptionalArray(String name) {
        TomlEntry<List<?>> entry = this.getEntryArray(name);
        return Objects.nonNull(entry) ? Optional.of(((TomlEntry)entry).value) : Optional.empty();
    }

    public Optional<List<?>> getOptionalArray(String name, @Nullable List<?> defVal) {
        TomlEntry<List<?>> entry = this.getEntryArray(name);
        return Optional.ofNullable(Objects.nonNull(entry) ? (List)((TomlEntry)entry).value : defVal);
    }

    public Optional<Boolean> getOptionalBool(String name) {
        TomlEntry<Boolean> entry = this.getEntryBool(name);
        return Objects.nonNull(entry) ? Optional.of(((TomlEntry)entry).value) : Optional.empty();
    }

    public Optional<Boolean> getOptionalBool(String name, boolean defVal) {
        TomlEntry<Boolean> entry = this.getEntryBool(name);
        return Optional.of(Objects.nonNull(entry) ? (Boolean)((TomlEntry)entry).value : defVal);
    }

    public Optional<Byte> getOptionalByte(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(number.byteValue()) : Optional.empty();
    }

    public Optional<Byte> getOptionalByte(String name, byte defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Objects.nonNull(number) ? number.byteValue() : defVal);
    }

    public Optional<Double> getOptionalDouble(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(number.doubleValue()) : Optional.empty();
    }

    public Optional<Double> getOptionalDouble(String name, double defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Objects.nonNull(number) ? number.doubleValue() : defVal);
    }

    public Optional<Float> getOptionalFloat(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(Float.valueOf(number.floatValue())) : Optional.empty();
    }

    public Optional<Float> getOptionalFloat(String name, float defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Float.valueOf(Objects.nonNull(number) ? number.floatValue() : defVal));
    }

    public Optional<Integer> getOptionalInt(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(number.intValue()) : Optional.empty();
    }

    public Optional<Integer> getOptionalInt(String name, int defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Objects.nonNull(number) ? number.intValue() : defVal);
    }

    public Optional<Long> getOptionalLong(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(number.longValue()) : Optional.empty();
    }

    public Optional<Long> getOptionalLong(String name, long defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Objects.nonNull(number) ? number.longValue() : defVal);
    }

    public Optional<Number> getOptionalNumber(String name) {
        return Optional.ofNullable(this.getValueNumber(name));
    }

    public Optional<Number> getOptionalNumber(String name, @Nullable Number defVal) {
        Number number = this.getValueNumber(name);
        return Optional.ofNullable(Objects.nonNull(number) ? (Number)number : (Number)defVal);
    }

    public Optional<Short> getOptionalShort(String name) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? Optional.of(number.shortValue()) : Optional.empty();
    }

    public Optional<Short> getOptionalShort(String name, short defVal) {
        Number number = this.getValueNumber(name);
        return Optional.of(Objects.nonNull(number) ? number.shortValue() : defVal);
    }

    public Optional<String> getOptionalString(String name) {
        TomlEntry<String> entry = this.getEntryString(name);
        return Objects.nonNull(entry) ? Optional.of(((TomlEntry)entry).value) : Optional.empty();
    }

    public Optional<String> getOptionalString(String name, @Nullable String defVal) {
        TomlEntry<String> entry = this.getEntryString(name);
        return Optional.ofNullable(Objects.nonNull(entry) ? (String)((TomlEntry)entry).value : defVal);
    }

    public Optional<Toml> getOptionalTable(String name) {
        Toml[] tomls = this.tables.get(name);
        return ArrayHelper.isNotEmpty(tomls) ? Optional.of(tomls[0]) : Optional.empty();
    }

    public Optional<Toml> getOptionalTable(String name, @Nullable Toml defVal) {
        Toml[] tomls = this.tables.get(name);
        return Optional.ofNullable(ArrayHelper.isNotEmpty(tomls) ? tomls[0] : defVal);
    }

    public Optional<Toml[]> getOptionalTables(String name) {
        Toml[] tomls = this.tables.get(name);
        return Optional.of(ArrayHelper.isNotEmpty(tomls) ? tomls : new Toml[]{});
    }

    public Optional<Toml[]> getOptionalTables(String name, @Nullable Toml[] defVal) {
        Toml[] tomls = this.tables.get(name);
        return Optional.ofNullable(ArrayHelper.isNotEmpty(tomls) ? tomls : defVal);
    }

    public <V> V getOrSetValue(String key, V def) {
        return (V)(this.hasEntry(key) ? this.getValue(key) : ((TomlEntry)this.addEntry(key, def)).value);
    }

    public String getPath() {
        if ("root".equals(this.name)) {
            return "";
        }
        String path = Objects.nonNull(this.parent) ? this.parent.getPath() : "";
        return path.isEmpty() ? TomlHelper.encapsulateTableName(this.name) : path + "." + TomlHelper.encapsulateTableName(this.name);
    }

    public Toml getTable(String name) {
        Toml[] tomls = this.tables.get(name);
        return ArrayHelper.isNotEmpty(tomls) ? tomls[0] : null;
    }

    public Toml[] getTableArray(String name) {
        return this.tables.get(name);
    }

    public <T> T getValue(String name) {
        return this.getValue(name, null);
    }

    public <T> T getValue(String name, @Nullable T defVal) {
        TomlEntry<?> entry = this.getEntry(name);
        return (T)(Objects.nonNull(entry) ? ((TomlEntry)entry).value : defVal);
    }

    public List<?> getValueArray(String name) {
        return this.getValueArray(name, null);
    }

    public List<?> getValueArray(String name, @Nullable List<?> defVal) {
        TomlEntry<List<?>> entry = this.getEntryArray(name);
        return Objects.nonNull(entry) ? (List)((TomlEntry)entry).value : defVal;
    }

    public List<?> getValueArrayOrEmpty(String name) {
        return this.getValueArray(name, new ArrayList());
    }

    public boolean getValueBool(String name) {
        return this.getValueBool(name, false);
    }

    public boolean getValueBool(String name, boolean defVal) {
        TomlEntry<Boolean> entry = this.getEntryBool(name);
        return Objects.nonNull(entry) ? (Boolean)((TomlEntry)entry).value : defVal;
    }

    public byte getValueByte(String name) {
        return this.getValueByte(name, (byte)0);
    }

    public byte getValueByte(String name, byte defVal) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? number.byteValue() : defVal;
    }

    public double getValueDouble(String name) {
        return this.getValueDouble(name, 0.0);
    }

    public double getValueDouble(String name, double defVal) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? number.doubleValue() : defVal;
    }

    public float getValueFloat(String name) {
        return this.getValueFloat(name, 0.0f);
    }

    public float getValueFloat(String name, float defVal) {
        TomlEntry<Float> entry = this.getEntryFloat(name);
        return Objects.nonNull(entry) ? ((Float)((TomlEntry)entry).value).floatValue() : defVal;
    }

    public int getValueInt(String name) {
        return this.getValueInt(name, 0);
    }

    public int getValueInt(String name, int defVal) {
        TomlEntry<Integer> entry = this.getEntryInt(name);
        return Objects.nonNull(entry) ? (Integer)((TomlEntry)entry).value : defVal;
    }

    public long getValueLong(String name) {
        return this.getValueLong(name, 0L);
    }

    public long getValueLong(String name, long defVal) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? number.longValue() : defVal;
    }

    public Number getValueNumber(String name) {
        return this.getValueNumber(name, null);
    }

    public Number getValueNumber(String name, @Nullable Number defVal) {
        TomlEntry<Number> entry = this.getEntryNumber(name);
        return Objects.nonNull(entry) ? (Number)((Number)((TomlEntry)entry).value) : (Number)defVal;
    }

    public short getValueShort(String name) {
        return this.getValueShort(name, (short)0);
    }

    public short getValueShort(String name, short defVal) {
        Number number = this.getValueNumber(name);
        return Objects.nonNull(number) ? number.shortValue() : defVal;
    }

    public String getValueString(String name) {
        return this.getValueString(name, null);
    }

    public String getValueString(String name, @Nullable String defVal) {
        TomlEntry<String> entry = this.getEntryString(name);
        return Objects.nonNull(entry) ? (String)((TomlEntry)entry).value : defVal;
    }

    public boolean hasEntry(String name) {
        return this.entries.containsKey(name);
    }

    public boolean hasTable(String name) {
        return this.tables.containsKey(name);
    }

    public Map<String, Parameter<?>> parameterizeEntries() {
        LinkedHashMap map = new LinkedHashMap();
        for (TomlEntry<?> entry : this.entries.values()) {
            map.put(((TomlEntry)entry).key, entry.parameterize());
        }
        return map;
    }

    public void removeTables(String name) {
        this.removeTable(name, -1);
    }

    public void removeTable(String name, int index) {
        if (index == -1) {
            this.tables.remove(name);
        } else {
            Toml[] tomls = (Toml[])ArrayHelper.removeElement((Object[])this.tables.get(name), index);
            if (Objects.isNull(tomls)) {
                return;
            }
            if (tomls.length == 0) {
                this.tables.remove(name);
            } else {
                this.tables.put(name, tomls);
            }
        }
    }

    public void removeEntry(String name) {
        this.entries.remove(name);
    }

    public void remapTables(String original, String remapped) {
        this.remapTable(original, remapped, -1);
    }

    public void remapTable(String original, String remapped, int index) {
        if (Objects.isNull(remapped)) {
            this.tables.remove(original);
            return;
        }
        Toml[] tables = this.tables.get(original);
        if (Objects.nonNull(tables)) {
            this.tables.remove(original);
            for (Toml table : tables) {
                table.name = remapped;
            }
            this.tables.put(remapped, tables);
        }
    }

    void setComments(List<String> comments, Map<String, List<String>> entryComments) {
        this.comments = ArrayHelper.fromIterable(comments, String.class);
        for (Map.Entry<String, List<String>> entryComment : entryComments.entrySet()) {
            TomlEntry<?> entry = this.entries.get(entryComment.getKey());
            if (!Objects.nonNull(entry)) continue;
            entry.setComments(entryComment.getValue());
        }
    }

    void setRootEntries(Map<String, Object> entries) {
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String key = entry.getKey();
            this.entries.put(key, new TomlEntry<Object>(key, entry.getValue()));
        }
    }

    void setTables(Map<String, List<TomlReader.TableBuilder>> builders) {
        for (Map.Entry<String, List<TomlReader.TableBuilder>> entry : builders.entrySet()) {
            String name = entry.getKey();
            List<TomlReader.TableBuilder> tables = entry.getValue();
            Toml[] tomls = new Toml[tables.size()];
            for (int i = 0; i < tomls.length; ++i) {
                Toml table = new Toml(tables.get(i), name);
                table.parent = this;
                tomls[i] = table;
            }
            this.tables.put(name, tomls);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("\n");
        this.write(builder, 0);
        return builder.toString();
    }

    public void write(StringBuilder builder, int tabs) {
        this.write(builder, tabs, true);
    }

    public void write(StringBuilder builder, int tabs, boolean comments) {
        for (String comment : this.comments) {
            builder.append(tabs == -1 ? "#" + comment : TextHelper.withTabs("# " + comment, tabs)).append("\n");
        }
        if (this.comments.length != 0) {
            builder.append("\n");
        }
        ArrayList<String> sorted = new ArrayList<String>(this.entries.keySet());
        Collections.sort(sorted);
        for (String key : sorted) {
            TomlEntry<?> entry = this.entries.get(key);
            String entryLine = key + " = " + entry.writeValue();
            for (String comment : ((TomlEntry)entry).comments) {
                builder.append(tabs == -1 ? "#" + comment : TextHelper.withTabs("# " + comment, tabs)).append("\n");
            }
            builder.append(tabs == -1 ? entryLine : TextHelper.withTabs(entryLine, tabs)).append("\n");
        }
        if ("root".equals(this.name) && tabs != -1 && !sorted.isEmpty()) {
            builder.append("\n");
        }
        sorted = new ArrayList<String>(this.tables.keySet());
        Collections.sort(sorted);
        for (String key : sorted) {
            Toml[] tomls = this.tables.get(key);
            if (!ArrayHelper.isNotEmpty(tomls)) continue;
            boolean array = tomls.length > 1;
            for (Toml toml : tomls) {
                String tableName = TomlHelper.encapsulateTablePath(toml.getPath(), array);
                builder.append(tabs != -1 ? tableName : TextHelper.withTabs(tableName, tabs)).append("\n");
                toml.write(builder, tabs == -1 ? -1 : tabs + 1, comments);
                if (!"root".equals(this.name) || tabs == -1) continue;
                builder.append("\n");
            }
        }
    }

    public void write(Collection<String> lines, int tabs) {
        this.write(lines, tabs, true);
    }

    public void write(Collection<String> lines, int tabs, boolean comments) {
        for (String comment : this.comments) {
            lines.add(tabs == -1 ? "#" + comment : TextHelper.withTabs("# " + comment, tabs));
        }
        if (this.comments.length != 0 && tabs != -1) {
            lines.add("");
        }
        ArrayList<String> sorted = new ArrayList<String>(this.entries.keySet());
        Collections.sort(sorted);
        for (String key : sorted) {
            TomlEntry<?> entry = this.getEntry(key);
            String entryLine = key + " = " + entry.writeValue();
            for (String comment : ((TomlEntry)entry).comments) {
                lines.add(tabs == -1 ? "#" + comment : TextHelper.withTabs("# " + comment, tabs));
            }
            lines.add(tabs == -1 ? entryLine : TextHelper.withTabs(entryLine, tabs));
        }
        if ("root".equals(this.name) && tabs != -1 && !sorted.isEmpty()) {
            lines.add("");
        }
        sorted = new ArrayList<String>(this.tables.keySet());
        Collections.sort(sorted);
        for (String key : sorted) {
            Toml[] tomls = this.tables.get(key);
            if (!ArrayHelper.isNotEmpty(tomls)) continue;
            boolean array = tomls.length > 1;
            for (Toml toml : tomls) {
                String tableName = TomlHelper.encapsulateTablePath(toml.getPath(), array);
                lines.add(tabs == -1 ? tableName : TextHelper.withTabs(tableName, tabs));
                toml.write(lines, tabs == -1 ? -1 : tabs + 1, comments);
                if (!"root".equals(this.name) || tabs == -1) continue;
                lines.add("");
            }
        }
    }

    public void write(ByteBuf buf) {
        this.write(buf, false);
    }

    public void write(ByteBuf buf, boolean comments) {
        NetworkHelper.writeString(buf, this.toString());
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Toml getParent() {
        return this.parent;
    }

    @Generated
    public void setSorters(Sorting[] sorters) {
        this.sorters = sorters;
    }

    @Generated
    public Sorting[] getSorters() {
        return this.sorters;
    }

    public static class TomlEntry<V> {
        private final String key;
        private final V value;
        private String[] comments;

        public TomlEntry(String key, V value) {
            this.key = key;
            this.value = value;
            this.comments = new String[0];
        }

        private TomlEntry(String key, ByteBuf buf, boolean comments) {
            String type;
            this.key = key;
            switch (type = NetworkHelper.readString(buf)) {
                case "bool": {
                    this.value = buf.readBoolean();
                    break;
                }
                case "float": {
                    this.value = Float.valueOf(buf.readFloat());
                    break;
                }
                case "int": {
                    this.value = buf.readInt();
                    break;
                }
                default: {
                    this.value = NetworkHelper.readString(buf);
                }
            }
            this.comments = comments ? NetworkHelper.readList(buf, () -> NetworkHelper.readString(buf)).toArray(new String[0]) : new String[]{};
        }

        public void addComment(String comment) {
            if (TextHelper.isNotEmpty(comment)) {
                this.comments = ArrayHelper.append(this.comments, comment, true);
            }
        }

        public void clearComments() {
            this.comments = new String[0];
        }

        public void clearCommentsMatching(String toMatch, Matching ... matchers) {
            this.comments = ArrayHelper.removeMatching(this.comments, toMatch, comment -> Matching.matchesAny(comment, toMatch, matchers));
        }

        Parameter<?> parameterize() {
            return ParameterHelper.parameterize(this.value.getClass(), this.value);
        }

        void setComments(List<String> comments) {
            this.comments = ArrayHelper.fromIterable(comments, String.class);
        }

        public String toString() {
            return "<" + this.key + " = " + this.writeValue() + ">";
        }

        String writeValue() {
            return this.writeValue(this.value);
        }

        String writeValue(Object value) {
            if (value instanceof List) {
                StringJoiner joiner = new StringJoiner(",");
                for (Object element : (List)value) {
                    joiner.add(" " + this.writeValue(element));
                }
                return "[" + joiner + " ]";
            }
            return value instanceof String ? "\"" + value + "\"" : (Objects.nonNull(value) ? value.toString() : "null");
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public V getValue() {
            return this.value;
        }

        @Generated
        public String[] getComments() {
            return this.comments;
        }
    }
}

