/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.text;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.CommonAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelperAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextStringAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextTranslationAPI;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    @IndirectCallers
    public static String arrayToString(Object ... array) {
        return TextHelper.arrayToString(0, System.lineSeparator(), array);
    }

    @IndirectCallers
    public static String arrayToString(int limit, Object ... array) {
        return TextHelper.arrayToString(limit, System.lineSeparator(), array);
    }

    @IndirectCallers
    public static String arrayToString(String split, Object ... array) {
        return TextHelper.arrayToString(0, split, array);
    }

    public static String arrayToString(int limit, String split, Object ... array) {
        if (Objects.isNull(array) || array.length == 0) {
            return null;
        }
        limit = limit > 0 ? limit : Integer.MAX_VALUE;
        StringBuilder builder = new StringBuilder();
        int index = 1;
        for (Object element : array) {
            String asString;
            if (Objects.nonNull(element) && !(asString = element.toString()).trim().isEmpty()) {
                builder.append(asString);
            }
            if (index < array.length && index < limit) {
                builder.append(split);
                ++index;
                continue;
            }
            if (index != limit) continue;
            return builder.toString();
        }
        return builder.toString();
    }

    public static String capitalize(String original) {
        if (Objects.isNull(original) || original.isEmpty()) {
            return original;
        }
        return String.valueOf(original.charAt(0)).toUpperCase() + original.substring(1).toLowerCase();
    }

    public static String compileCollection(Collection<?> collection) {
        return TextHelper.compileCollection(collection.toArray(new Object[0]));
    }

    public static String compileCollection(Object ... generics) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        for (Object element : generics) {
            if (element instanceof String) {
                builder.append("\"").append(element).append("\" ");
                continue;
            }
            builder.append(element);
        }
        builder.append("]");
        return builder.toString();
    }

    public static int count(String s, char c) {
        if (TextHelper.isEmpty(s)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    @IndirectCallers
    public static boolean endsWithAny(String s, String ... endings) {
        if (TextHelper.isEmpty(s)) {
            return false;
        }
        for (String ending : endings) {
            if (!s.endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    public static String fromIterable(Iterable<?> itr) {
        return TextHelper.fromIterable(itr, 0, System.lineSeparator());
    }

    @IndirectCallers
    public static String fromIterable(Iterable<?> itr, int limit) {
        return TextHelper.fromIterable(itr, limit, System.lineSeparator());
    }

    public static String fromIterable(Iterable<?> itr, String split) {
        return TextHelper.fromIterable(itr, 0, split);
    }

    public static String fromIterable(Iterable<?> itr, int limit, String split) {
        String val;
        if (Objects.isNull(itr)) {
            return null;
        }
        int count = 0;
        StringJoiner joiner = new StringJoiner(split);
        for (Object value : itr) {
            joiner.add(String.valueOf(value));
            if (limit <= 0 || ++count < limit) continue;
            break;
        }
        return TextHelper.isNotEmpty(val = joiner.toString()) ? val : null;
    }

    public static <S> TextHelperAPI<S> getHelper() {
        return TILRef.getCommonSubAPI(CommonAPI::getTextHelper);
    }

    public static <S> TextStringAPI<S> getLiteral(String text) {
        return TextHelper.getHelper().getLiteral(text);
    }

    public static <S> TextTranslationAPI<S> getTranslated(String key, Object ... args) {
        return TextHelper.getHelper().getTranslated(key, args);
    }

    @IndirectCallers
    public static List<String> hangingIndent(List<String> lines) {
        return TextHelper.hangingIndent(lines, "    ");
    }

    public static List<String> hangingIndent(List<String> lines, String prefix) {
        for (int i = 1; i < lines.size(); ++i) {
            lines.set(i, prefix + lines.get(i));
        }
        return lines;
    }

    public static boolean isBlank(@Nullable String s) {
        if (Objects.isNull(s) || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(@Nullable String s) {
        return Objects.isNull(s) || s.isEmpty();
    }

    public static boolean isNotBlank(@Nullable String s) {
        return !TextHelper.isBlank(s);
    }

    public static boolean isNotEmpty(@Nullable String s) {
        return !TextHelper.isEmpty(s);
    }

    @IndirectCallers
    public static String makeCaseTypeFromCamel(String original, TextCasing type) {
        String[] words = TextCasing.CAMEL.split(original);
        if (type == TextCasing.CAMEL) {
            return TextCasing.CAMEL.combine(words);
        }
        if (type == TextCasing.PASCAL) {
            return TextCasing.PASCAL.combine(words);
        }
        if (type == TextCasing.SNAKE) {
            return TextCasing.SNAKE.combine(words);
        }
        return TextCasing.KEBAB.combine(words);
    }

    @IndirectCallers
    public static String makeCaseTypeFromKebab(String original, TextCasing type) {
        String[] words = TextCasing.KEBAB.split(original);
        if (type == TextCasing.CAMEL) {
            return TextCasing.CAMEL.combine(words);
        }
        if (type == TextCasing.PASCAL) {
            return TextCasing.PASCAL.combine(words);
        }
        if (type == TextCasing.SNAKE) {
            return TextCasing.SNAKE.combine(words);
        }
        return TextCasing.KEBAB.combine(words);
    }

    @IndirectCallers
    public static String makeCaseTypeFromPascal(String original, TextCasing type) {
        String[] words = TextCasing.PASCAL.split(original);
        if (type == TextCasing.CAMEL) {
            return TextCasing.CAMEL.combine(words);
        }
        if (type == TextCasing.PASCAL) {
            return TextCasing.PASCAL.combine(words);
        }
        if (type == TextCasing.SNAKE) {
            return TextCasing.SNAKE.combine(words);
        }
        return TextCasing.KEBAB.combine(words);
    }

    @IndirectCallers
    public static String makeCaseTypeFromSnake(String original, TextCasing type) {
        String[] words = TextCasing.SNAKE.split(original);
        if (type == TextCasing.CAMEL) {
            return TextCasing.CAMEL.combine(words);
        }
        if (type == TextCasing.PASCAL) {
            return TextCasing.PASCAL.combine(words);
        }
        if (type == TextCasing.SNAKE) {
            return TextCasing.SNAKE.combine(words);
        }
        return TextCasing.KEBAB.combine(words);
    }

    @IndirectCallers
    public static List<String> newLineSplit(String original) {
        return Arrays.stream(original.split(System.lineSeparator())).collect(Collectors.toList());
    }

    @IndirectCallers
    public static List<String> newLineSplit(String original, int limit) {
        return Arrays.stream(original.split(System.lineSeparator(), limit)).collect(Collectors.toList());
    }

    @IndirectCallers
    public static String repeat(String base, int num) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            builder.append(base);
        }
        return builder.toString();
    }

    @IndirectCallers
    public static List<String> splitToList(String original, String splitBy) {
        return Arrays.stream(original.split(splitBy)).collect(Collectors.toList());
    }

    @IndirectCallers
    public static List<String> splitToList(String original, String splitBy, int limit) {
        return Arrays.stream(original.split(splitBy, limit)).collect(Collectors.toList());
    }

    public static String withTabs(String original, int tabs) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < tabs; ++i) {
            builder.append("\t");
        }
        return builder.append(original).toString();
    }

    public static enum TextCasing {
        CAMEL("camel", input -> input.split("(?=\\p{Upper})"), words -> {
            StringBuilder builder = new StringBuilder();
            if (Objects.isNull(words) || ((String[])words).length == 0) {
                return builder.toString();
            }
            for (int i = 0; i < ((String[])words).length; ++i) {
                if (i == 0) {
                    builder.append(words[i].toLowerCase());
                    continue;
                }
                builder.append(TextHelper.capitalize(words[i]));
            }
            return builder.toString();
        }),
        PASCAL("pascal", input -> input.split("(?<=.)(?=\\p{Upper})"), words -> {
            StringBuilder builder = new StringBuilder();
            if (Objects.isNull(words)) {
                return builder.toString();
            }
            for (String word : words) {
                builder.append(TextHelper.capitalize(word));
            }
            return builder.toString();
        }),
        SNAKE("snake", input -> input.split("_"), words -> {
            StringBuilder builder = new StringBuilder();
            if (Objects.isNull(words) || ((String[])words).length == 0) {
                return builder.toString();
            }
            for (int i = 0; i < ((String[])words).length; ++i) {
                builder.append(words[i].toLowerCase());
                if (i >= ((String[])words).length - 1) continue;
                builder.append("_");
            }
            return builder.toString();
        }),
        KEBAB("kebab", input -> input.split("-"), words -> {
            StringBuilder builder = new StringBuilder();
            if (Objects.isNull(words) || ((String[])words).length == 0) {
                return builder.toString();
            }
            for (int i = 0; i < ((String[])words).length; ++i) {
                builder.append(words[i].toLowerCase());
                if (i >= ((String[])words).length - 1) continue;
                builder.append("-");
            }
            return builder.toString();
        });

        private final String name;
        private final Function<String, String[]> splitFunc;
        private final Function<String[], String> combineFunc;
        public static final Map<String, TextCasing> BY_NAME;

        private TextCasing(String name, Function<String, String[]> splitFunc, Function<String[], String> combineFunc) {
            this.name = name;
            this.splitFunc = splitFunc;
            this.combineFunc = combineFunc;
        }

        public String[] split(String input) {
            return this.splitFunc.apply(input);
        }

        public String combine(String ... words) {
            return this.combineFunc.apply(words);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        static {
            BY_NAME = new HashMap<String, TextCasing>();
            for (TextCasing casing : TextCasing.values()) {
                BY_NAME.putIfAbsent(casing.name, casing);
            }
        }
    }
}

