/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors;

import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector1;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.MathHelper;

public class Vector3
implements Vector {
    protected Number x;
    protected Number y;
    protected Number z;

    public Vector3() {
        this(0, 0, 0);
    }

    public Vector3(Number x) {
        this(x, 0, 0);
    }

    public Vector3(Vector2 v) {
        this(v.x, v.y, 0);
    }

    public Vector3(Number x, Number y) {
        this(x, y, 0);
    }

    public Vector3(Vector2 v, Number z) {
        this(v.x, v.y, z);
    }

    public Vector3(Vector3 copy) {
        this(copy.x, copy.y, copy.z);
    }

    public Vector3(Number x, Number y, Number z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3 add(Number x, Number y, Number z) {
        return this.add(x, y, z, this);
    }

    public Vector3 add(Vector3 v, Vector3 dst) {
        return this.add(v.x, v.y, v.z, dst);
    }

    public Vector3 add(Number x, Number y, Number z, Vector3 dst) {
        dst.setX(GenericUtils.numberAdd(this.x, x));
        dst.setY(GenericUtils.numberAdd(this.y, y));
        dst.setZ(GenericUtils.numberAdd(this.z, z));
        return dst;
    }

    @Override
    public Vector3 add(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberAdd(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberAdd(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberAdd(this.z, v.z()));
                }
            }
        }
        return this;
    }

    @Override
    public Vector3 addScalar(Number n) {
        this.setX(GenericUtils.numberAdd(this.x, n));
        this.setY(GenericUtils.numberAdd(this.y, n));
        this.setZ(GenericUtils.numberAdd(this.z, n));
        return this;
    }

    @Override
    public double angle(Vector v) {
        double l2;
        double l1;
        double vdZ;
        double vdY;
        if (v.count() < 3) {
            return 0.0;
        }
        double dX = this.dX();
        double dY = this.dY();
        double dZ = this.dZ();
        double vdX = v.dX();
        double l3 = dX * vdX + (dY * (vdY = v.dY()) + dZ * (vdZ = v.dZ()));
        double angle = l3 / Math.sqrt((l1 = dX * dX + (dY * dY + dZ * dZ)) * (l2 = vdX * vdX + (vdY * vdY + vdZ * vdZ)));
        return Math.acos(angle < 1.0 ? (angle > -1.0 ? angle : -1.0) : 1.0);
    }

    @Override
    public Number[] array() {
        return new Number[]{this.x, this.y, this.z};
    }

    @Override
    public byte[] bArrray() {
        return new byte[]{this.bX(), this.bY(), this.bZ()};
    }

    @Override
    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    @Override
    public int count() {
        return 3;
    }

    @Override
    public Vector3 cross(Vector v) {
        return this.cross(v, this);
    }

    public Vector3 cross(Vector v, Vector3 dst) {
        if (v.count() != 3) {
            return dst;
        }
        double dX = this.dX();
        double dY = this.dY();
        double dZ = this.dZ();
        double vdX = v.dX();
        double vdY = v.dY();
        double vdZ = v.dZ();
        dst.setX(dY * vdZ + -dZ * vdY);
        dst.setY(dZ * vdX + -dX * vdZ);
        dst.setZ(dX * vdY + -dY * vdX);
        return dst;
    }

    @Override
    public double[] dArrray() {
        return new double[]{this.dX(), this.dY(), this.dZ()};
    }

    @Override
    public double distance(Vector v) {
        if (v.count() < 3) {
            return 0.0;
        }
        double dx = this.dX() - v.dX();
        double dy = this.dY() - v.dY();
        double dz = this.dZ() - v.dZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public Vector3 div(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberDiv(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberDiv(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberDiv(this.z, v.z()));
                }
            }
        }
        return this;
    }

    @Override
    public Vector3 divScalar(Number n) {
        this.setX(GenericUtils.numberDiv(this.x, n));
        this.setY(GenericUtils.numberDiv(this.y, n));
        this.setZ(GenericUtils.numberDiv(this.z, n));
        return this;
    }

    @Override
    public double dot(Vector v) {
        int count = v.count();
        if (count == 0) {
            return 0.0;
        }
        double total = this.dX() * v.dX();
        if (count > 1) {
            total += this.dY() * v.dY();
        }
        if (count > 2) {
            total += this.dZ() * v.dZ();
        }
        return total;
    }

    @Override
    public float[] fArrray() {
        return new float[]{this.fX(), this.fY(), this.fZ()};
    }

    @Override
    public int[] iArrray() {
        return new int[]{this.iX(), this.iY(), this.iZ()};
    }

    @Override
    public long[] lArrray() {
        return new long[]{this.lX(), this.lY(), this.lZ()};
    }

    public Vector3 max(Vector3 v) {
        return this.max(v, this);
    }

    public Vector3 max(Vector3 v, Vector3 dst) {
        dst.x = this.dX() > v.dX() ? (Number)this.x : (Number)v.x();
        dst.y = this.dY() > v.dY() ? (Number)this.y : (Number)v.y();
        dst.z = this.dZ() > v.dZ() ? (Number)this.z : (Number)v.z();
        return dst;
    }

    public Vector3 min(Vector3 v) {
        return this.min(v, this);
    }

    public Vector3 min(Vector3 v, Vector3 dst) {
        dst.x = this.dX() < v.dX() ? (Number)this.x : (Number)v.x();
        dst.y = this.dY() < v.dY() ? (Number)this.y : (Number)v.y();
        dst.z = this.dZ() < v.dZ() ? (Number)this.z : (Number)v.z();
        return dst;
    }

    @Override
    public Vector3 mul(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberMul(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberMul(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberMul(this.z, v.z()));
                }
            }
        }
        return this;
    }

    @Override
    public Vector3 mulScalar(Number n) {
        this.setX(GenericUtils.numberMul(this.x, n));
        this.setY(GenericUtils.numberMul(this.y, n));
        this.setZ(GenericUtils.numberMul(this.z, n));
        return this;
    }

    public Vector3 normalize() {
        return this.normalize(this);
    }

    public Vector3 normalize(Vector3 dst) {
        double dX = this.dX();
        double dY = this.dY();
        double dZ = this.dZ();
        double iLen = 1.0 / Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        dst.setX(dX * iLen);
        dst.setY(dY * iLen);
        dst.setX(dZ * iLen);
        return dst;
    }

    public Vector3 rotateX(double angle) {
        return this.rotateX(angle, this);
    }

    public Vector3 rotateX(double angle, Vector3 dst) {
        double sin = Math.sin(angle);
        double cos = MathHelper.cosFromSin(angle, sin);
        double y = this.dX() * cos - this.dZ() * sin;
        double z = this.dY() * sin + this.dZ() * cos;
        dst.setX(this.x);
        dst.setY(y);
        dst.setZ(z);
        return dst;
    }

    public Vector3 rotateY(double angle) {
        return this.rotateY(angle, this);
    }

    public Vector3 rotateY(double angle, Vector3 dst) {
        double sin = Math.sin(angle);
        double cos = MathHelper.cosFromSin(angle, sin);
        double x = this.dX() * cos - this.dZ() * sin;
        double z = -this.dX() * sin + this.dZ() * cos;
        dst.setX(x);
        dst.setY(this.y);
        dst.setZ(z);
        return dst;
    }

    public Vector3 rotateZ(double angle) {
        return this.rotateZ(angle, this);
    }

    public Vector3 rotateZ(double angle, Vector3 dst) {
        double sin = Math.sin(angle);
        double cos = MathHelper.cosFromSin(angle, sin);
        double x = this.dX() * cos - this.dY() * sin;
        double y = this.dX() * sin + this.dY() * cos;
        dst.setX(x);
        dst.setY(y);
        dst.setZ(this.z);
        return dst;
    }

    @Override
    public short[] sArrray() {
        return new short[]{this.sX(), this.sY(), this.sZ()};
    }

    @Override
    public void setW(Number w) {
        throw new UnsupportedOperationException("Cannot set w value for Vector3");
    }

    public Vector3 sub(Number x, Number y, Number z) {
        return this.sub(x, y, z, this);
    }

    public Vector3 sub(Number x, Number y, Number z, Vector3 dst) {
        dst.setX(GenericUtils.numberSub(this.x, x));
        dst.setY(GenericUtils.numberSub(this.y, y));
        dst.setZ(GenericUtils.numberSub(this.z, z));
        return dst;
    }

    @Override
    public Vector3 sub(Vector v) {
        int count = v.count();
        if (count > 0) {
            this.setX(GenericUtils.numberSub(this.x, v.x()));
            if (count > 1) {
                this.setY(GenericUtils.numberSub(this.y, v.y()));
                if (count > 2) {
                    this.setZ(GenericUtils.numberSub(this.z, v.z()));
                }
            }
        }
        return this;
    }

    @Override
    public Vector3 subScalar(Number n) {
        this.setX(GenericUtils.numberSub(this.x, n));
        this.setY(GenericUtils.numberSub(this.y, n));
        this.setZ(GenericUtils.numberSub(this.z, n));
        return this;
    }

    @Override
    public Vector vW() {
        throw new UnsupportedOperationException("Cannot get Vector1 W from Vector3");
    }

    @Override
    public Vector vX() {
        return new Vector1(this.x());
    }

    @Override
    public Vector vXW() {
        throw new UnsupportedOperationException("Cannot get Vector2 XW from Vector3");
    }

    @Override
    public Vector vXY() {
        return new Vector2(this.x(), this.y());
    }

    @Override
    public Vector vXYZ() {
        return this;
    }

    @Override
    public Vector vXZ() {
        return new Vector2(this.x(), this.z());
    }

    @Override
    public Vector vXZW() {
        throw new UnsupportedOperationException("Cannot get Vector3 XZW from Vector3");
    }

    @Override
    public Vector vY() {
        return new Vector1(this.y());
    }

    @Override
    public Vector vYW() {
        throw new UnsupportedOperationException("Cannot get Vector2 YW from Vector3");
    }

    @Override
    public Vector vYZ() {
        return new Vector2(this.y(), this.z());
    }

    @Override
    public Vector vYZW() {
        throw new UnsupportedOperationException("Cannot get Vector3 YZW from Vector3");
    }

    @Override
    public Vector vZ() {
        return new Vector1(this.z());
    }

    @Override
    public Vector vZW() {
        throw new UnsupportedOperationException("Cannot get Vector2 ZW from Vector3");
    }

    @Override
    public Number w() {
        return Double.NaN;
    }

    @Override
    public Number x() {
        return this.x;
    }

    @Override
    public Number y() {
        return this.y;
    }

    @Override
    public Number z() {
        return this.z;
    }

    @Override
    @Generated
    public void setX(Number x) {
        this.x = x;
    }

    @Override
    @Generated
    public void setY(Number y) {
        this.y = y;
    }

    @Override
    @Generated
    public void setZ(Number z) {
        this.z = z;
    }
}

