/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.shapes;

import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape2D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.Shape3D;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.ShapeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector2;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorStreams;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorSuppliers;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import mods.thecomputerizer.theimpossiblelibrary.api.world.BlockPosAPI;

public class Box
extends Shape3D {
    public static final Box INFINITE = new Box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public Box div(double x, double y, double z) {
            return this;
        }

        @Override
        public Box expand(double x, double y, double z) {
            return this;
        }

        @Override
        public double getBoundedX(double x, double y, double z) {
            return x;
        }

        @Override
        public double getBoundedY(double x, double y, double z) {
            return y;
        }

        @Override
        public double getBoundedZ(double x, double y, double z) {
            return z;
        }

        @Override
        public double getDepth() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double getHeight() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double getWidth() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public boolean isInside(BlockPosAPI<?> pos) {
            return true;
        }

        @Override
        public boolean isInside(BlockPosAPI<?> pos, double tolerance) {
            return true;
        }

        @Override
        public boolean isInside(Vector3 pos) {
            return true;
        }

        @Override
        public boolean isInside(Vector3 pos, double tolerance) {
            return true;
        }

        @Override
        public boolean isInside(double x, double y, double z) {
            return true;
        }

        @Override
        public boolean isInside(double x, double y, double z, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideX(double x) {
            return true;
        }

        @Override
        public boolean isInsideX(double x, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideY(double y) {
            return true;
        }

        @Override
        public boolean isInsideY(double y, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideZ(double z) {
            return true;
        }

        @Override
        public boolean isInsideZ(double z, double tolerance) {
            return true;
        }

        @Override
        public Box offset(double x, double y, double z) {
            return this;
        }

        @Override
        public Box mul(double x, double y, double z) {
            return this;
        }

        @Override
        public Box shrink(double x, double y, double z) {
            return this;
        }
    };
    public static final Box ZERO = new Box(0.0, 0.0, 0.0, 0.0, 0.0, 0.0){

        @Override
        public boolean isInside(BlockPosAPI<?> pos) {
            return false;
        }

        @Override
        public boolean isInside(BlockPosAPI<?> pos, double tolerance) {
            return true;
        }

        @Override
        public boolean isInside(Vector3 pos) {
            return false;
        }

        @Override
        public boolean isInside(Vector3 pos, double tolerance) {
            return true;
        }

        @Override
        public boolean isInside(double x, double y, double z) {
            return false;
        }

        @Override
        public boolean isInside(double x, double y, double z, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideX(double x) {
            return true;
        }

        @Override
        public boolean isInsideX(double x, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideY(double y) {
            return true;
        }

        @Override
        public boolean isInsideY(double y, double tolerance) {
            return true;
        }

        @Override
        public boolean isInsideZ(double z) {
            return true;
        }

        @Override
        public boolean isInsideZ(double z, double tolerance) {
            return true;
        }
    };
    public final Vector3 min;
    public final Vector3 max;
    public final Vector3 center;

    public Box(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.min = new Vector3(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2));
        this.max = new Vector3(Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
        this.center = VectorHelper.getCenter(this.min, this.max);
    }

    public Box add(Box ... boxes) {
        if (Objects.isNull(boxes) || boxes.length == 0) {
            return this;
        }
        Vector3 min = this.min.min(boxes[0].min, new Vector3());
        Vector3 max = this.max.max(boxes[0].max, new Vector3());
        for (int i = 1; i < boxes.length; ++i) {
            min = min.min(boxes[i].min);
            max = max.max(boxes[i].max);
        }
        return ShapeHelper.box(min, max);
    }

    @Override
    public boolean checkToleranceBounds(Vector3 center, Box bounds) {
        return bounds.expand(this.getWidth() / 2.0, this.getHeight() / 2.0, this.getDepth() / 2.0).isInside(this.getCenter(center));
    }

    @Override
    public Box copy() {
        return this.mul(1.0, 1.0, 1.0);
    }

    public Box div(double d) {
        return this.mul(1.0 / d, 1.0 / d, 1.0 / d);
    }

    public Box div(double x, double y, double z) {
        return Double.isNaN(x) || x == 0.0 || Double.isNaN(y) || y == 0.0 || Double.isNaN(z) || z == 0.0 ? INFINITE : (this.isFiniteAndNotMaxed(x, y, z) ? this.mul(1.0 / x, 1.0 / y, 1.0 / z) : ZERO);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (Objects.isNull(other)) {
            return false;
        }
        if (other.getClass() == Box.class) {
            Box box = (Box)other;
            return Misc.equalsNullable(this.min, box.max) && Misc.equalsNullable(this.max, box.max);
        }
        return false;
    }

    public Box expand(double d) {
        return this.expand(d, d, d);
    }

    public Box expand(double x, double y, double z) {
        if (x == 0.0 && y == 0.0 && z == 0.0) {
            return this;
        }
        double xRad = this.radiusX();
        double yRad = this.radiusY();
        double zRad = this.radiusZ();
        if (xRad + x <= 0.0 || yRad + y <= 0.0 || zRad + z <= 0.0) {
            return ZERO;
        }
        return ShapeHelper.box(this.min.sub(x, y, z, new Vector3()), this.max.add(x, y, z, new Vector3()));
    }

    @Override
    public double getBoundedX(double x, double y, double z) {
        return Math.max(this.min.dX(), Math.min(this.max.dX(), x));
    }

    @Override
    public double getBoundedY(double x, double y, double z) {
        return Math.max(this.min.dY(), Math.min(this.max.dY(), y));
    }

    @Override
    public double getBoundedZ(double x, double y, double z) {
        return Math.max(this.min.dZ(), Math.min(this.max.dZ(), z));
    }

    @Override
    public Vector3 getCenter(Vector3 center) {
        return center.add(this.center, new Vector3());
    }

    @Override
    public double getDepth() {
        return Math.abs(this.max.dZ() - this.min.dZ());
    }

    @Override
    public double getHeight() {
        return Math.abs(this.max.dY() - this.min.dY());
    }

    @Override
    public Box getScaled(double scale) {
        return this.mul(scale, scale, scale);
    }

    @Override
    public Box getScaled(Vector2 scale) {
        return this.mul(scale.dX(), scale.dY(), scale.dX());
    }

    @Override
    public Box getScaled(double scaleH, double scaleV) {
        return this.mul(scaleH, scaleV, scaleH);
    }

    @Override
    public Box getScaled(Vector3 scale) {
        return this.mul(scale.dX(), scale.dY(), scale.dZ());
    }

    @Override
    public Box getScaled(double scaleX, double scaleY, double scaleZ) {
        return this.mul(scaleX, scaleY, scaleZ);
    }

    @Override
    public VectorSuppliers.VectorSupplier3D getVectorSupplier(Box bounds) {
        Box bounded = this.intersection(bounds);
        return VectorStreams.get3D(new Vector3(bounded.min), new Vector3(bounded.min.dX(), bounded.min.dY(), bounded.max.dZ()), new Vector3(bounded.min.dX(), bounded.max.dY(), bounded.max.dZ()), new Vector3(bounded.min.dX(), bounded.max.dY(), bounded.min.dZ()), new Vector3(bounded.max.dX(), bounded.max.dY(), bounded.min.dZ()), new Vector3(bounded.max), new Vector3(bounded.max.dX(), bounded.min.dY(), bounded.max.dZ()), new Vector3(bounded.max.dX(), bounded.min.dY(), bounded.min.dZ()));
    }

    @Override
    public double getWidth() {
        return Math.abs(this.max.dX() - this.min.dX());
    }

    public Box intersection(Box other) {
        return new Box(Math.max(this.min.dX(), other.min.dX()), Math.max(this.min.dY(), other.min.dY()), Math.max(this.min.dZ(), other.min.dZ()), Math.min(this.max.dX(), other.max.dX()), Math.min(this.max.dY(), other.max.dY()), Math.min(this.max.dZ(), other.max.dZ()));
    }

    private boolean isFiniteAndNotMaxed(double d) {
        return Double.isFinite(d) && Math.abs(d) < Double.MAX_VALUE;
    }

    private boolean isFiniteAndNotMaxed(double x, double y, double z) {
        return this.isFiniteAndNotMaxed(x) && this.isFiniteAndNotMaxed(y) && this.isFiniteAndNotMaxed(z);
    }

    public boolean isInside(BlockPosAPI<?> pos) {
        return this.isInsideX(pos.x(), 0.0) && this.isInsideY(pos.y(), 0.0) && this.isInsideZ(pos.z(), 0.0);
    }

    public boolean isInside(BlockPosAPI<?> pos, double tolerance) {
        return this.isInsideX(pos.x(), tolerance) && this.isInsideY(pos.y(), tolerance) && this.isInsideZ(pos.z(), tolerance);
    }

    @Override
    public boolean isInside(Vector3 pos) {
        return this.isInsideX(pos.dX(), 0.0) && this.isInsideY(pos.dY(), 0.0) && this.isInsideZ(pos.dZ(), 0.0);
    }

    public boolean isInside(Vector3 pos, double tolerance) {
        return this.isInsideX(pos.dX(), tolerance) && this.isInsideY(pos.dY(), tolerance) && this.isInsideZ(pos.dZ(), tolerance);
    }

    @Override
    public boolean isInside(double x, double y, double z) {
        return this.isInsideX(x, 0.0) && this.isInsideY(y, 0.0) && this.isInsideZ(z, 0.0);
    }

    public boolean isInside(double x, double y, double z, double tolerance) {
        return this.isInsideX(x, tolerance) && this.isInsideY(y, tolerance) && this.isInsideZ(z, tolerance);
    }

    public boolean isInsideX(double x) {
        return this.isInsideX(x, 0.0);
    }

    public boolean isInsideX(double x, double tolerance) {
        return x > this.min.dX() - tolerance && x < this.max.dX() + tolerance;
    }

    public boolean isInsideXY(double x, double y) {
        return this.isInsideX(x, 0.0) && this.isInsideY(y, 0.0);
    }

    public boolean isInsideXY(double x, double y, double tolerance) {
        return this.isInsideX(x, tolerance) && this.isInsideY(y, tolerance);
    }

    public boolean isInsideY(double y) {
        return this.isInsideY(y, 0.0);
    }

    public boolean isInsideY(double y, double tolerance) {
        return y > this.min.dY() - tolerance && y < this.max.dY() + tolerance;
    }

    public boolean isInsideZ(double z) {
        return this.isInsideZ(z, 0.0);
    }

    public boolean isInsideZ(double z, double tolerance) {
        return z > this.min.dZ() - tolerance && z < this.max.dZ() + tolerance;
    }

    public double maxX() {
        return this.max.dX();
    }

    public double maxY() {
        return this.max.dY();
    }

    public double maxZ() {
        return this.max.dZ();
    }

    public double minX() {
        return this.min.dX();
    }

    public double minY() {
        return this.min.dY();
    }

    public double minZ() {
        return this.min.dZ();
    }

    public Box mul(double d) {
        return this.mul(d, d, d);
    }

    public Box mul(double x, double y, double z) {
        if (Double.isNaN(x) || x == 0.0 || Double.isNaN(y) || y == 0.0 || Double.isNaN(z) || z == 0.0) {
            return ZERO;
        }
        if (!this.isFiniteAndNotMaxed(x, y, z)) {
            return INFINITE;
        }
        if (x == 1.0 && y == 1.0 && z == 1.0) {
            return this;
        }
        double xRad = this.radiusX();
        double yRad = this.radiusY();
        double zRad = this.radiusZ();
        return this.expand(xRad * x - xRad, yRad * y - yRad, zRad * z - zRad);
    }

    public Box offset(double d) {
        return this.offset(d, d, d);
    }

    public Box offset(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : ShapeHelper.box(this.min.add(x, y, z, new Vector3()), this.max.add(x, y, z, new Vector3()));
    }

    public double radiusX() {
        return this.getWidth() / 2.0;
    }

    public double radiusY() {
        return this.getHeight() / 2.0;
    }

    public double radiusZ() {
        return this.getDepth() / 2.0;
    }

    @Override
    public Vector2 random2D() {
        return VectorHelper.randomD(new Vector2(this.min.dX(), this.min.dY()), new Vector2(this.max.dX(), this.max.dY()));
    }

    @Override
    public Vector3 random3D() {
        return VectorHelper.randomD(this.min, this.max);
    }

    public Box shrink(double d) {
        return this.expand(-d, -d, -d);
    }

    public Box shrink(double x, double y, double z) {
        return this.expand(-x, -y, -z);
    }

    @Override
    public Shape2D[] getAs2DArray() {
        return new Shape2D[]{ShapeHelper.plane(new Vector3(this.min), new Vector3(this.max.dX(), this.max.dY(), this.min.dZ())), ShapeHelper.plane(new Vector3(this.min), new Vector3(this.max.dX(), this.min.dY(), this.max.dZ())), ShapeHelper.plane(new Vector3(this.min), new Vector3(this.min.dX(), this.max.dY(), this.max.dZ())), ShapeHelper.plane(new Vector3(this.min.dX(), this.max.dY(), this.min.dZ()), new Vector3(this.max)), ShapeHelper.plane(new Vector3(this.max.dX(), this.min.dY(), this.min.dZ()), new Vector3(this.max)), ShapeHelper.plane(new Vector3(this.min.dX(), this.min.dY(), this.max.dZ()), new Vector3(this.max))};
    }
}

