/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.server;

import java.util.Objects;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.CommandSenderAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.server.MinecraftServerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.Vector3;
import mods.thecomputerizer.theimpossiblelibrary.api.shapes.vectors.VectorHelper;

public abstract class CommandHelperAPI {
    public abstract EntityAPI<?, ?> parseEntity(MinecraftServerAPI<?> var1, CommandSenderAPI<?> var2, String var3) throws Exception;

    public abstract PlayerAPI<?, ?> parsePlayer(MinecraftServerAPI<?> var1, CommandSenderAPI<?> var2, String var3) throws Exception;

    public Vector3 parsePosition(EntityAPI<?, ?> reference, String unparsed) {
        Vector3 pos = Objects.nonNull(reference) ? reference.getPosExact() : VectorHelper.zero3D();
        String[] split = unparsed.split(" ", 2);
        double x = split.length > 0 ? this.parseDoubleRef(split[0], pos, Vector::dX) : 0.0;
        double y = split.length > 1 ? this.parseDoubleRef(split[1], pos, Vector::dY) : 0.0;
        double z = split.length > 2 ? this.parseDoubleRef(split[2], pos, Vector::dZ) : 0.0;
        return new Vector3(x, y, z);
    }

    public double parseDoubleRef(String unparsed, Vector3 pos, Function<Vector3, Double> posFunc) {
        boolean isRef = unparsed.contains("~");
        double parsed = Double.parseDouble(unparsed.replace('~', '\u0000'));
        return parsed + (isRef ? posFunc.apply(pos) : 0.0);
    }
}

