/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry.blockentity;

import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mods.thecomputerizer.theimpossiblelibrary.api.common.block.BlockAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.common.blockentity.BlockEntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryEntryBuilder;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityBuilderAPI
extends RegistryEntryBuilder<BlockEntityAPI<?, ?>> {
    private static final String CREATE;
    private static final String OF;
    private static final String SUPPLIER = "net.minecraft.world.level.block.entity.BlockEntityType$BlockEntitySupplier";
    protected Consumer<BlockEntityAPI<?, ?>> onTick;
    protected Supplier<Collection<BlockAPI<?>>> validBlocks;

    protected static <B> B getBuilder(Class<?> builderClass, BiFunction<?, ?, ?> supplier, Object[] blocks) {
        Object blockEntitySupplier = BlockEntityBuilderAPI.getSupplier(supplier);
        if (Objects.isNull(blockEntitySupplier)) {
            TILRef.logError("Unable to build BlockEntityType from null BlockEntitySupplier!", new Object[0]);
            return null;
        }
        return (B)StaticComponentContainer.Methods.invokeStaticDirect(builderClass, OF, blockEntitySupplier, blocks);
    }

    private static <P1, P2> Object getSupplier(BiFunction<P1, P2, ?> supplier) {
        Class<?> supplierClass = ClassHelper.findClass(SUPPLIER);
        if (Objects.isNull(supplierClass)) {
            TILRef.logError("Unable to get BlockEntitySupplier class! {}", SUPPLIER);
            return null;
        }
        return ClassHelper.newGenericProxy(supplierClass, CREATE, args -> supplier.apply(args[0], args[1]));
    }

    protected BlockEntityBuilderAPI(@Nullable BlockEntityBuilderAPI parent) {
        if (Objects.nonNull(parent)) {
            this.onTick = parent.onTick;
            this.validBlocks = parent.validBlocks;
        } else {
            this.onTick = null;
            this.validBlocks = null;
        }
    }

    public BlockEntityBuilderAPI setRegistryName(ResourceLocationAPI<?> name) {
        this.registryName = name;
        return this;
    }

    public BlockEntityBuilderAPI setOnTick(Consumer<BlockEntityAPI<?, ?>> consumer) {
        this.onTick = consumer;
        return this;
    }

    public BlockEntityBuilderAPI setValidBlocks(Supplier<Collection<BlockAPI<?>>> supplier) {
        this.validBlocks = supplier;
        return this;
    }

    static {
        String string = NAMED_ENV ? "create" : (CREATE = SRG_ENV ? "m_155267_" : "create");
        OF = NAMED_ENV ? "of" : (SRG_ENV ? "m_155273_" : "method_20528");
    }
}

