/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.registry;

import java.util.Objects;
import java.util.StringJoiner;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.registry.RegistryHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.resource.ResourceLocationAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.world.WorldAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.wrappers.Wrapped;

public interface RegistryEntryAPI<V>
extends Wrapped<V> {
    @IndirectCallers
    default public String getName() {
        ResourceLocationAPI<?> registryName = this.getRegistryName();
        if (Objects.isNull(registryName)) {
            return null;
        }
        String[] words = registryName.getPath().split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(TextHelper.capitalize(word));
        }
        return joiner.toString();
    }

    @IndirectCallers
    default public String getName(WorldAPI<?> world) {
        ResourceLocationAPI<?> registryName = this.getRegistryName(world);
        if (Objects.isNull(registryName)) {
            return null;
        }
        String[] words = registryName.getPath().split("_");
        StringJoiner joiner = new StringJoiner(" ");
        for (String word : words) {
            joiner.add(TextHelper.capitalize(word));
        }
        return joiner.toString();
    }

    default public RegistryAPI<?> getRegistry() {
        Class wrappedClass = this.getWrappedClass();
        return Objects.nonNull(wrappedClass) ? RegistryHelper.getRegistry(wrappedClass) : null;
    }

    default public ResourceLocationAPI<?> getRegistryName() {
        RegistryAPI<?> registry = this.getRegistry();
        return Objects.nonNull(registry) && Objects.nonNull(this.getWrapped()) ? registry.getKey(this.unwrap()) : null;
    }

    default public ResourceLocationAPI<?> getRegistryName(WorldAPI<?> world) {
        return this.getRegistryName();
    }

    public void setRegistryName(ResourceLocationAPI<?> var1);
}

