/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.parameter;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ReflectionHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.Parameter;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.ParameterList;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.ParameterString;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterBool;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterByte;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterDouble;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterFloat;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterInt;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterLong;
import mods.thecomputerizer.theimpossiblelibrary.api.parameter.primitive.ParameterShort;
import org.jetbrains.annotations.Nullable;

@IndirectCallers
public class ParameterHelper {
    @IndirectCallers
    public static <E> Parameter<E> parameterize(Class<?> type, E element) {
        if (Collection.class.isAssignableFrom(type)) {
            return new ParameterList<String>(String.class, (List)element);
        }
        switch (type.getSimpleName()) {
            case "Boolean": {
                return new ParameterBool((Boolean)element);
            }
            case "Byte": {
                return new ParameterByte((Byte)element);
            }
            case "Double": {
                return new ParameterDouble((Double)element);
            }
            case "Float": {
                return new ParameterFloat(((Float)element).floatValue());
            }
            case "Integer": {
                return new ParameterInt((Integer)element);
            }
            case "Long": {
                return new ParameterLong((Long)element);
            }
            case "Short": {
                return new ParameterShort((Short)element);
            }
        }
        return new ParameterString((String)element);
    }

    @Nullable
    public static Parameter<?> parse(ByteBuf buf) {
        Class<?> clazz = ReflectionHelper.findExtensibleClass(NetworkHelper.readString(buf), Parameter.class);
        Constructor<?> constructor = ReflectionHelper.findConstructor(clazz, ByteBuf.class);
        try {
            return (Parameter)constructor.newInstance(buf);
        }
        catch (ReflectiveOperationException ex) {
            TILRef.logError("Unable to invoke constructor `{}` for paremter!", constructor, ex);
            return null;
        }
    }
}

