/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.parameter;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorCache;
import mods.thecomputerizer.theimpossiblelibrary.api.client.render.ColorHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.IterableHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.network.NetworkHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.GenericUtils;
import mods.thecomputerizer.theimpossiblelibrary.api.util.RandomHelper;
import org.jetbrains.annotations.Nullable;

public abstract class Parameter<T> {
    protected final T defaultValue;
    protected T value;

    protected Parameter(T defaultValue) {
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    protected Parameter(ByteBuf buf) {
        this.defaultValue = this.read(buf);
        this.value = this.read(buf);
    }

    public abstract Parameter<T> copy();

    public boolean equals(Object other) {
        return other instanceof Parameter && GenericUtils.matches(this.value, ((Parameter)other).value);
    }

    public boolean getAsBoolean(String name) {
        return Boolean.parseBoolean(this.getAsString());
    }

    @IndirectCallers
    public byte getAsByte() {
        return this.getAsByte("parameter");
    }

    public byte getAsByte(String name) {
        return this.getAsNumber(Number::byteValue, s -> RandomHelper.randomByte(name + "_as_number", s, (byte)0));
    }

    public ColorCache getAsColor() {
        return ColorHelper.getColor(this.getAsString());
    }

    @IndirectCallers
    public double getAsDouble() {
        return this.getAsDouble("parameter");
    }

    public double getAsDouble(String name) {
        return this.getAsNumber(Number::doubleValue, s -> RandomHelper.randomDouble(name + "_as_number", s, 0.0));
    }

    @IndirectCallers
    public float getAsFloat() {
        return this.getAsFloat("parameter");
    }

    public float getAsFloat(String name) {
        return this.getAsNumber(Number::floatValue, s -> Float.valueOf(RandomHelper.randomFloat(name + "_as_number", s, 0.0f))).floatValue();
    }

    public int getAsInt() {
        return this.getAsInt("parameter");
    }

    public int getAsInt(String name) {
        return this.getAsNumber(Number::intValue, s -> RandomHelper.randomInt(name + "_as_number", s, 0));
    }

    @IndirectCallers
    public long getAsLong() {
        return this.getAsLong("parameter");
    }

    public long getAsLong(String name) {
        return this.getAsNumber(Number::longValue, s -> RandomHelper.randomLong(name + "_as_number", s, 0L));
    }

    @IndirectCallers
    public short getAsShort() {
        return this.getAsShort("parameter");
    }

    public short getAsShort(String name) {
        return this.getAsNumber(Number::shortValue, s -> RandomHelper.randomShort(name + "_as_number", s, (short)0));
    }

    public List<?> getAsList() {
        return Collections.singletonList(this.value);
    }

    @IndirectCallers
    public Number getAsNumber() {
        return this.getAsNumber("parameter");
    }

    public Number getAsNumber(String name) {
        return this.getAsNumber(n -> n, s -> RandomHelper.randomDouble(name + "_as_number", s, 0.0));
    }

    protected <N extends Number> N getAsNumber(Function<Number, N> fromNumber, Function<String, N> fromString) {
        return this.getAsNumber(this.value, fromNumber, fromString);
    }

    protected <N extends Number> N getAsNumber(@Nullable Object value, Function<Number, N> fromNumber, Function<String, N> fromString) {
        if (Objects.isNull(value)) {
            return (N)((Number)fromNumber.apply(0));
        }
        if (value instanceof Number) {
            return (N)((Number)fromNumber.apply((Number)value));
        }
        if (value instanceof String) {
            return (N)((Number)fromString.apply((String)value));
        }
        if (value instanceof Boolean) {
            return (N)((Number)fromNumber.apply((Boolean)value != false ? 1 : 0));
        }
        if (value instanceof Iterable) {
            return this.getAsNumber(IterableHelper.getElement(0, (Collection)value), fromNumber, fromString);
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            return this.getAsNumber(ArrayHelper.isNotEmpty(array) ? array[0] : Integer.valueOf(0), fromNumber, fromString);
        }
        return (N)((Number)fromString.apply(String.valueOf(value)));
    }

    public String getAsString() {
        return String.valueOf(this.value);
    }

    public abstract boolean isBool();

    public abstract boolean isByte();

    public boolean isDefault() {
        return GenericUtils.matches(this.value, this.defaultValue);
    }

    public abstract boolean isDouble();

    public abstract boolean isFloat();

    public abstract boolean isInt();

    public abstract boolean isList();

    public abstract boolean isLong();

    public abstract boolean isNumber();

    public abstract boolean isPrimitive();

    public abstract boolean isShort();

    public abstract boolean isString();

    protected abstract T read(ByteBuf var1);

    public abstract void setValue(@Nullable Object var1);

    public String toString() {
        return String.valueOf(this.value);
    }

    public void write(ByteBuf buf) {
        NetworkHelper.writeString(buf, this.getClass().getName());
        this.write(buf, this.defaultValue);
        this.write(buf, this.value);
    }

    protected abstract void write(ByteBuf var1, T var2);

    @Generated
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public T getValue() {
        return this.value;
    }
}

