/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.iterator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.iterator.Mappable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Wrapperable<E>
implements Iterable<E> {
    private final Iterable<E> iterable;

    public static <E> Wrapperable<E> make(Supplier<Iterable<E>> supplier) {
        return new Wrapperable<E>(supplier.get(), false);
    }

    public static <E> Wrapperable<E> make(Supplier<Iterable<E>> supplier, Consumer<Wrapperable<E>> settings) {
        Wrapperable<E> bundle = Wrapperable.make(supplier);
        settings.accept(bundle);
        return bundle;
    }

    public static <E> Wrapperable<E> makeSynchronized(Supplier<Iterable<E>> supplier) {
        return new Wrapperable<E>(supplier.get(), true);
    }

    public static <E> Wrapperable<E> makeSynchronized(Supplier<Iterable<E>> supplier, Consumer<Wrapperable<E>> settings) {
        Wrapperable<E> bundle = Wrapperable.make(supplier);
        settings.accept(bundle);
        return bundle;
    }

    public static <E> Wrapperable<E> makeArray(E ... elements) {
        ArrayList list = new ArrayList(Arrays.asList(elements));
        return Wrapperable.make(() -> list);
    }

    public static <E> Wrapperable<E> makeArray(Consumer<Wrapperable<E>> settings, E ... elements) {
        ArrayList list = new ArrayList(Arrays.asList(elements));
        return Wrapperable.make(() -> list, settings);
    }

    public static <E> Wrapperable<E> makeArray(Supplier<E[]> supplier) {
        return Wrapperable.makeArray(supplier.get());
    }

    public static <E> Wrapperable<E> makeArray(Supplier<E[]> supplier, Consumer<Wrapperable<E>> settings) {
        return Wrapperable.makeArray(settings, supplier.get());
    }

    public static <E> Wrapperable<E> makeSynchronizedArray(E ... elements) {
        ArrayList list = new ArrayList(Arrays.asList(elements));
        return Wrapperable.makeSynchronized(() -> list);
    }

    public static <E> Wrapperable<E> makeSynchronizedArray(Consumer<Wrapperable<E>> settings, E ... elements) {
        ArrayList list = new ArrayList(Arrays.asList(elements));
        return Wrapperable.makeSynchronized(() -> list, settings);
    }

    public static <E> Wrapperable<E> makeSynchronizedArray(Supplier<E[]> supplier) {
        return Wrapperable.makeSynchronizedArray(supplier.get());
    }

    public static <E> Wrapperable<E> makeSynchronizedArray(Supplier<E[]> supplier, Consumer<Wrapperable<E>> settings) {
        return Wrapperable.makeSynchronizedArray(settings, supplier.get());
    }

    public Wrapperable(Iterable<E> iterable, boolean isSynchronized) {
        if (isSynchronized) {
            if (iterable instanceof Collection) {
                iterable = Collections.synchronizedCollection((Collection)iterable);
            } else {
                throw new UnsupportedOperationException("Cannot make synchronized instance of non collection iterable!");
            }
        }
        this.iterable = this.fixInstance(iterable);
    }

    public void add(E element) {
        if (!(this.iterable instanceof Collection)) {
            throw new UnsupportedOperationException("Cannot add to non collection iterable!");
        }
        ((Collection)this.iterable).add(element);
    }

    public void add(int index, E element) {
        if (this.iterable instanceof List) {
            ((List)this.iterable).add(index, element);
        } else {
            int count = this.size();
            if (count == 0 || index == count) {
                this.add(element);
            } else {
                Object[] elementCopy = (Object[])Array.newInstance(element.getClass(), count + 1);
                if (index < 0 || index > count) {
                    index = count;
                }
                count = 0;
                for (E e : this.iterable) {
                    if (count == index) {
                        elementCopy[count] = element;
                        ++count;
                    }
                    elementCopy[count] = e;
                    ++count;
                }
                this.set(elementCopy);
            }
        }
    }

    public void addAll(Iterable<E> other) {
        if (this.iterable instanceof Collection) {
            Collection c = (Collection)this.iterable;
            if (other instanceof Wrapperable) {
                c.addAll(((Wrapperable)other).get());
                return;
            }
            if (other instanceof Collection) {
                c.addAll((Collection)other);
                return;
            }
        }
        for (E element : other) {
            this.add(element);
        }
    }

    public void clear() {
        if (!(this.iterable instanceof Collection)) {
            throw new UnsupportedOperationException("Cannot clear non collection iterable!");
        }
        ((Collection)this.iterable).clear();
    }

    public Wrapperable<E> copyNotMatching(Supplier<Wrapperable<E>> supplier, Function<E, Boolean> matcher) {
        Wrapperable<E> w = supplier.get();
        for (E element : this) {
            if (!matcher.apply(element).booleanValue()) continue;
            w.add(element);
        }
        return w;
    }

    protected Iterable<E> fixInstance(Iterable<E> itr) {
        if (itr instanceof Mappable) {
            TILRef.logWarn("Returning the entry set a mappable instance as an iterator!", new Object[0]);
            return ((Mappable)itr).entrySet();
        }
        if (itr instanceof Wrapperable) {
            return this.fixInstanceInner((Wrapperable)itr);
        }
        return itr;
    }

    private Iterable<E> fixInstanceInner(Wrapperable<E> parent) {
        Iterable<E> next = parent.iterable;
        if (next instanceof Wrapperable) {
            return this.fixInstanceInner((Wrapperable)next);
        }
        return next;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.iterable.forEach(action);
    }

    public Collection<E> get() {
        if (this.iterable instanceof Collection) {
            return (Collection)this.iterable;
        }
        throw new UnsupportedOperationException("Cannot get non collection iterable!");
    }

    @Nullable
    public E get(int index) {
        if (this.iterable instanceof List) {
            return ((List)this.iterable).get(index);
        }
        int count = this.size();
        if (index < 0 || index > count) {
            index = count;
        }
        for (E element : this.get()) {
            if (count == index) {
                return element;
            }
            ++count;
        }
        return null;
    }

    public List<E> getAsList() throws ClassCastException {
        return this.getAsType(List.class, null);
    }

    public List<E> getAsList(Function<Wrapperable<E>, ? extends List<E>> onCastException) {
        return this.getAsType(List.class, onCastException);
    }

    public List<E> getAsSynchronizedList() throws ClassCastException {
        return this.getAsType(List.class, null);
    }

    public List<E> getAsSynchronizedList(Function<Wrapperable<E>, ? extends List<E>> onCastException) {
        return this.getAsType(List.class, onCastException);
    }

    public Set<E> getAsSet() throws ClassCastException {
        return this.getAsType(Set.class, null);
    }

    public Set<E> getAsSet(Function<Wrapperable<E>, ? extends Set<E>> onCastException) {
        return this.getAsType(Set.class, onCastException);
    }

    public <T extends Collection<E>> T getAsType(Class<T> clazz) throws ClassCastException {
        return this.getAsType(clazz, null);
    }

    public <T extends Collection<E>> T getAsType(Class<T> clazz, @Nullable Function<Wrapperable<E>, ? extends Collection<E>> onCastException) {
        try {
            return (T)((Collection)clazz.cast(this.iterable));
        }
        catch (Exception ex) {
            String base = "Failed to cast backend iterable instance to ";
            if (Objects.isNull(onCastException)) {
                throw new ClassCastException(base + clazz.getName() + "! No input exception handler is present");
            }
            TILRef.logError("{}{}! Input exception handler will be called", base, clazz, ex);
            return (T)onCastException.apply(this);
        }
    }

    public Class<?> getElementClass() {
        E element = this.getNonNullElement();
        if (Objects.isNull(element)) {
            TILRef.logWarn("Unable to get the element class of a wrapperable instance! Is the instance empty?", new Object[0]);
            return Object.class;
        }
        return element.getClass();
    }

    @Nullable
    public E getFirstEquals(@Nullable Iterable<E> otherItr) {
        return (E)this.getFirstMatching(otherItr, Objects::equals);
    }

    @Nullable
    public E getFirstMatching(@Nullable Iterable<E> otherItr, BiFunction<E, E, Boolean> matcherFunc) {
        if (Objects.isNull(otherItr)) {
            return null;
        }
        for (E element : this) {
            for (E otherElement : otherItr) {
                if (!matcherFunc.apply(element, otherElement).booleanValue()) continue;
                return element;
            }
        }
        return null;
    }

    @Nullable
    public E getNonNullElement() {
        E element = null;
        for (E e : this.get()) {
            if (!Objects.nonNull(e)) continue;
            element = e;
            break;
        }
        return element;
    }

    public void insertMatching(Collection<E> output, Function<E, Boolean> matcher) {
        this.forEach((Consumer<? super E>)((Consumer<Object>)val -> {
            if (((Boolean)matcher.apply(val)).booleanValue()) {
                output.add(val);
            }
        }));
    }

    public <C extends Collection<E>> C insertMatching(Supplier<C> outputSupplier, Function<E, Boolean> matcher) {
        Collection output = (Collection)outputSupplier.get();
        this.forEach((Consumer<? super E>)((Consumer<Object>)val -> {
            if (((Boolean)matcher.apply(val)).booleanValue()) {
                output.add(val);
            }
        }));
        return (C)output;
    }

    public boolean isEmpty() {
        return this.iterable instanceof Collection ? ((Collection)this.iterable).isEmpty() : this.size() == 0;
    }

    public boolean isList() {
        return this.iterable instanceof List;
    }

    public boolean isNotEmpty() {
        return this.iterable instanceof Collection ? !((Collection)this.iterable).isEmpty() : this.size() >= 0;
    }

    public boolean isSet() {
        return this.iterable instanceof Set;
    }

    public boolean isUnique() {
        return !this.isList() && !this.isSet();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.iterable.iterator();
    }

    public <M> Wrapperable<M> map(Supplier<Wrapperable<M>> supplier, Function<E, M> mapper) {
        Wrapperable wrapperable = supplier.get();
        this.forEach((Consumer<? super E>)((Consumer<Object>)e -> wrapperable.add(mapper.apply(e))));
        return wrapperable;
    }

    public <M> void mapTo(Wrapperable<M> w, Function<E, M> mapper, boolean clearExisting, boolean removeNulls) {
        if (clearExisting) {
            w.clear();
        }
        this.forEach((Consumer<? super E>)((Consumer<Object>)e -> {
            Object mapped = mapper.apply(e);
            if (Objects.nonNull(mapped)) {
                w.add(mapped);
            }
        }));
    }

    public <M> void mapTo(Collection<M> c, Function<E, M> mapper, boolean clearExisting, boolean removeNulls) {
        if (clearExisting) {
            c.clear();
        }
        this.forEach((Consumer<? super E>)((Consumer<Object>)e -> {
            Object mapped = mapper.apply(e);
            if (Objects.nonNull(mapped)) {
                c.add(mapped);
            }
        }));
    }

    public <M, C extends Collection<M>> C mapTo(Supplier<C> supplier, Function<E, M> mapper, boolean removeNulls) {
        Collection c = (Collection)supplier.get();
        this.mapTo(c, mapper, false, removeNulls);
        return (C)c;
    }

    public Stream<E> parallelStream() {
        if (this.iterable instanceof Collection) {
            return ((Collection)this.iterable).parallelStream();
        }
        return StreamSupport.stream(this.spliterator(), true);
    }

    public void remove(E element) {
        if (this.iterable instanceof Collection) {
            ((Collection)this.iterable).remove(element);
        }
    }

    public boolean removeIf(Predicate<? super E> filter) {
        if (this.iterable instanceof Collection) {
            return ((Collection)this.iterable).removeIf(filter);
        }
        Objects.requireNonNull(filter);
        boolean removed = false;
        Iterator<E> itr = this.iterator();
        while (itr.hasNext()) {
            if (!filter.test(itr.next())) continue;
            itr.remove();
            removed = true;
        }
        return removed;
    }

    public void removeAll(Iterable<E> other) {
        if (this.iterable instanceof Collection) {
            Collection c = (Collection)this.iterable;
            if (other instanceof Wrapperable) {
                c.removeAll(((Wrapperable)other).get());
                return;
            }
            if (other instanceof Collection) {
                c.removeAll((Collection)other);
                return;
            }
        }
        for (E element : other) {
            this.remove(element);
        }
    }

    public void removeIndex(int index) {
        if (this.iterable instanceof List) {
            ((List)this.iterable).remove(index);
        } else {
            int count = this.size() - 1;
            if (count <= 0) {
                this.clear();
            }
            E removal = null;
            if (index < 0 || index > count) {
                index = count;
            }
            count = 0;
            for (E e : this.iterable) {
                if (count == index) {
                    removal = e;
                    break;
                }
                ++count;
            }
            if (Objects.nonNull(removal)) {
                this.remove(removal);
            } else {
                TILRef.logDebug("Failed to remove null element of wrapperable instance", new Object[0]);
            }
        }
    }

    public final void set(E ... elements) {
        this.set(true, Arrays.asList(elements));
    }

    public final void set(boolean clearExisting, E ... elements) {
        this.set(clearExisting, Arrays.asList(elements));
    }

    public void set(Iterable<E> elements) {
        this.set(true, elements);
    }

    public void set(boolean clearExisting, Iterable<E> elements) {
        if (this.iterable instanceof Collection) {
            Collection c = (Collection)this.iterable;
            if (clearExisting) {
                c.clear();
            }
            if (elements instanceof Collection) {
                c.addAll((Collection)elements);
            } else {
                elements.forEach(c::add);
            }
        } else {
            throw new UnsupportedOperationException("Cannot set elements for non collection iterable!");
        }
    }

    public int size() {
        if (this.iterable instanceof Collection) {
            return ((Collection)this.iterable).size();
        }
        AtomicInteger counter = new AtomicInteger();
        this.iterable.forEach((? super T e) -> counter.addAndGet(1));
        return counter.get();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.iterable.spliterator();
    }

    public Stream<E> stream() {
        if (this.iterable instanceof Collection) {
            return ((Collection)this.iterable).stream();
        }
        return StreamSupport.stream(this.spliterator(), false);
    }

    public E[] toArray() {
        return (Object[])Array.newInstance(this.getElementClass(), this.size());
    }

    public String toString() {
        return this.iterable.toString();
    }
}

