/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.jetbrains.annotations.Nullable;

public abstract class ModHelperAPI {
    protected final CoreAPI.GameVersion version;
    protected final CoreAPI.ModLoader loader;
    protected final CoreAPI.Side side;
    protected final Map<String, ModAPI> supportedMods;

    protected ModHelperAPI(CoreAPI.GameVersion version, CoreAPI.ModLoader loader, CoreAPI.Side side) {
        this.version = version;
        this.loader = loader;
        this.side = side;
        this.supportedMods = this.addSupportedMods(new HashMap<String, ModAPI>());
    }

    protected void addMod(Map<String, ModAPI> map, @Nullable ModAPI mod) {
        String id;
        if (Objects.nonNull(mod) && mod.isCompatible(this.loader, this.side, this.version) && TextHelper.isNotBlank(id = mod.getID())) {
            map.put(id, mod);
        }
    }

    protected abstract Map<String, ModAPI> addSupportedMods(Map<String, ModAPI> var1);

    @Nullable
    public ModAPI getMod(String modid) {
        return this.isModLoaded(modid) ? this.supportedMods.get(modid) : null;
    }

    public String getModName(String modid) {
        ModAPI mod = this.getMod(modid);
        return Objects.nonNull(mod) ? mod.getName() : modid;
    }

    public abstract boolean isModLoaded(String var1);

    @Generated
    public Map<String, ModAPI> getSupportedMods() {
        return this.supportedMods;
    }
}

