/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.EntityAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModAPI;
import org.jetbrains.annotations.Nullable;

public abstract class InfernalMobsAPI
implements ModAPI {
    public static final String MODID = "infernalmobs";
    public static final String NAME = "Infernal Mobs";

    protected InfernalMobsAPI() {
    }

    @Override
    public String getID() {
        return MODID;
    }

    @Nullable
    public abstract InfernalData<?> getInfernalData(EntityAPI<?, ?> var1);

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCompatible(CoreAPI.ModLoader loader, CoreAPI.Side side, CoreAPI.GameVersion version) {
        return loader.isForge() || loader.isNeoForge() && (version.isV21() || version.isV20() && version != CoreAPI.GameVersion.V20_1);
    }

    @IndirectCallers
    public boolean isInfernal(EntityAPI<?, ?> entity) {
        return Objects.nonNull(this.getInfernalData(entity));
    }

    public static class InfernalData<I> {
        private final I instance;
        private final String name;
        private final Collection<String> displayNames;
        private final int size;
        private final BiFunction<I, Class<?>, Boolean> modClassChecker;

        public InfernalData(I instance, String name, String[] displayNames, int size, BiFunction<I, Class<?>, Boolean> modClassChecker) {
            this.instance = instance;
            this.name = name;
            this.displayNames = new HashSet<String>(Arrays.asList(displayNames));
            this.size = size;
            this.modClassChecker = modClassChecker;
        }

        @IndirectCallers
        public boolean hasModifierClass(Class<?> clazz) {
            return this.modClassChecker.apply(this.instance, clazz);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Collection<String> getDisplayNames() {
            return this.displayNames;
        }

        @Generated
        public int getSize() {
            return this.size;
        }
    }
}

