/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.integration;

import java.util.Arrays;
import java.util.Collection;
import mods.thecomputerizer.theimpossiblelibrary.api.common.entity.PlayerAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.integration.ModAPI;

public abstract class GameStagesAPI
implements ModAPI {
    public static final String MODID = "gamestages";
    public static final String NAME = "Game Stages";

    protected GameStagesAPI() {
    }

    @Override
    public String getID() {
        return MODID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public abstract Collection<String> getStages(PlayerAPI<?, ?> var1);

    public boolean hasStage(PlayerAPI<?, ?> player, String stage) {
        return this.getStages(player).contains(stage);
    }

    @IndirectCallers
    public boolean hasAllStages(PlayerAPI<?, ?> player, String ... stages) {
        return this.hasAllStages(player, Arrays.asList(stages));
    }

    public boolean hasAllStages(PlayerAPI<?, ?> player, Iterable<String> stages) {
        Collection<String> playerStages = this.getStages(player);
        for (String stage : stages) {
            if (playerStages.contains(stage)) continue;
            return false;
        }
        return true;
    }

    @IndirectCallers
    public boolean hasAnyStage(PlayerAPI<?, ?> player, String ... stages) {
        return this.hasAnyStage(player, Arrays.asList(stages));
    }

    public boolean hasAnyStage(PlayerAPI<?, ?> player, Iterable<String> stages) {
        Collection<String> playerStages = this.getStages(player);
        for (String stage : stages) {
            if (!playerStages.contains(stage)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatible(CoreAPI.ModLoader loader, CoreAPI.Side side, CoreAPI.GameVersion version) {
        return version.isCompatibleForge() && loader.isForge();
    }

    @IndirectCallers
    public boolean missingStage(PlayerAPI<?, ?> player, String stage) {
        return !this.hasStage(player, stage);
    }

    @IndirectCallers
    public boolean missingAllStages(PlayerAPI<?, ?> player, String ... stages) {
        return this.missingAllStages(player, Arrays.asList(stages));
    }

    public boolean missingAllStages(PlayerAPI<?, ?> player, Iterable<String> stages) {
        return !this.hasAnyStage(player, stages);
    }

    @IndirectCallers
    public boolean missingAnyStage(PlayerAPI<?, ?> player, String ... stages) {
        return this.missingAnyStage(player, Arrays.asList(stages));
    }

    public boolean missingAnyStage(PlayerAPI<?, ?> player, Iterable<String> stages) {
        return !this.hasAllStages(player, stages);
    }
}

