/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import org.objectweb.asm.Type;

public class TypeHelper {
    public static Type fml(String path) {
        return TypeHelper.forge("fml/" + path);
    }

    public static Type forge(String path) {
        return TypeHelper.get("net/minecraftforge/" + path);
    }

    public static Type fromBinary(String binaryClasspath) {
        return TypeHelper.get(binaryClasspath.replace('.', '/'));
    }

    public static Type get(Class<?> c) {
        return TypeHelper.fromBinary(c.getName());
    }

    public static Type get(String className) {
        return Type.getType((String)("L" + className + ";"));
    }

    public static Type inner(Type type, String name) {
        return TypeHelper.fromBinary(type.getClassName() + "$" + name);
    }

    public static Type lang(String path) {
        return TypeHelper.get("java/lang/" + path);
    }

    public static Type method(Class<?> returnClass) {
        return TypeHelper.method(returnClass, new Type[0]);
    }

    public static Type method(Type returnType) {
        return TypeHelper.method(returnType, new Type[0]);
    }

    public static Type method(Class<?> returnClass, Class<?> ... args) {
        return TypeHelper.method(Type.getType(returnClass), args);
    }

    public static Type method(Class<?> returnClass, Type ... args) {
        return TypeHelper.method(Type.getType(returnClass), args);
    }

    public static Type method(Type returnType, Class<?> ... args) {
        Type[] argTypes = new Type[args.length];
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = Type.getType(args[i]);
        }
        return TypeHelper.method(returnType, argTypes);
    }

    public static Type method(Type returnType, Type ... args) {
        return Type.getMethodType((Type)returnType, (Type[])args);
    }

    public static String methodDesc(Class<?> returnClass) {
        return TypeHelper.method(returnClass).getDescriptor();
    }

    public static String methodDesc(Type returnType) {
        return TypeHelper.method(returnType).getDescriptor();
    }

    @IndirectCallers
    public static String methodDesc(Class<?> returnClass, Class<?> ... args) {
        return TypeHelper.method(returnClass, args).getDescriptor();
    }

    @IndirectCallers
    public static String methodDesc(Class<?> returnClass, Type ... args) {
        return TypeHelper.method(returnClass, args).getDescriptor();
    }

    public static String methodDesc(Type returnType, Class<?> ... args) {
        return TypeHelper.method(returnType, args).getDescriptor();
    }

    @IndirectCallers
    public static String methodDesc(Type returnType, Type ... args) {
        return TypeHelper.method(returnType, args).getDescriptor();
    }

    public static Type neofml(String path) {
        return TypeHelper.neoforged("fml/" + path);
    }

    public static Type neoforge(String path) {
        return TypeHelper.neoforged("neoforge/" + path);
    }

    public static Type neoforged(String path) {
        return TypeHelper.get("net/neoforged/" + path);
    }

    @IndirectCallers
    public static Type voidMethod(Class<?> ... args) {
        return TypeHelper.method(Type.VOID_TYPE, args);
    }

    @IndirectCallers
    public static Type voidMethod(Type ... args) {
        return TypeHelper.method(Type.VOID_TYPE, args);
    }

    @IndirectCallers
    public static String voidMethodDesc(Class<?> ... args) {
        return TypeHelper.method(Type.VOID_TYPE, args).getDescriptor();
    }

    public static String voidMethodDesc(Type ... args) {
        return TypeHelper.method(Type.VOID_TYPE, args).getDescriptor();
    }

    public static Type minecraft(String path) {
        return TypeHelper.get("net/minecraft/" + path);
    }
}

