/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ASMRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.TypeHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.loader.MultiVersionModInfo;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public abstract class ModWriter {
    protected static final String EMPTY_METHOD_DESC = ASMRef.EMPTY_METHOD.getDescriptor();
    protected final CoreAPI core;
    protected final Map<String, Type> entryPointMethodTypes;
    protected final Map<String, String[]> entryPointMethods;
    protected final MultiVersionModInfo info;
    protected final String entryPointDesc;
    protected final String entryPointInternal;
    protected final String modTypeDesc;
    protected final String modTypeInternal;
    protected final Type entryPoint;
    protected final Type modType;
    protected final int javaVersion;

    protected ModWriter(CoreAPI core, MultiVersionModInfo info, int javaVersion) {
        this.core = core;
        HashMap<String, String[]> entryPointMethods = new HashMap<String, String[]>();
        HashMap<String, Type> entryPointMethodTypes = new HashMap<String, Type>();
        this.mappedEntryPointMethods(entryPointMethods, entryPointMethodTypes);
        this.entryPointMethods = Collections.unmodifiableMap(entryPointMethods);
        this.entryPointMethodTypes = Collections.unmodifiableMap(entryPointMethodTypes);
        this.info = info;
        this.entryPoint = Type.getType(info.getEntryClass());
        this.modType = this.generatedModType(info);
        this.entryPointDesc = this.entryPoint.getDescriptor();
        this.entryPointInternal = this.entryPoint.getInternalName();
        this.modTypeDesc = this.modType.getDescriptor();
        this.modTypeInternal = this.modType.getInternalName();
        this.javaVersion = javaVersion;
    }

    protected void addClassAnnotations(ClassVisitor visitor) {
    }

    protected void addEntryHooks(MethodVisitor visitor, boolean isStatic, String method, boolean codeVisited) {
        if (!codeVisited) {
            visitor.visitCode();
        }
        for (String entryMethod : this.entryPointMethods.get(method)) {
            if (isStatic) {
                visitor.visitFieldInsn(178, this.modTypeInternal, "INSTANCE", this.modTypeDesc);
            } else {
                visitor.visitVarInsn(25, 0);
            }
            visitor.visitFieldInsn(180, this.modTypeInternal, "entryPoint", this.entryPointDesc);
            visitor.visitMethodInsn(182, this.entryPointInternal, entryMethod, EMPTY_METHOD_DESC, false);
        }
    }

    protected void addFields(ClassVisitor visitor) {
        ASMHelper.addField(visitor, 9, "INSTANCE", this.modType, null, null);
        ASMHelper.addField(visitor, 17, "entryPoint", this.entryPoint, null, null);
    }

    protected Map.Entry<ClassWriter, Type> addInnerClass(ClassVisitor outerClass, String innerName, Consumer<ClassVisitor> innerWriter) {
        return this.addInnerClass(outerClass, innerName, innerWriter, true, true);
    }

    protected Map.Entry<ClassWriter, Type> addInnerClass(ClassVisitor outerClass, String innerName, Consumer<ClassVisitor> innerWriter, boolean client, boolean server) {
        Type innerType = TypeHelper.inner(this.modType, innerName);
        ClassWriter writer = ASMHelper.getWriter(this.javaVersion, 25, innerType, this.modInterfaces(client, server));
        writer.visitOuterClass(this.modTypeInternal, null, null);
        outerClass.visitInnerClass(innerType.getInternalName(), this.modTypeInternal, innerName, 25);
        innerWriter.accept((ClassVisitor)writer);
        return new AbstractMap.SimpleImmutableEntry<ClassWriter, Type>(writer, innerType);
    }

    public final List<Map.Entry<String, byte[]>> buildModClass() {
        ArrayList<Map.Entry<String, byte[]>> classBytes = new ArrayList<Map.Entry<String, byte[]>>();
        ClassWriter writer = ASMHelper.getWriter(this.javaVersion, 1, this.modType, this.modInterfaces(true, true));
        this.writeMod(writer, classBytes);
        this.finishWritingClass(writer, this.modType, (classpath, bytes) -> {
            TILRef.logDebug("Wrote bytecode for `{}` entrypoint to `{}`", this.info.getModID(), classpath);
            classBytes.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>((String)classpath, (byte[])bytes));
        });
        return classBytes;
    }

    protected void classInit(MethodVisitor clinit) {
    }

    protected void constructor(MethodVisitor constructor) {
        this.addEntryHooks(constructor, false, "<init>", true);
    }

    protected void finishWritingClass(ClassWriter writer, Type type, BiConsumer<String, byte[]> byteCodeAcceptor) {
        String classpath = ClassPrinter.getClassPath(type.getInternalName());
        try {
            byte[] bytes = ASMHelper.finishWriting(writer, type, TILDev.DEV);
            byteCodeAcceptor.accept(classpath, bytes);
        }
        catch (Throwable ex) {
            TILRef.logFatal("Failed to write bytecode for classpath {}", classpath, ex);
        }
    }

    protected MethodVisitor getConstructor(ClassVisitor visitor) {
        return ASMHelper.getConstructor(visitor, 1, new Type[0]);
    }

    private Type generatedModType(MultiVersionModInfo info) {
        String pkgName = info.getEntryClass().getPackage().getName();
        String modName = info.getName().replace(" ", "");
        return this.generatedModType(pkgName, modName, info.isClient(), info.isServer());
    }

    protected Type generatedModType(String pkgName, String modName, boolean client, boolean server) {
        String extension = "Generated" + (client ? (server ? "Common" : "Client") : (server ? "Server" : "")) + "Mod";
        return TypeHelper.fromBinary(pkgName + "." + modName + extension);
    }

    protected abstract Type getEventMethod(String var1);

    protected abstract void mappedEntryPointMethods(Map<String, String[]> var1, Map<String, Type> var2);

    protected void mapEntryPointMethod(Map<String, String[]> redirects, Map<String, Type> types, String name, Type type, String ... methods) {
        redirects.put(name, methods);
        types.put(name, type);
    }

    protected String[] modInterfaces(boolean client, boolean server) {
        return new String[0];
    }

    protected final void writeAnnotationArray(AnnotationVisitor annotation, String name, Consumer<AnnotationVisitor> arrayWriter) {
        AnnotationVisitor array = annotation.visitArray(name);
        arrayWriter.accept(array);
        array.visitEnd();
    }

    protected final void writeClassAnnotation(ClassVisitor visitor, Type type, Consumer<AnnotationVisitor> annotationWriter) {
        AnnotationVisitor annotation = ASMHelper.getAnnotation(visitor, type);
        annotationWriter.accept(annotation);
        annotation.visitEnd();
    }

    protected final void writeClassInit(ClassVisitor visitor) {
        this.addClassAnnotations(visitor);
        this.addFields(visitor);
        this.writeMethod(visitor, ASMHelper::getClassInit, this::classInit);
    }

    protected void writeConstructor(ClassVisitor visitor) {
        this.writeConstructor(visitor, constructor -> {});
    }

    protected final void writeConstructor(ClassVisitor visitor, Consumer<MethodVisitor> extraDataHandler) {
        this.writeMethod(visitor, this::getConstructor, constructor -> {
            ASMHelper.addSuperConstructor(constructor, ASMRef.OBJECT_TYPE.getInternalName(), EMPTY_METHOD_DESC, false);
            constructor.visitVarInsn(25, 0);
            ASMHelper.addNewInstance(constructor, this.entryPointInternal, EMPTY_METHOD_DESC, false);
            constructor.visitFieldInsn(181, this.modTypeInternal, "entryPoint", this.entryPointDesc);
            extraDataHandler.accept((MethodVisitor)constructor);
            constructor.visitVarInsn(25, 0);
            constructor.visitFieldInsn(179, this.modTypeInternal, "INSTANCE", this.modTypeDesc);
            this.constructor((MethodVisitor)constructor);
        });
    }

    protected void writeInnerClass(Map.Entry<ClassWriter, Type> writerPair, List<Map.Entry<String, byte[]>> classBytes) {
        this.writeInnerClass(writerPair, (String classpath, byte[] bytes) -> {
            TILRef.logDebug("Finished writing inner class {}", classpath);
            classBytes.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>((String)classpath, (byte[])bytes));
        });
    }

    protected void writeInnerClass(Map.Entry<ClassWriter, Type> writerPair, BiConsumer<String, byte[]> byteCodeAcceptor) {
        this.finishWritingClass(writerPair.getKey(), writerPair.getValue(), byteCodeAcceptor);
    }

    protected final void writeMethod(ClassVisitor visitor, Function<ClassVisitor, MethodVisitor> methodGetter, Consumer<MethodVisitor> methodWriter) {
        MethodVisitor method = methodGetter.apply(visitor);
        methodWriter.accept(method);
        method.visitInsn(177);
        ASMHelper.finishMethod(method);
    }

    protected final void writeMethodAnnotation(MethodVisitor method, Type type, Consumer<AnnotationVisitor> annotationWriter) {
        AnnotationVisitor annotation = ASMHelper.getAnnotation(method, type);
        annotationWriter.accept(annotation);
        annotation.visitEnd();
    }

    protected void writeMod(ClassWriter writer, List<Map.Entry<String, byte[]>> classBytes) {
        this.writeClassInit((ClassVisitor)writer);
        this.writeConstructor((ClassVisitor)writer);
    }

    @Generated
    public MultiVersionModInfo getInfo() {
        return this.info;
    }
}

