/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ArrayHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.AnnotationPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.BytecodePrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodPrinter
extends MethodVisitor
implements BytecodePrinter {
    protected final ClassPrinter parent;
    protected final String access;
    protected final String name;
    protected final String[] exceptions;
    protected String returnType;
    protected String parameterTypes;
    protected AnnotationPrinter[] annotations;

    protected MethodPrinter(int api, ClassPrinter parent, int access, String name, String desc, String[] exceptions) {
        super(api);
        this.parent = parent;
        this.access = ClassPrinter.parseAccess(access);
        this.name = name;
        this.exceptions = this.parseExcpections(exceptions);
        this.computeTypes(desc);
    }

    protected void computeTypes(String desc) {
        Type methodType = Type.getMethodType((String)desc);
        Map.Entry<String, String> pair = ClassPrinter.splitPackage(methodType.getReturnType().getClassName());
        this.parent.addImport(pair.getKey());
        this.returnType = pair.getValue();
        StringBuilder builder = new StringBuilder();
        StringJoiner joiner = new StringJoiner(", ");
        for (Type type : methodType.getArgumentTypes()) {
            pair = ClassPrinter.splitPackage(type.getClassName());
            this.parent.addImport(pair.getKey());
            String name = pair.getValue();
            if (TextHelper.isBlank(name)) {
                joiner.add(name + " ?");
                continue;
            }
            char varChar = name.toLowerCase().charAt(0);
            int charCount = 0;
            String toString = builder.toString();
            for (int i = 0; i < toString.length(); ++i) {
                if (toString.charAt(i) != varChar) continue;
                ++charCount;
            }
            builder.append(varChar);
            joiner.add(name + " " + varChar + (charCount == 0 ? "" : Integer.valueOf(charCount)));
        }
        this.parameterTypes = joiner.toString();
    }

    protected void getAnnotationLines(Collection<String> lines, int tabs) {
        if (ArrayHelper.isNotEmpty(this.annotations)) {
            for (AnnotationPrinter annotation : this.annotations) {
                annotation.toLines(lines, tabs);
            }
        }
    }

    protected String getMethodHeader() {
        switch (this.name) {
            case "<clinit>": {
                return "static";
            }
            case "<init>": {
                return this.access + " " + this.parent.getName() + "(" + this.parameterTypes + ")";
            }
        }
        return this.access + " " + this.returnType + " " + this.name + "(" + this.parameterTypes + ")";
    }

    protected AnnotationPrinter parseAnnotation(String desc) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(desc));
        this.parent.addImport(pkgPair.getKey());
        AnnotationPrinter printer = new AnnotationPrinter(this.api, this.parent, pkgPair.getValue());
        this.annotations = ArrayHelper.append(this.annotations, printer, false);
        return printer;
    }

    protected String[] parseExcpections(String[] exceptions) {
        if (Objects.nonNull(exceptions)) {
            for (int i = 0; i < exceptions.length; ++i) {
                Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(exceptions[i]));
                this.parent.addImport(pkgPair.getKey());
                exceptions[i] = pkgPair.getValue();
            }
            return exceptions;
        }
        return new String[0];
    }

    @Override
    public void toLines(Collection<String> lines, int tabs) {
        this.getAnnotationLines(lines, tabs);
        lines.add(TextHelper.withTabs(this.getMethodHeader() + " {}", tabs));
        lines.add("");
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.parseAnnotation(desc);
    }
}

