/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core.asm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.BytecodePrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.core.asm.ClassPrinter;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import org.objectweb.asm.AnnotationVisitor;

public class AnnotationPrinter
extends AnnotationVisitor
implements BytecodePrinter {
    protected final ClassPrinter parent;
    protected final String name;
    protected Map<String, Object> values;

    protected AnnotationPrinter(int api, ClassPrinter parent, String name) {
        super(api);
        this.parent = parent;
        this.name = name;
    }

    protected void addValue(String name, Object value) {
        if (Objects.isNull(this.values)) {
            this.values = new HashMap<String, Object>();
        }
        this.values.put(name, value.toString());
    }

    protected String getValueStr(Object value, int tabs) {
        if (value instanceof BytecodePrinter) {
            ArrayList<String> lines = new ArrayList<String>();
            ((BytecodePrinter)value).toLines(lines, tabs);
            return TextHelper.fromIterable(lines, "");
        }
        return value instanceof String ? "\"" + value + "\"" : value.toString();
    }

    protected AnnotationPrinter parseAnnotation(String desc) {
        Map.Entry<String, String> pkgPair = ClassPrinter.splitPackage(ClassPrinter.getClassPath(desc));
        this.parent.addImport(pkgPair.getKey());
        return new AnnotationPrinter(this.api, this.parent, pkgPair.getValue());
    }

    @Override
    public void toLines(Collection<String> lines, int tabs) {
        StringJoiner valueJoiner = new StringJoiner(", ");
        if (Objects.nonNull(this.values)) {
            for (Map.Entry<String, Object> value : this.values.entrySet()) {
                valueJoiner.add(value.getKey() + " = " + this.getValueStr(value.getValue(), tabs));
            }
        }
        String values = valueJoiner.toString();
        lines.add(TextHelper.withTabs("@" + this.name + (values.isEmpty() ? "" : "(" + values + ")"), tabs));
    }

    public void visit(String name, Object value) {
        this.addValue(name, value);
    }

    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        AnnotationPrinter printer = this.parseAnnotation(descriptor);
        this.addValue(name, printer);
        return printer;
    }
}

