/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreEntryPoint;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.MultiVersionCoreMod;
import org.objectweb.asm.tree.ClassNode;

@MultiVersionCoreMod(modid="theimpossiblelibrary", modName="The Impossible Library", modVersion="0.4.5")
public final class TILCoreEntryPoint
extends CoreEntryPoint {
    private static TILCoreEntryPoint INSTANCE;
    private final CoreEntryPoint versionHandler;

    private static void devTrace(String msg, Object ... args) {
        TILRef.logInfo("[TILCoreEntryPoint Trace]: " + msg, args);
    }

    public static TILCoreEntryPoint getInstance() {
        if (Objects.isNull(INSTANCE)) {
            INSTANCE = new TILCoreEntryPoint();
        }
        return INSTANCE;
    }

    public TILCoreEntryPoint() {
        TILCoreEntryPoint.devTrace("constructor", new Object[0]);
        this.versionHandler = CoreAPI.getInstance().getCoreVersionHandler();
    }

    @Override
    public List<String> classTargets() {
        return Objects.nonNull(this.versionHandler) ? this.versionHandler.classTargets() : Collections.emptyList();
    }

    @Override
    public ClassNode editClass(ClassNode classNode) {
        return Objects.nonNull(this.versionHandler) ? this.versionHandler.editClass(classNode) : classNode;
    }

    @Override
    public String getCoreID() {
        return "theimpossiblelibrary_core";
    }

    @Override
    public String getCoreName() {
        return "The Impossible Library Core";
    }
}

