/*
 * Decompiled with CFR 0.152.
 */
package mods.thecomputerizer.theimpossiblelibrary.api.core;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.function.Function;
import mods.thecomputerizer.theimpossiblelibrary.api.core.ClassHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.core.CoreAPI;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILDev;
import mods.thecomputerizer.theimpossiblelibrary.api.core.TILRef;
import mods.thecomputerizer.theimpossiblelibrary.api.core.annotation.IndirectCallers;
import mods.thecomputerizer.theimpossiblelibrary.api.text.TextHelper;
import mods.thecomputerizer.theimpossiblelibrary.api.util.Misc;
import org.jetbrains.annotations.Nullable;

public class ReflectionHelper {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    @IndirectCallers
    @Nullable
    public static Constructor<?> findConstructor(@Nullable Class<?> clazz, Class<?> ... args) {
        if (Objects.isNull(clazz)) {
            return null;
        }
        try {
            return clazz.getConstructor(args);
        }
        catch (NoSuchMethodException ex) {
            try {
                return clazz.getDeclaredConstructor(args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                TILRef.logError("Unable to find constructor of class `{}` with args `{}`", clazz, args);
                return null;
            }
        }
    }

    @Nullable
    public static Class<?> findExtensibleClass(String name, Class<?> superClass) {
        Class<?> clazz = ClassHelper.findClass(name);
        return Objects.nonNull(clazz) && superClass.isAssignableFrom(clazz) ? clazz : null;
    }

    @IndirectCallers
    public static MethodHandle findMethodHandle(@Nullable String className, String name, Class<?> ... args) {
        return ReflectionHelper.findMethodHandle(TextHelper.isBlank(className) ? null : ClassHelper.findClass(className), name, args);
    }

    public static MethodHandle findMethodHandle(@Nullable Class<?> clazz, String name, Class<?> ... args) {
        if (Objects.isNull(clazz)) {
            TILRef.logError("Cannot find method handle of null class!", new Object[0]);
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod(name, args);
            method.setAccessible(true);
            return LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException | NoSuchMethodException ex) {
            TILRef.logError("Unable to find method handle of name `{}` in class `{}` with args `{}`", name, clazz, args, ex);
            return null;
        }
    }

    @Nullable
    public static Field getField(@Nullable String className, String fieldName) {
        return ReflectionHelper.getField(TextHelper.isBlank(className) ? null : ClassHelper.findClass(className), fieldName);
    }

    @Nullable
    public static Field getField(@Nullable Class<?> clazz, String fieldName) {
        return Misc.applyNullable(clazz, c -> {
            try {
                return c.getField(fieldName);
            }
            catch (NoSuchFieldException ignored) {
                try {
                    return c.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException ex) {
                    TILRef.logError("Could not find field of name {} in class {}!", fieldName, c, ex);
                    return null;
                }
            }
        });
    }

    @Nullable
    public static <T> T getFieldInstance(@Nullable Field field) {
        return ReflectionHelper.getFieldInstance(null, field);
    }

    @Nullable
    public static <T> T getFieldInstance(@Nullable Class<?> clazz, String fieldName) {
        return ReflectionHelper.getFieldInstance(null, ReflectionHelper.getField(clazz, fieldName));
    }

    @Nullable
    public static <T> T getFieldInstance(@Nullable Object parent, @Nullable Class<?> clazz, String fieldName) {
        return ReflectionHelper.getFieldInstance(parent, ReflectionHelper.getField(clazz, fieldName));
    }

    @Nullable
    public static <T> T getFieldInstance(@Nullable Object parent, @Nullable Field field) {
        return (T)Misc.applyNullable(field, f -> {
            try {
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                return f.get(parent);
            }
            catch (IllegalAccessException ex) {
                TILRef.logError("Failed to retrieve instance of field {} of type {} from parent {} of class {}", f, Misc.getNullable(f, f.getType(), "null"), parent, Misc.getNullable(parent, parent.getClass(), "null"));
                return null;
            }
        });
    }

    @IndirectCallers
    public static Class<?> getInnerClass(Class<?> clazz, @Nullable String name) {
        return Misc.applyNullable(name, s -> {
            for (Class<?> categoryClass : clazz.getDeclaredClasses()) {
                if (!categoryClass.getSimpleName().matches((String)s)) continue;
                return categoryClass;
            }
            return null;
        });
    }

    @Nullable
    public static Field getMappedField(@Nullable Class<?> clazz, String named, String intermediary, @Nullable Class<?> desc) {
        return ReflectionHelper.getMappedField(clazz, TILDev.DEV ? named : intermediary, desc);
    }

    @Nullable
    public static Field getMappedField(@Nullable Class<?> clazz, String fieldName, @Nullable Class<?> desc) {
        if (Objects.isNull(clazz) || Objects.isNull(desc)) {
            return null;
        }
        String descName = "L" + desc.getName().replace('.', '/') + ";";
        return ReflectionHelper.getField(clazz, CoreAPI.getInstance().mapFieldName(clazz.getName(), fieldName, descName));
    }

    @Nullable
    public static <T> T getMappedFieldInstance(@Nullable Class<?> clazz, String named, String intermediary, @Nullable Class<?> desc) {
        return ReflectionHelper.getMappedFieldInstance(null, clazz, TILDev.DEV ? named : intermediary, desc);
    }

    @IndirectCallers
    @Nullable
    public static <T> T getMappedFieldInstance(@Nullable Class<?> clazz, String fieldName, @Nullable Class<?> desc) {
        return ReflectionHelper.getMappedFieldInstance(null, clazz, fieldName, desc);
    }

    @IndirectCallers
    @Nullable
    public static <T> T getMappedFieldInstance(@Nullable Object parent, @Nullable Class<?> clazz, String named, String intermediary, @Nullable Class<?> desc) {
        return ReflectionHelper.getMappedFieldInstance(parent, clazz, TILDev.DEV ? named : intermediary, desc);
    }

    @Nullable
    public static <T> T getMappedFieldInstance(@Nullable Object parent, @Nullable Class<?> clazz, String fieldName, @Nullable Class<?> desc) {
        return ReflectionHelper.getFieldInstance(parent, ReflectionHelper.getMappedField(clazz, fieldName, desc));
    }

    @IndirectCallers
    @Nullable
    public static Method getMethod(@Nullable String className, String name, Class<?> ... argTypes) {
        return ReflectionHelper.getMethod(TextHelper.isBlank(className) ? null : ClassHelper.findClass(className), name, argTypes);
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> clazz, String name, Class<?> ... argTypes) {
        return Misc.applyNullable(clazz, c -> {
            try {
                return c.getMethod(name, argTypes);
            }
            catch (NoSuchMethodException ignored) {
                try {
                    return c.getDeclaredMethod(name, argTypes);
                }
                catch (NoSuchMethodException ex) {
                    TILRef.logError("Failed to find method of name {} in class {} with args {}", name, clazz, argTypes);
                    return null;
                }
            }
        });
    }

    @Nullable
    public static <T> T invokeHandle(@Nullable MethodHandle handle, @Nullable Object invoker, Object ... args) {
        if (Objects.isNull(handle)) {
            TILDev.logInfo("Trying to invoke null method handle", new Object[0]);
        }
        return (T)Misc.applyNullable(handle, mh -> {
            try {
                return mh.invoke(invoker, args);
            }
            catch (Throwable t) {
                TILRef.logError("Failed to invoke method handle {} with invoker {} and args {}", mh, invoker, args, t);
                return null;
            }
        });
    }

    @Nullable
    public static <T> T invokeMethod(@Nullable Method method, @Nullable Object invoker, Object ... args) {
        if (Objects.isNull(method)) {
            TILDev.logInfo("Trying to invoke null method", new Object[0]);
        }
        return (T)Misc.applyNullable(method, m -> {
            try {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
                return m.invoke(invoker, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                TILRef.logError("Failed to invoke method {} with invoker {} and args {}", m, invoker, args, ex);
                return null;
            }
        });
    }

    @Nullable
    public static <T> T invokeMethod(@Nullable Class<?> clazz, String name, @Nullable Object invoker, Class<?>[] argTypes, Object ... args) {
        return ReflectionHelper.invokeMethod(ReflectionHelper.getMethod(clazz, name, argTypes), invoker, args);
    }

    @Nullable
    public static <T> T invokeMethod(@Nullable String className, String name, @Nullable Function<Class<?>, Object> invokerFunc, Class<?>[] argTypes, Object ... args) {
        if (TextHelper.isBlank(className)) {
            TILRef.logError("Tried to invoke method {} with null class name", name);
            return null;
        }
        Class<?> clazz = ClassHelper.findClass(className);
        return ReflectionHelper.invokeMethod(clazz, name, Objects.nonNull(invokerFunc) ? invokerFunc.apply(clazz) : null, argTypes, args);
    }

    @IndirectCallers
    @Nullable
    public static <T> T invokeStaticHandle(@Nullable MethodHandle handle, Object ... args) {
        return ReflectionHelper.invokeHandle(handle, null, args);
    }

    @IndirectCallers
    @Nullable
    public static <T> T invokeStaticMethod(@Nullable Method method, Object ... args) {
        return ReflectionHelper.invokeMethod(method, null, args);
    }

    @Nullable
    public static <T> T invokeStaticMethod(@Nullable Class<T> clazz, String name, Class<?>[] argTypes, Object ... args) {
        return ReflectionHelper.invokeMethod(clazz, name, null, argTypes, args);
    }

    @IndirectCallers
    @Nullable
    public static <T> T invokeStaticMethod(@Nullable String className, String name, Class<?>[] argTypes, Object ... args) {
        return ReflectionHelper.invokeMethod(className, name, null, argTypes, args);
    }

    public static void modifyFinalField(@Nullable Object parent, @Nullable Field field, @Nullable Object value) {
        if (Objects.isNull(field)) {
            return;
        }
        int modifiers = field.getModifiers();
        boolean isFinal = Modifier.isFinal(modifiers);
        if (isFinal) {
            ReflectionHelper.setFieldModifiers(field, modifiers & 0xFFFFFFEF);
        }
        ReflectionHelper.setFieldValue(parent, field, value);
        if (isFinal) {
            ReflectionHelper.setFieldModifiers(field, modifiers);
        }
    }

    @IndirectCallers
    public static void setFieldInstance(Class<?> clazz, String name, Object instance, Object value) {
        ReflectionHelper.setFieldInstance(false, clazz, name, instance, value);
    }

    public static void setFieldInstance(boolean isFinal, Class<?> clazz, String name, Object instance, Object value) {
        Field field = ReflectionHelper.getField(clazz, name);
        if (isFinal) {
            ReflectionHelper.modifyFinalField(instance, field, value);
        } else {
            ReflectionHelper.setFieldInstance(field, instance, value);
        }
    }

    public static void setFieldInstance(@Nullable Field field, Object instance, Object value) {
        if (Objects.nonNull(field)) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException ex) {
                TILRef.logError("Failed to set value of field to {}", value, ex);
            }
        } else {
            TILRef.logError("Cannot set value of null field!", new Object[0]);
        }
    }

    public static void setFieldModifiers(@Nullable Field field, int modifiers) {
        if (Objects.nonNull(field)) {
            ReflectionHelper.setFieldValue(field, ReflectionHelper.getField(Field.class, "modifiers"), modifiers);
        } else {
            TILRef.logError("Cannot change the modifiers of null field", new Object[0]);
        }
    }

    public static void setFieldValue(@Nullable Object parent, @Nullable Field field, @Nullable Object value) {
        if (Objects.isNull(field)) {
            return;
        }
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            field.set(parent, value);
        }
        catch (IllegalAccessException ex) {
            Object[] objectArray;
            boolean hasParent = Objects.nonNull(parent);
            if (hasParent) {
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = field;
                objectArray2[1] = parent;
                objectArray2[2] = value;
                objectArray = objectArray2;
                objectArray2[3] = ex;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = field;
                objectArray3[1] = value;
                objectArray = objectArray3;
                objectArray3[2] = ex;
            }
            Object[] args = objectArray;
            TILRef.logError("Unable to set value of field {} " + (hasParent ? "in parent object {}}" : "") + " to {}", args);
        }
    }
}

